/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class BackgroundInitializerTest
extends TestCase {
    private void checkInitialize(BackgroundInitializerTestImpl init) {
        try {
            Integer result = (Integer)init.get();
            BackgroundInitializerTest.assertEquals((String)"Wrong result", (int)1, (int)result);
            BackgroundInitializerTest.assertEquals((String)"Wrong number of invocations", (int)1, (int)init.initializeCalls);
            BackgroundInitializerTest.assertNotNull((String)"No future", (Object)init.getFuture());
        }
        catch (ConcurrentException cex) {
            BackgroundInitializerTest.fail((String)("Unexpected exception: " + (Object)((Object)cex)));
        }
    }

    public void testInitialize() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
    }

    public void testGetActiveExecutorBeforeStart() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        BackgroundInitializerTest.assertNull((String)"Got an executor", (Object)init.getActiveExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetActiveExecutorExternal() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
            init.start();
            BackgroundInitializerTest.assertSame((String)"Wrong executor", (Object)exec, (Object)init.getActiveExecutor());
            this.checkInitialize(init);
        }
        finally {
            exec.shutdown();
        }
    }

    public void testGetActiveExecutorTemp() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        BackgroundInitializerTest.assertNotNull((String)"No active executor", (Object)init.getActiveExecutor());
        this.checkInitialize(init);
    }

    public void testInitializeTempExecutor() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        BackgroundInitializerTest.assertTrue((String)"Wrong result of start()", (boolean)init.start());
        this.checkInitialize(init);
        BackgroundInitializerTest.assertTrue((String)"Executor not shutdown", (boolean)init.getActiveExecutor().isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetExternalExecutor() throws Exception {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
            init.setExternalExecutor(exec);
            BackgroundInitializerTest.assertEquals((String)"Wrong executor service", (Object)exec, (Object)init.getExternalExecutor());
            BackgroundInitializerTest.assertTrue((String)"Wrong result of start()", (boolean)init.start());
            BackgroundInitializerTest.assertSame((String)"Wrong active executor", (Object)exec, (Object)init.getActiveExecutor());
            this.checkInitialize(init);
            BackgroundInitializerTest.assertFalse((String)"Executor was shutdown", (boolean)exec.isShutdown());
        }
        finally {
            exec.shutdown();
        }
    }

    public void testSetExternalExecutorAfterStart() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        try {
            init.setExternalExecutor(Executors.newSingleThreadExecutor());
            BackgroundInitializerTest.fail((String)"Could set executor after start()!");
        }
        catch (IllegalStateException istex) {
            init.get();
        }
    }

    public void testStartMultipleTimes() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        BackgroundInitializerTest.assertTrue((String)"Wrong result for start()", (boolean)init.start());
        for (int i = 0; i < 10; ++i) {
            BackgroundInitializerTest.assertFalse((String)"Could start again", (boolean)init.start());
        }
        this.checkInitialize(init);
    }

    public void testGetBeforeStart() throws ConcurrentException {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        try {
            init.get();
            BackgroundInitializerTest.fail((String)"Could call get() before start()!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetRuntimeException() throws Exception {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        RuntimeException rex = new RuntimeException();
        init.ex = rex;
        init.start();
        try {
            init.get();
            BackgroundInitializerTest.fail((String)"Exception not thrown!");
        }
        catch (Exception ex) {
            BackgroundInitializerTest.assertEquals((String)"Runtime exception not thrown", (Object)rex, (Object)ex);
        }
    }

    public void testGetCheckedException() throws Exception {
        Exception ex;
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.ex = ex = new Exception();
        init.start();
        try {
            init.get();
            BackgroundInitializerTest.fail((String)"Exception not thrown!");
        }
        catch (ConcurrentException cex) {
            BackgroundInitializerTest.assertEquals((String)"Exception not thrown", (Object)ex, (Object)cex.getCause());
        }
    }

    public void testGetInterruptedException() throws Exception {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        final BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl(exec);
        final CountDownLatch latch1 = new CountDownLatch(1);
        init.shouldSleep = true;
        init.start();
        final AtomicReference iex = new AtomicReference();
        Thread getThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    init.get();
                }
                catch (ConcurrentException cex) {
                    if (cex.getCause() instanceof InterruptedException) {
                        iex.set((InterruptedException)cex.getCause());
                    }
                }
                finally {
                    Assert.assertTrue((String)"Thread not interrupted", (boolean)this.isInterrupted());
                    latch1.countDown();
                }
            }
        };
        getThread.start();
        getThread.interrupt();
        latch1.await();
        exec.shutdownNow();
        exec.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        BackgroundInitializerTest.assertNotNull((String)"No interrupted exception", iex.get());
    }

    public void testIsStartedFalse() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        BackgroundInitializerTest.assertFalse((String)"Already started", (boolean)init.isStarted());
    }

    public void testIsStartedTrue() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        BackgroundInitializerTest.assertTrue((String)"Not started", (boolean)init.isStarted());
    }

    public void testIsStartedAfterGet() {
        BackgroundInitializerTestImpl init = new BackgroundInitializerTestImpl();
        init.start();
        this.checkInitialize(init);
        BackgroundInitializerTest.assertTrue((String)"Not started", (boolean)init.isStarted());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackgroundInitializerTestImpl
    extends BackgroundInitializer<Integer> {
        Exception ex;
        boolean shouldSleep;
        volatile int initializeCalls;

        public BackgroundInitializerTestImpl() {
        }

        public BackgroundInitializerTestImpl(ExecutorService exec) {
            super(exec);
        }

        protected Integer initialize() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
            if (this.shouldSleep) {
                Thread.sleep(60000L);
            }
            return ++this.initializeCalls;
        }
    }
}

