/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorUtilsTest
extends TestCase {
    private Map<Class<?>, Class<?>[]> classCache = new HashMap();

    public ConstructorUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.classCache.clear();
    }

    public void testConstructor() throws Exception {
        ConstructorUtilsTest.assertNotNull(MethodUtils.class.newInstance());
    }

    public void testInvokeConstructor() throws Exception {
        ConstructorUtilsTest.assertEquals((String)"()", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        ConstructorUtilsTest.assertEquals((String)"()", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])null)).toString());
        ConstructorUtilsTest.assertEquals((String)"()", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[0])).toString());
        ConstructorUtilsTest.assertEquals((String)"(String)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        ConstructorUtilsTest.assertEquals((String)"(Object)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        ConstructorUtilsTest.assertEquals((String)"(Object)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE})).toString());
        ConstructorUtilsTest.assertEquals((String)"(Integer)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        ConstructorUtilsTest.assertEquals((String)"(int)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE})).toString());
        ConstructorUtilsTest.assertEquals((String)"(double)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE})).toString());
        ConstructorUtilsTest.assertEquals((String)"(double)", (String)((TestBean)ConstructorUtils.invokeConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE})).toString());
    }

    public void testInvokeExactConstructor() throws Exception {
        ConstructorUtilsTest.assertEquals((String)"()", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])ArrayUtils.EMPTY_CLASS_ARRAY)).toString());
        ConstructorUtilsTest.assertEquals((String)"()", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])null)).toString());
        ConstructorUtilsTest.assertEquals((String)"(String)", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{""})).toString());
        ConstructorUtilsTest.assertEquals((String)"(Object)", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{new Object()})).toString());
        ConstructorUtilsTest.assertEquals((String)"(Integer)", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.INTEGER_ONE})).toString());
        ConstructorUtilsTest.assertEquals((String)"(double)", (String)((TestBean)ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE})).toString());
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.BYTE_ONE});
            ConstructorUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{NumberUtils.LONG_ONE});
            ConstructorUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            ConstructorUtils.invokeExactConstructor(TestBean.class, (Object[])new Object[]{Boolean.TRUE});
            ConstructorUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetAccessibleConstructor() throws Exception {
        ConstructorUtilsTest.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
        ConstructorUtilsTest.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY)));
    }

    public void testGetAccessibleConstructorFromDescription() throws Exception {
        ConstructorUtilsTest.assertNotNull((Object)ConstructorUtils.getAccessibleConstructor(Object.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        ConstructorUtilsTest.assertNull((Object)ConstructorUtils.getAccessibleConstructor(PrivateClass.class, (Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    public void testGetMatchingAccessibleMethod() throws Exception {
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleConstructorParameterTypes(TestBean.class, this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
    }

    private void expectMatchingAccessibleConstructorParameterTypes(Class<?> cls, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Constructor c = ConstructorUtils.getMatchingAccessibleConstructor(cls, (Class[])requestTypes);
        ConstructorUtilsTest.assertTrue((String)(this.toString(c.getParameterTypes()) + " not equals " + this.toString(actualTypes)), (boolean)Arrays.equals(actualTypes, c.getParameterTypes()));
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    private static class PrivateClass {
    }

    public static class TestBean {
        private String toString;

        public TestBean() {
            this.toString = "()";
        }

        public TestBean(int i) {
            this.toString = "(int)";
        }

        public TestBean(Integer i) {
            this.toString = "(Integer)";
        }

        public TestBean(double d) {
            this.toString = "(double)";
        }

        public TestBean(String s) {
            this.toString = "(String)";
        }

        public TestBean(Object o) {
            this.toString = "(Object)";
        }

        public String toString() {
            return this.toString;
        }
    }
}

