/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.reflect.MethodUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodUtilsTest
extends TestCase {
    private TestBean testBean;
    private Map<Class<?>, Class<?>[]> classCache = new HashMap();

    public MethodUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testBean = new TestBean();
        this.classCache.clear();
    }

    public void testConstructor() throws Exception {
        MethodUtilsTest.assertNotNull(MethodUtils.class.newInstance());
    }

    public void testInvokeMethod() throws Exception {
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null));
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        MethodUtilsTest.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        MethodUtilsTest.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        MethodUtilsTest.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE}));
        MethodUtilsTest.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        MethodUtilsTest.assertEquals((Object)"foo(int)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        MethodUtilsTest.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        MethodUtilsTest.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
    }

    public void testInvokeExactMethod() throws Exception {
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null));
        MethodUtilsTest.assertEquals((Object)"foo()", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])null, (Class[])null));
        MethodUtilsTest.assertEquals((Object)"foo(String)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{""}));
        MethodUtilsTest.assertEquals((Object)"foo(Object)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{new Object()}));
        MethodUtilsTest.assertEquals((Object)"foo(Integer)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        MethodUtilsTest.assertEquals((Object)"foo(double)", (Object)MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{NumberUtils.LONG_ONE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactMethod((Object)this.testBean, (String)"foo", (Object[])new Object[]{Boolean.TRUE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testInvokeStaticMethod() throws Exception {
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        MethodUtilsTest.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        MethodUtilsTest.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        MethodUtilsTest.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE}));
        MethodUtilsTest.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        MethodUtilsTest.assertEquals((Object)"bar(int)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE}));
        MethodUtilsTest.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE}));
        MethodUtilsTest.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}));
        try {
            MethodUtils.invokeStaticMethod(TestBean.class, (String)"does_not_exist", (Object[])new Object[0]);
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testInvokeExactStaticMethod() throws Exception {
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null));
        MethodUtilsTest.assertEquals((Object)"bar()", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])null, (Class[])null));
        MethodUtilsTest.assertEquals((Object)"bar(String)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{""}));
        MethodUtilsTest.assertEquals((Object)"bar(Object)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{new Object()}));
        MethodUtilsTest.assertEquals((Object)"bar(Integer)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.INTEGER_ONE}));
        MethodUtilsTest.assertEquals((Object)"bar(double)", (Object)MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.DOUBLE_ONE}, (Class[])new Class[]{Double.TYPE}));
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.BYTE_ONE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{NumberUtils.LONG_ONE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            MethodUtils.invokeExactStaticMethod(TestBean.class, (String)"bar", (Object[])new Object[]{Boolean.TRUE});
            MethodUtilsTest.fail((String)"should throw NoSuchMethodException");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testGetAccessibleInterfaceMethod() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method method = TestMutable.class.getMethod("getValue", element);
            Method accessibleMethod = MethodUtils.getAccessibleMethod((Method)method);
            MethodUtilsTest.assertNotSame((Object)accessibleMethod, (Object)method);
            MethodUtilsTest.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    public void testGetAccessibleMethodPrivateInterface() throws Exception {
        Method expected = TestBeanWithInterfaces.class.getMethod("foo", new Class[0]);
        MethodUtilsTest.assertNotNull((Object)expected);
        Method actual = MethodUtils.getAccessibleMethod(TestBeanWithInterfaces.class, (String)"foo", (Class[])new Class[0]);
        MethodUtilsTest.assertNull((Object)actual);
    }

    public void testGetAccessibleInterfaceMethodFromDescription() throws Exception {
        Class[][] p;
        for (Class[] element : p = new Class[][]{ArrayUtils.EMPTY_CLASS_ARRAY, null}) {
            Method accessibleMethod = MethodUtils.getAccessibleMethod(TestMutable.class, (String)"getValue", (Class[])element);
            MethodUtilsTest.assertSame(Mutable.class, accessibleMethod.getDeclaringClass());
        }
    }

    public void testGetAccessiblePublicMethod() throws Exception {
        MethodUtilsTest.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod((Method)MutableObject.class.getMethod("getValue", ArrayUtils.EMPTY_CLASS_ARRAY)).getDeclaringClass());
    }

    public void testGetAccessiblePublicMethodFromDescription() throws Exception {
        MethodUtilsTest.assertSame(MutableObject.class, MethodUtils.getAccessibleMethod(MutableObject.class, (String)"getValue", (Class[])ArrayUtils.EMPTY_CLASS_ARRAY).getDeclaringClass());
    }

    public void testGetAccessibleMethodInaccessible() throws Exception {
        Method expected = TestBean.class.getDeclaredMethod("privateStuff", new Class[0]);
        Method actual = MethodUtils.getAccessibleMethod((Method)expected);
        MethodUtilsTest.assertNull((Object)actual);
    }

    public void testGetMatchingAccessibleMethod() throws Exception {
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", null, ArrayUtils.EMPTY_CLASS_ARRAY);
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(String.class), this.singletonArray(String.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Object.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Boolean.class), this.singletonArray(Object.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Byte.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Short.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.class), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Character.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.class), this.singletonArray(Integer.class));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Integer.TYPE), this.singletonArray(Integer.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Long.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Float.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.class), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(TestBean.class, "foo", this.singletonArray(Double.TYPE), this.singletonArray(Double.TYPE));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ParentObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testOne", this.singletonArray(ChildObject.class), this.singletonArray(ParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ParentObject.class), this.singletonArray(GrandParentObject.class));
        this.expectMatchingAccessibleMethodParameterTypes(InheritanceBean.class, "testTwo", this.singletonArray(ChildObject.class), this.singletonArray(ChildInterface.class));
    }

    private void expectMatchingAccessibleMethodParameterTypes(Class<?> cls, String methodName, Class<?>[] requestTypes, Class<?>[] actualTypes) {
        Method m = MethodUtils.getMatchingAccessibleMethod(cls, (String)methodName, (Class[])requestTypes);
        MethodUtilsTest.assertTrue((String)(this.toString(m.getParameterTypes()) + " not equals " + this.toString(actualTypes)), (boolean)Arrays.equals(actualTypes, m.getParameterTypes()));
    }

    private String toString(Class<?>[] c) {
        return Arrays.asList(c).toString();
    }

    private Class<?>[] singletonArray(Class<?> c) {
        Class<?>[] result = this.classCache.get(c);
        if (result == null) {
            result = new Class[]{c};
            this.classCache.put(c, result);
        }
        return result;
    }

    public static class ChildObject
    extends ParentObject
    implements ChildInterface {
    }

    public static class ParentObject
    extends GrandParentObject {
    }

    public static class GrandParentObject {
    }

    static interface ChildInterface {
    }

    public static class InheritanceBean {
        public void testOne(Object obj) {
        }

        public void testOne(GrandParentObject obj) {
        }

        public void testOne(ParentObject obj) {
        }

        public void testTwo(Object obj) {
        }

        public void testTwo(GrandParentObject obj) {
        }

        public void testTwo(ChildInterface obj) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestMutable
    implements Mutable<Object> {
        private TestMutable() {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }
    }

    public static class TestBean {
        public static String bar() {
            return "bar()";
        }

        public static String bar(int i) {
            return "bar(int)";
        }

        public static String bar(Integer i) {
            return "bar(Integer)";
        }

        public static String bar(double d) {
            return "bar(double)";
        }

        public static String bar(String s) {
            return "bar(String)";
        }

        public static String bar(Object o) {
            return "bar(Object)";
        }

        private void privateStuff() {
        }

        public String foo() {
            return "foo()";
        }

        public String foo(int i) {
            return "foo(int)";
        }

        public String foo(Integer i) {
            return "foo(Integer)";
        }

        public String foo(double d) {
            return "foo(double)";
        }

        public String foo(String s) {
            return "foo(String)";
        }

        public String foo(Object o) {
            return "foo(Object)";
        }
    }

    static class TestBeanWithInterfaces
    implements PrivateInterface {
        TestBeanWithInterfaces() {
        }

        public String foo() {
            return "foo()";
        }
    }

    private static interface PrivateInterface {
    }
}

