/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import junit.framework.TestCase;
import org.apache.commons.lang3.text.StrMatcher;

public class StrMatcherTest
extends TestCase {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    public StrMatcherTest(String name) {
        super(name);
    }

    public void testCommaMatcher() {
        StrMatcher matcher = StrMatcher.commaMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.commaMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 1));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
    }

    public void testTabMatcher() {
        StrMatcher matcher = StrMatcher.tabMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.tabMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
    }

    public void testSpaceMatcher() {
        StrMatcher matcher = StrMatcher.spaceMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.spaceMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
    }

    public void testSplitMatcher() {
        StrMatcher matcher = StrMatcher.splitMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.splitMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
    }

    public void testTrimMatcher() {
        StrMatcher matcher = StrMatcher.trimMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.trimMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 5));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 7));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 8));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 9));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 10));
    }

    public void testSingleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.singleQuoteMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.singleQuoteMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    public void testDoubleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.doubleQuoteMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.doubleQuoteMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    public void testQuoteMatcher() {
        StrMatcher matcher = StrMatcher.quoteMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.quoteMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 11));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER1, 12));
    }

    public void testNoneMatcher() {
        StrMatcher matcher = StrMatcher.noneMatcher();
        StrMatcherTest.assertSame((Object)matcher, (Object)StrMatcher.noneMatcher());
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 0));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 1));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 2));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 4));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 5));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 6));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 7));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 8));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 9));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 10));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 11));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER1, 12));
    }

    public void testCharMatcher_char() {
        StrMatcher matcher = StrMatcher.charMatcher((char)'c');
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
    }

    public void testCharSetMatcher_String() {
        StrMatcher matcher = StrMatcher.charSetMatcher((String)"ace");
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)""));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)null));
        StrMatcherTest.assertTrue((boolean)(StrMatcher.charSetMatcher((String)"a") instanceof StrMatcher.CharMatcher));
    }

    public void testCharSetMatcher_charArray() {
        StrMatcher matcher = StrMatcher.charSetMatcher((char[])"ace".toCharArray());
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 0));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 2));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        StrMatcherTest.assertEquals((int)1, (int)matcher.isMatch(BUFFER2, 4));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])new char[0]));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])null));
        StrMatcherTest.assertTrue((boolean)(StrMatcher.charSetMatcher((char[])"a".toCharArray()) instanceof StrMatcher.CharMatcher));
    }

    public void testStringMatcher_String() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 0));
        StrMatcherTest.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 2));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 4));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 5));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher((String)""));
        StrMatcherTest.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher((String)null));
    }

    public void testMatcherIndices() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        StrMatcherTest.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length));
        StrMatcherTest.assertEquals((int)2, (int)matcher.isMatch(BUFFER2, 1, 0, 3));
        StrMatcherTest.assertEquals((int)0, (int)matcher.isMatch(BUFFER2, 1, 0, 2));
    }
}

