/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import junit.framework.TestCase;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;

public class NumericEntityEscaperTest
extends TestCase {
    public void testBelow() {
        NumericEntityEscaper nee = NumericEntityEscaper.below((int)70);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)input);
        NumericEntityEscaperTest.assertEquals((String)"Failed to escape numeric entities via the below method", (String)"&#65;&#68;FGZ", (String)result);
    }

    public void testBetween() {
        NumericEntityEscaper nee = NumericEntityEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)input);
        NumericEntityEscaperTest.assertEquals((String)"Failed to escape numeric entities via the between method", (String)"AD&#70;&#71;Z", (String)result);
    }

    public void testAbove() {
        NumericEntityEscaper nee = NumericEntityEscaper.above((int)70);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)input);
        NumericEntityEscaperTest.assertEquals((String)"Failed to escape numeric entities via the above method", (String)"ADF&#71;&#90;", (String)result);
    }

    public void testSupplementary() {
        NumericEntityEscaper nee = new NumericEntityEscaper();
        String input = "\ud803\udc22";
        String expected = "&#68642;";
        String result = nee.translate((CharSequence)input);
        NumericEntityEscaperTest.assertEquals((String)"Failed to escape numeric entities supplementary characters", (String)expected, (String)result);
    }
}

