/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.time.StopWatch;

public class StopWatchTest
extends TestCase {
    public StopWatchTest(String s) {
        super(s);
    }

    public void testStopWatchSimple() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long time = watch.getTime();
        StopWatchTest.assertEquals((long)time, (long)watch.getTime());
        StopWatchTest.assertTrue((time >= 500L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((time < 700L ? 1 : 0) != 0);
        watch.reset();
        StopWatchTest.assertEquals((long)0L, (long)watch.getTime());
    }

    public void testStopWatchSimpleGet() {
        StopWatch watch = new StopWatch();
        StopWatchTest.assertEquals((long)0L, (long)watch.getTime());
        StopWatchTest.assertEquals((String)"0:00:00.000", (String)watch.toString());
        watch.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StopWatchTest.assertTrue((watch.getTime() < 2000L ? 1 : 0) != 0);
    }

    public void testStopWatchSplit() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.split();
        long splitTime = watch.getSplitTime();
        String splitStr = watch.toSplitString();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.unsplit();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        StopWatchTest.assertEquals((String)"Formatted split string not the correct length", (int)splitStr.length(), (int)11);
        StopWatchTest.assertTrue((splitTime >= 500L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((splitTime < 700L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((totalTime < 1900L ? 1 : 0) != 0);
    }

    public void testStopWatchSuspend() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.resume();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        StopWatchTest.assertTrue((suspendTime >= 500L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((suspendTime < 700L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((totalTime >= 1000L ? 1 : 0) != 0);
        StopWatchTest.assertTrue((totalTime < 1300L ? 1 : 0) != 0);
    }

    public void testLang315() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        StopWatchTest.assertTrue((suspendTime == totalTime ? 1 : 0) != 0);
    }

    public void testBadStates() {
        StopWatch watch = new StopWatch();
        try {
            watch.stop();
            StopWatchTest.fail((String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.stop();
            StopWatchTest.fail((String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.suspend();
            StopWatchTest.fail((String)"Calling suspend on an unstarted StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.split();
            StopWatchTest.fail((String)"Calling split on a non-running StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.unsplit();
            StopWatchTest.fail((String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.resume();
            StopWatchTest.fail((String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        watch.start();
        try {
            watch.start();
            StopWatchTest.fail((String)"Calling start on a started StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.unsplit();
            StopWatchTest.fail((String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.getSplitTime();
            StopWatchTest.fail((String)"Calling getSplitTime on an unsplit StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            watch.resume();
            StopWatchTest.fail((String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        watch.stop();
        try {
            watch.start();
            StopWatchTest.fail((String)"Calling start on a stopped StopWatch should throw an exception as it needs to be reset. ");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetStartTime() {
        long beforeStopWatch = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        try {
            watch.getStartTime();
            StopWatchTest.fail((String)"Calling getStartTime on an unstarted StopWatch should throw an exception");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        watch.start();
        try {
            watch.getStartTime();
            Assert.assertTrue((watch.getStartTime() >= beforeStopWatch ? 1 : 0) != 0);
        }
        catch (IllegalStateException ex) {
            StopWatchTest.fail((String)("Start time should be available: " + ex.getMessage()));
        }
        watch.reset();
        try {
            watch.getStartTime();
            StopWatchTest.fail((String)"Calling getStartTime on a reset, but unstarted StopWatch should throw an exception");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
    }
}

