/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.BitField;

public class BitFieldTest
extends TestCase {
    private static final BitField bf_multi = new BitField(16256);
    private static final BitField bf_single = new BitField(16384);
    private static final BitField bf_zero = new BitField(0);

    public BitFieldTest(String name) {
        super(name);
    }

    public void testGetValue() {
        BitFieldTest.assertEquals((int)bf_multi.getValue(-1), (int)127);
        BitFieldTest.assertEquals((int)bf_multi.getValue(0), (int)0);
        BitFieldTest.assertEquals((int)bf_single.getValue(-1), (int)1);
        BitFieldTest.assertEquals((int)bf_single.getValue(0), (int)0);
        BitFieldTest.assertEquals((int)bf_zero.getValue(-1), (int)0);
        BitFieldTest.assertEquals((int)bf_zero.getValue(0), (int)0);
    }

    public void testGetShortValue() {
        BitFieldTest.assertEquals((short)bf_multi.getShortValue((short)-1), (short)127);
        BitFieldTest.assertEquals((short)bf_multi.getShortValue((short)0), (short)0);
        BitFieldTest.assertEquals((short)bf_single.getShortValue((short)-1), (short)1);
        BitFieldTest.assertEquals((short)bf_single.getShortValue((short)0), (short)0);
        BitFieldTest.assertEquals((short)bf_zero.getShortValue((short)-1), (short)0);
        BitFieldTest.assertEquals((short)bf_zero.getShortValue((short)0), (short)0);
    }

    public void testGetRawValue() {
        BitFieldTest.assertEquals((int)bf_multi.getRawValue(-1), (int)16256);
        BitFieldTest.assertEquals((int)bf_multi.getRawValue(0), (int)0);
        BitFieldTest.assertEquals((int)bf_single.getRawValue(-1), (int)16384);
        BitFieldTest.assertEquals((int)bf_single.getRawValue(0), (int)0);
        BitFieldTest.assertEquals((int)bf_zero.getRawValue(-1), (int)0);
        BitFieldTest.assertEquals((int)bf_zero.getRawValue(0), (int)0);
    }

    public void testGetShortRawValue() {
        BitFieldTest.assertEquals((short)bf_multi.getShortRawValue((short)-1), (short)16256);
        BitFieldTest.assertEquals((short)bf_multi.getShortRawValue((short)0), (short)0);
        BitFieldTest.assertEquals((short)bf_single.getShortRawValue((short)-1), (short)16384);
        BitFieldTest.assertEquals((short)bf_single.getShortRawValue((short)0), (short)0);
        BitFieldTest.assertEquals((short)bf_zero.getShortRawValue((short)-1), (short)0);
        BitFieldTest.assertEquals((short)bf_zero.getShortRawValue((short)0), (short)0);
    }

    public void testIsSet() {
        int j;
        BitFieldTest.assertTrue((!bf_multi.isSet(0) ? 1 : 0) != 0);
        BitFieldTest.assertTrue((!bf_zero.isSet(0) ? 1 : 0) != 0);
        for (j = 128; j <= 16256; j += 128) {
            BitFieldTest.assertTrue((boolean)bf_multi.isSet(j));
        }
        for (j = 128; j <= 16256; j += 128) {
            BitFieldTest.assertTrue((!bf_zero.isSet(j) ? 1 : 0) != 0);
        }
        BitFieldTest.assertTrue((!bf_single.isSet(0) ? 1 : 0) != 0);
        BitFieldTest.assertTrue((boolean)bf_single.isSet(16384));
    }

    public void testIsAllSet() {
        for (int j = 0; j < 16256; j += 128) {
            BitFieldTest.assertTrue((!bf_multi.isAllSet(j) ? 1 : 0) != 0);
            BitFieldTest.assertTrue((boolean)bf_zero.isAllSet(j));
        }
        BitFieldTest.assertTrue((boolean)bf_multi.isAllSet(16256));
        BitFieldTest.assertTrue((!bf_single.isAllSet(0) ? 1 : 0) != 0);
        BitFieldTest.assertTrue((boolean)bf_single.isAllSet(16384));
    }

    public void testSetValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            BitFieldTest.assertEquals((int)bf_multi.getValue(bf_multi.setValue(0, j)), (int)j);
            BitFieldTest.assertEquals((int)bf_multi.setValue(0, j), (int)(j << 7));
        }
        for (j = 0; j < 128; ++j) {
            BitFieldTest.assertEquals((int)bf_zero.getValue(bf_zero.setValue(0, j)), (int)0);
            BitFieldTest.assertEquals((int)bf_zero.setValue(0, j), (int)0);
        }
        BitFieldTest.assertEquals((int)bf_multi.setValue(16256, 128), (int)0);
        for (j = 0; j < 2; ++j) {
            BitFieldTest.assertEquals((int)bf_single.getValue(bf_single.setValue(0, j)), (int)j);
            BitFieldTest.assertEquals((int)bf_single.setValue(0, j), (int)(j << 14));
        }
        BitFieldTest.assertEquals((int)bf_single.setValue(16384, 2), (int)0);
    }

    public void testSetShortValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            BitFieldTest.assertEquals((short)bf_multi.getShortValue(bf_multi.setShortValue((short)0, (short)j)), (short)((short)j));
            BitFieldTest.assertEquals((short)bf_multi.setShortValue((short)0, (short)j), (short)((short)(j << 7)));
        }
        for (j = 0; j < 128; ++j) {
            BitFieldTest.assertEquals((short)bf_zero.getShortValue(bf_zero.setShortValue((short)0, (short)j)), (short)0);
            BitFieldTest.assertEquals((short)bf_zero.setShortValue((short)0, (short)j), (short)0);
        }
        BitFieldTest.assertEquals((short)bf_multi.setShortValue((short)16256, (short)128), (short)0);
        for (j = 0; j < 2; ++j) {
            BitFieldTest.assertEquals((short)bf_single.getShortValue(bf_single.setShortValue((short)0, (short)j)), (short)((short)j));
            BitFieldTest.assertEquals((short)bf_single.setShortValue((short)0, (short)j), (short)((short)(j << 14)));
        }
        BitFieldTest.assertEquals((short)bf_single.setShortValue((short)16384, (short)2), (short)0);
    }

    public void testByte() {
        BitFieldTest.assertEquals((int)0, (int)new BitField(0).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)1, (int)new BitField(1).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)2, (int)new BitField(2).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)4, (int)new BitField(4).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)8, (int)new BitField(8).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)16, (int)new BitField(16).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)32, (int)new BitField(32).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)64, (int)new BitField(64).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)-128, (int)new BitField(128).setByteBoolean((byte)0, true));
        BitFieldTest.assertEquals((int)1, (int)new BitField(0).setByteBoolean((byte)1, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(1).setByteBoolean((byte)1, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(2).setByteBoolean((byte)2, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(4).setByteBoolean((byte)4, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(8).setByteBoolean((byte)8, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(16).setByteBoolean((byte)16, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(32).setByteBoolean((byte)32, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(64).setByteBoolean((byte)64, false));
        BitFieldTest.assertEquals((int)0, (int)new BitField(128).setByteBoolean((byte)-128, false));
        BitFieldTest.assertEquals((int)-2, (int)new BitField(1).setByteBoolean((byte)-1, false));
        byte clearedBit = new BitField(64).setByteBoolean((byte)-63, false);
        BitFieldTest.assertEquals((boolean)false, (boolean)new BitField(64).isSet((int)clearedBit));
    }

    public void testClear() {
        BitFieldTest.assertEquals((int)bf_multi.clear(-1), (int)-16257);
        BitFieldTest.assertEquals((int)bf_single.clear(-1), (int)-16385);
        BitFieldTest.assertEquals((int)bf_zero.clear(-1), (int)-1);
    }

    public void testClearShort() {
        BitFieldTest.assertEquals((short)bf_multi.clearShort((short)-1), (short)-16257);
        BitFieldTest.assertEquals((short)bf_single.clearShort((short)-1), (short)-16385);
        BitFieldTest.assertEquals((short)bf_zero.clearShort((short)-1), (short)-1);
    }

    public void testSet() {
        BitFieldTest.assertEquals((int)bf_multi.set(0), (int)16256);
        BitFieldTest.assertEquals((int)bf_single.set(0), (int)16384);
        BitFieldTest.assertEquals((int)bf_zero.set(0), (int)0);
    }

    public void testSetShort() {
        BitFieldTest.assertEquals((short)bf_multi.setShort((short)0), (short)16256);
        BitFieldTest.assertEquals((short)bf_single.setShort((short)0), (short)16384);
        BitFieldTest.assertEquals((short)bf_zero.setShort((short)0), (short)0);
    }

    public void testSetBoolean() {
        BitFieldTest.assertEquals((int)bf_multi.set(0), (int)bf_multi.setBoolean(0, true));
        BitFieldTest.assertEquals((int)bf_single.set(0), (int)bf_single.setBoolean(0, true));
        BitFieldTest.assertEquals((int)bf_zero.set(0), (int)bf_zero.setBoolean(0, true));
        BitFieldTest.assertEquals((int)bf_multi.clear(-1), (int)bf_multi.setBoolean(-1, false));
        BitFieldTest.assertEquals((int)bf_single.clear(-1), (int)bf_single.setBoolean(-1, false));
        BitFieldTest.assertEquals((int)bf_zero.clear(-1), (int)bf_zero.setBoolean(-1, false));
    }

    public void testSetShortBoolean() {
        BitFieldTest.assertEquals((short)bf_multi.setShort((short)0), (short)bf_multi.setShortBoolean((short)0, true));
        BitFieldTest.assertEquals((short)bf_single.setShort((short)0), (short)bf_single.setShortBoolean((short)0, true));
        BitFieldTest.assertEquals((short)bf_zero.setShort((short)0), (short)bf_zero.setShortBoolean((short)0, true));
        BitFieldTest.assertEquals((short)bf_multi.clearShort((short)-1), (short)bf_multi.setShortBoolean((short)-1, false));
        BitFieldTest.assertEquals((short)bf_single.clearShort((short)-1), (short)bf_single.setShortBoolean((short)-1, false));
        BitFieldTest.assertEquals((short)bf_zero.clearShort((short)-1), (short)bf_zero.setShortBoolean((short)-1, false));
    }
}

