/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.SerializationUtils;

public class CharRangeTest
extends TestCase {
    public CharRangeTest(String name) {
        super(name);
    }

    public void testClass() {
        CharRangeTest.assertEquals((boolean)false, (boolean)Modifier.isPublic(CharRange.class.getModifiers()));
        CharRangeTest.assertEquals((boolean)true, (boolean)Modifier.isFinal(CharRange.class.getModifiers()));
    }

    public void testConstructorAccessors_is() {
        CharRange rangea = CharRange.is((char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'a', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"a", (String)rangea.toString());
    }

    public void testConstructorAccessors_isNot() {
        CharRange rangea = CharRange.isNot((char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'a', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"^a", (String)rangea.toString());
    }

    public void testConstructorAccessors_isIn_Same() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'a', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"a", (String)rangea.toString());
    }

    public void testConstructorAccessors_isIn_Normal() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'e');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'e', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"a-e", (String)rangea.toString());
    }

    public void testConstructorAccessors_isIn_Reversed() {
        CharRange rangea = CharRange.isIn((char)'e', (char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'e', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"a-e", (String)rangea.toString());
    }

    public void testConstructorAccessors_isNotIn_Same() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'a', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"^a", (String)rangea.toString());
    }

    public void testConstructorAccessors_isNotIn_Normal() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'e');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'e', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"^a-e", (String)rangea.toString());
    }

    public void testConstructorAccessors_isNotIn_Reversed() {
        CharRange rangea = CharRange.isNotIn((char)'e', (char)'a');
        CharRangeTest.assertEquals((char)'a', (char)rangea.getStart());
        CharRangeTest.assertEquals((char)'e', (char)rangea.getEnd());
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.isNegated());
        CharRangeTest.assertEquals((String)"^a-e", (String)rangea.toString());
    }

    public void testEquals_Object() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.equals(null));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.equals((Object)rangea));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangea.equals((Object)CharRange.is((char)'a')));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangeae.equals((Object)rangeae));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangeae.equals((Object)CharRange.isIn((char)'a', (char)'e')));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangenotbf.equals((Object)rangenotbf));
        CharRangeTest.assertEquals((boolean)true, (boolean)rangenotbf.equals((Object)CharRange.isIn((char)'b', (char)'f')));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.equals((Object)rangeae));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangea.equals((Object)rangenotbf));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangeae.equals((Object)rangea));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangeae.equals((Object)rangenotbf));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangenotbf.equals((Object)rangea));
        CharRangeTest.assertEquals((boolean)false, (boolean)rangenotbf.equals((Object)rangeae));
    }

    public void testHashCode() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        CharRangeTest.assertEquals((boolean)true, (rangea.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)true, (rangea.hashCode() == CharRange.is((char)'a').hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)true, (rangeae.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)true, (rangeae.hashCode() == CharRange.isIn((char)'a', (char)'e').hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)true, (rangenotbf.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)true, (rangenotbf.hashCode() == CharRange.isIn((char)'b', (char)'f').hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangea.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangea.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangeae.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangeae.hashCode() == rangenotbf.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangenotbf.hashCode() == rangea.hashCode() ? 1 : 0) != 0);
        CharRangeTest.assertEquals((boolean)false, (rangenotbf.hashCode() == rangeae.hashCode() ? 1 : 0) != 0);
    }

    public void testContains_Char() {
        CharRange range = CharRange.is((char)'c');
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('b'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('c'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('d'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('e'));
        range = CharRange.isIn((char)'c', (char)'d');
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('b'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('c'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('d'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('e'));
        range = CharRange.isIn((char)'d', (char)'c');
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('b'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('c'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('d'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('e'));
        range = CharRange.isNotIn((char)'c', (char)'d');
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('b'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('c'));
        CharRangeTest.assertEquals((boolean)false, (boolean)range.contains('d'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('e'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('\u0000'));
        CharRangeTest.assertEquals((boolean)true, (boolean)range.contains('\uffff'));
    }

    public void testContains_Charrange() {
        CharRange a = CharRange.is((char)'a');
        CharRange b = CharRange.is((char)'b');
        CharRange c = CharRange.is((char)'c');
        CharRange c2 = CharRange.is((char)'c');
        CharRange d = CharRange.is((char)'d');
        CharRange e = CharRange.is((char)'e');
        CharRange cd = CharRange.isIn((char)'c', (char)'d');
        CharRange bd = CharRange.isIn((char)'b', (char)'d');
        CharRange bc = CharRange.isIn((char)'b', (char)'c');
        CharRange ab = CharRange.isIn((char)'a', (char)'b');
        CharRange de = CharRange.isIn((char)'d', (char)'e');
        CharRange ef = CharRange.isIn((char)'e', (char)'f');
        CharRange ae = CharRange.isIn((char)'a', (char)'e');
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(b));
        CharRangeTest.assertEquals((boolean)true, (boolean)c.contains(c));
        CharRangeTest.assertEquals((boolean)true, (boolean)c.contains(c2));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(d));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(cd));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(bd));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(bc));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(ab));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(de));
        CharRangeTest.assertEquals((boolean)true, (boolean)cd.contains(c));
        CharRangeTest.assertEquals((boolean)true, (boolean)bd.contains(c));
        CharRangeTest.assertEquals((boolean)true, (boolean)bc.contains(c));
        CharRangeTest.assertEquals((boolean)false, (boolean)ab.contains(c));
        CharRangeTest.assertEquals((boolean)false, (boolean)de.contains(c));
        CharRangeTest.assertEquals((boolean)true, (boolean)ae.contains(b));
        CharRangeTest.assertEquals((boolean)true, (boolean)ae.contains(ab));
        CharRangeTest.assertEquals((boolean)true, (boolean)ae.contains(bc));
        CharRangeTest.assertEquals((boolean)true, (boolean)ae.contains(cd));
        CharRangeTest.assertEquals((boolean)true, (boolean)ae.contains(de));
        CharRange notb = CharRange.isNot((char)'b');
        CharRange notc = CharRange.isNot((char)'c');
        CharRange notd = CharRange.isNot((char)'d');
        CharRange notab = CharRange.isNotIn((char)'a', (char)'b');
        CharRange notbc = CharRange.isNotIn((char)'b', (char)'c');
        CharRange notbd = CharRange.isNotIn((char)'b', (char)'d');
        CharRange notcd = CharRange.isNotIn((char)'c', (char)'d');
        CharRange notde = CharRange.isNotIn((char)'d', (char)'e');
        CharRange notae = CharRange.isNotIn((char)'a', (char)'e');
        CharRange all = CharRange.isIn((char)'\u0000', (char)'\uffff');
        CharRange allbutfirst = CharRange.isIn((char)'\u0001', (char)'\uffff');
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(notc));
        CharRangeTest.assertEquals((boolean)false, (boolean)c.contains(notbd));
        CharRangeTest.assertEquals((boolean)true, (boolean)all.contains(notc));
        CharRangeTest.assertEquals((boolean)true, (boolean)all.contains(notbd));
        CharRangeTest.assertEquals((boolean)false, (boolean)allbutfirst.contains(notc));
        CharRangeTest.assertEquals((boolean)false, (boolean)allbutfirst.contains(notbd));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(a));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(b));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(c));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(d));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(e));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(ab));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(bc));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(bd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(cd));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(de));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(ae));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(all));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(allbutfirst));
        CharRangeTest.assertEquals((boolean)true, (boolean)notbd.contains(a));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(b));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(c));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(d));
        CharRangeTest.assertEquals((boolean)true, (boolean)notbd.contains(e));
        CharRangeTest.assertEquals((boolean)true, (boolean)notcd.contains(ab));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(bc));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(bd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(cd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(de));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(ae));
        CharRangeTest.assertEquals((boolean)true, (boolean)notcd.contains(ef));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(all));
        CharRangeTest.assertEquals((boolean)false, (boolean)notcd.contains(allbutfirst));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(notb));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(notc));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(notd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(notab));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(notbc));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(notbd));
        CharRangeTest.assertEquals((boolean)true, (boolean)notc.contains(notcd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notc.contains(notde));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notb));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notc));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notab));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notbc));
        CharRangeTest.assertEquals((boolean)true, (boolean)notbd.contains(notbd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notcd));
        CharRangeTest.assertEquals((boolean)false, (boolean)notbd.contains(notde));
        CharRangeTest.assertEquals((boolean)true, (boolean)notbd.contains(notae));
    }

    public void testContainsNullArg() {
        CharRange range = CharRange.is((char)'a');
        try {
            boolean contains = range.contains(null);
        }
        catch (IllegalArgumentException e) {
            CharRangeTest.assertEquals((String)"The Range must not be null", (String)e.getMessage());
        }
    }

    public void testIterator() {
        CharRange a = CharRange.is((char)'a');
        CharRange ad = CharRange.isIn((char)'a', (char)'d');
        CharRange nota = CharRange.isNot((char)'a');
        CharRange emptySet = CharRange.isNotIn((char)'\u0000', (char)'\uffff');
        CharRange notFirst = CharRange.isNotIn((char)'\u0001', (char)'\uffff');
        CharRange notLast = CharRange.isNotIn((char)'\u0000', (char)'\ufffe');
        Iterator aIt = a.iterator();
        CharRangeTest.assertNotNull((Object)aIt);
        CharRangeTest.assertTrue((boolean)aIt.hasNext());
        CharRangeTest.assertEquals((Object)Character.valueOf('a'), aIt.next());
        CharRangeTest.assertFalse((boolean)aIt.hasNext());
        Iterator adIt = ad.iterator();
        CharRangeTest.assertNotNull((Object)adIt);
        CharRangeTest.assertTrue((boolean)adIt.hasNext());
        CharRangeTest.assertEquals((Object)Character.valueOf('a'), adIt.next());
        CharRangeTest.assertEquals((Object)Character.valueOf('b'), adIt.next());
        CharRangeTest.assertEquals((Object)Character.valueOf('c'), adIt.next());
        CharRangeTest.assertEquals((Object)Character.valueOf('d'), adIt.next());
        CharRangeTest.assertFalse((boolean)adIt.hasNext());
        Iterator notaIt = nota.iterator();
        CharRangeTest.assertNotNull((Object)notaIt);
        CharRangeTest.assertTrue((boolean)notaIt.hasNext());
        while (notaIt.hasNext()) {
            Character c = (Character)notaIt.next();
            CharRangeTest.assertFalse(('a' == c.charValue() ? 1 : 0) != 0);
        }
        Iterator emptySetIt = emptySet.iterator();
        CharRangeTest.assertNotNull((Object)emptySetIt);
        CharRangeTest.assertFalse((boolean)emptySetIt.hasNext());
        try {
            emptySetIt.next();
            CharRangeTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            CharRangeTest.assertTrue((boolean)true);
        }
        Iterator notFirstIt = notFirst.iterator();
        CharRangeTest.assertNotNull((Object)notFirstIt);
        CharRangeTest.assertTrue((boolean)notFirstIt.hasNext());
        CharRangeTest.assertEquals((Object)Character.valueOf('\u0000'), notFirstIt.next());
        CharRangeTest.assertFalse((boolean)notFirstIt.hasNext());
        try {
            notFirstIt.next();
            CharRangeTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            CharRangeTest.assertTrue((boolean)true);
        }
        Iterator notLastIt = notLast.iterator();
        CharRangeTest.assertNotNull((Object)notLastIt);
        CharRangeTest.assertTrue((boolean)notLastIt.hasNext());
        CharRangeTest.assertEquals((Object)Character.valueOf('\uffff'), notLastIt.next());
        CharRangeTest.assertFalse((boolean)notLastIt.hasNext());
        try {
            notLastIt.next();
            CharRangeTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            CharRangeTest.assertTrue((boolean)true);
        }
    }

    public void testSerialization() {
        CharRange range = CharRange.is((char)'a');
        CharRangeTest.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isIn((char)'a', (char)'e');
        CharRangeTest.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isNotIn((char)'a', (char)'e');
        CharRangeTest.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
    }
}

