/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.SerializationUtils;

public class CharSetTest
extends TestCase {
    public CharSetTest(String name) {
        super(name);
    }

    public void testClass() {
        CharSetTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(CharSet.class.getModifiers()));
        CharSetTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(CharSet.class.getModifiers()));
    }

    public void testGetInstance() {
        CharSetTest.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{null}));
        CharSetTest.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{""}));
        CharSetTest.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"a-zA-Z"}));
        CharSetTest.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"A-Za-z"}));
        CharSetTest.assertSame((Object)CharSet.ASCII_ALPHA_LOWER, (Object)CharSet.getInstance((String[])new String[]{"a-z"}));
        CharSetTest.assertSame((Object)CharSet.ASCII_ALPHA_UPPER, (Object)CharSet.getInstance((String[])new String[]{"A-Z"}));
        CharSetTest.assertSame((Object)CharSet.ASCII_NUMERIC, (Object)CharSet.getInstance((String[])new String[]{"0-9"}));
    }

    public void testGetInstance_Stringarray() {
        CharSetTest.assertEquals(null, (Object)CharSet.getInstance((String[])null));
        CharSetTest.assertEquals((String)"[]", (String)CharSet.getInstance((String[])new String[0]).toString());
        CharSetTest.assertEquals((String)"[]", (String)CharSet.getInstance((String[])new String[]{null}).toString());
        CharSetTest.assertEquals((String)"[a-e]", (String)CharSet.getInstance((String[])new String[]{"a-e"}).toString());
    }

    public void testConstructor_String_simple() {
        CharSet set = CharSet.getInstance((String[])new String[]{null});
        CharRange[] array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[]", (String)set.toString());
        CharSetTest.assertEquals((int)0, (int)array.length);
        set = CharSet.getInstance((String[])new String[]{""});
        array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[]", (String)set.toString());
        CharSetTest.assertEquals((int)0, (int)array.length);
        set = CharSet.getInstance((String[])new String[]{"a"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[a]", (String)set.toString());
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((String)"a", (String)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[^a]", (String)set.toString());
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((String)"^a", (String)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[a-e]", (String)set.toString());
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((String)"a-e", (String)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a-e"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((String)"[^a-e]", (String)set.toString());
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((String)"^a-e", (String)array[0].toString());
    }

    public void testConstructor_String_combo() {
        CharSet set = CharSet.getInstance((String[])new String[]{"abc"});
        Object[] array = set.getCharRanges();
        CharSetTest.assertEquals((int)3, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"a-ce-f"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'c')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-f"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"e-fa"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-fm-pz"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)4, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'m', (char)'p')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'z')));
    }

    public void testConstructor_String_comboNegated() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^abc"});
        Object[] array = set.getCharRanges();
        CharSetTest.assertEquals((int)3, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"b^ac"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)3, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"db^ac"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)4, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^b^a"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"b^a-c^z"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)3, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'c')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'z')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
    }

    public void testConstructor_String_oddDash() {
        CharSet set = CharSet.getInstance((String[])new String[]{"-"});
        Object[] array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"---"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"----"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"-a"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"a-"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"a--"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--a"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'-', (char)'a')));
    }

    public void testConstructor_String_oddNegate() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^"});
        Object[] array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"a^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^a-"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"^^-c"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'^', (char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^c-^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^c-^d"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        set = CharSet.getInstance((String[])new String[]{"^^-"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
    }

    public void testConstructor_String_oddCombinations() {
        Object[] array = null;
        CharSet set = CharSet.getInstance((String[])new String[]{"a-^c"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'^')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        CharSetTest.assertEquals((boolean)false, (boolean)set.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('^'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('_'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('c'));
        set = CharSet.getInstance((String[])new String[]{"^a-^c"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'^')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('b'));
        CharSetTest.assertEquals((boolean)false, (boolean)set.contains('^'));
        CharSetTest.assertEquals((boolean)false, (boolean)set.contains('_'));
        set = CharSet.getInstance((String[])new String[]{"a- ^-- "});
        array = set.getCharRanges();
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)' ')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'-', (char)' ')));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('#'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('^'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('a'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('*'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('A'));
        set = CharSet.getInstance((String[])new String[]{"^-b"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('_'));
        CharSetTest.assertEquals((boolean)false, (boolean)set.contains('A'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('^'));
        set = CharSet.getInstance((String[])new String[]{"b-^"});
        array = set.getCharRanges();
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('^'));
        CharSetTest.assertEquals((boolean)true, (boolean)set.contains('a'));
        CharSetTest.assertEquals((boolean)false, (boolean)set.contains('c'));
    }

    public void testEquals_Object() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSetTest.assertEquals((boolean)false, (boolean)abc.equals(null));
        CharSetTest.assertEquals((boolean)true, (boolean)abc.equals((Object)abc));
        CharSetTest.assertEquals((boolean)true, (boolean)abc.equals((Object)abc2));
        CharSetTest.assertEquals((boolean)false, (boolean)abc.equals((Object)atoc));
        CharSetTest.assertEquals((boolean)false, (boolean)abc.equals((Object)notatoc));
        CharSetTest.assertEquals((boolean)false, (boolean)atoc.equals((Object)abc));
        CharSetTest.assertEquals((boolean)true, (boolean)atoc.equals((Object)atoc));
        CharSetTest.assertEquals((boolean)true, (boolean)atoc.equals((Object)atoc2));
        CharSetTest.assertEquals((boolean)false, (boolean)atoc.equals((Object)notatoc));
        CharSetTest.assertEquals((boolean)false, (boolean)notatoc.equals((Object)abc));
        CharSetTest.assertEquals((boolean)false, (boolean)notatoc.equals((Object)atoc));
        CharSetTest.assertEquals((boolean)true, (boolean)notatoc.equals((Object)notatoc));
        CharSetTest.assertEquals((boolean)true, (boolean)notatoc.equals((Object)notatoc2));
    }

    public void testHashCode() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSetTest.assertEquals((int)abc.hashCode(), (int)abc.hashCode());
        CharSetTest.assertEquals((int)abc.hashCode(), (int)abc2.hashCode());
        CharSetTest.assertEquals((int)atoc.hashCode(), (int)atoc.hashCode());
        CharSetTest.assertEquals((int)atoc.hashCode(), (int)atoc2.hashCode());
        CharSetTest.assertEquals((int)notatoc.hashCode(), (int)notatoc.hashCode());
        CharSetTest.assertEquals((int)notatoc.hashCode(), (int)notatoc2.hashCode());
    }

    public void testContains_Char() {
        CharSet btod = CharSet.getInstance((String[])new String[]{"b-d"});
        CharSet dtob = CharSet.getInstance((String[])new String[]{"d-b"});
        CharSet bcd = CharSet.getInstance((String[])new String[]{"bcd"});
        CharSet bd = CharSet.getInstance((String[])new String[]{"bd"});
        CharSet notbtod = CharSet.getInstance((String[])new String[]{"^b-d"});
        CharSetTest.assertEquals((boolean)false, (boolean)btod.contains('a'));
        CharSetTest.assertEquals((boolean)true, (boolean)btod.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)btod.contains('c'));
        CharSetTest.assertEquals((boolean)true, (boolean)btod.contains('d'));
        CharSetTest.assertEquals((boolean)false, (boolean)btod.contains('e'));
        CharSetTest.assertEquals((boolean)false, (boolean)bcd.contains('a'));
        CharSetTest.assertEquals((boolean)true, (boolean)bcd.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)bcd.contains('c'));
        CharSetTest.assertEquals((boolean)true, (boolean)bcd.contains('d'));
        CharSetTest.assertEquals((boolean)false, (boolean)bcd.contains('e'));
        CharSetTest.assertEquals((boolean)false, (boolean)bd.contains('a'));
        CharSetTest.assertEquals((boolean)true, (boolean)bd.contains('b'));
        CharSetTest.assertEquals((boolean)false, (boolean)bd.contains('c'));
        CharSetTest.assertEquals((boolean)true, (boolean)bd.contains('d'));
        CharSetTest.assertEquals((boolean)false, (boolean)bd.contains('e'));
        CharSetTest.assertEquals((boolean)true, (boolean)notbtod.contains('a'));
        CharSetTest.assertEquals((boolean)false, (boolean)notbtod.contains('b'));
        CharSetTest.assertEquals((boolean)false, (boolean)notbtod.contains('c'));
        CharSetTest.assertEquals((boolean)false, (boolean)notbtod.contains('d'));
        CharSetTest.assertEquals((boolean)true, (boolean)notbtod.contains('e'));
        CharSetTest.assertEquals((boolean)false, (boolean)dtob.contains('a'));
        CharSetTest.assertEquals((boolean)true, (boolean)dtob.contains('b'));
        CharSetTest.assertEquals((boolean)true, (boolean)dtob.contains('c'));
        CharSetTest.assertEquals((boolean)true, (boolean)dtob.contains('d'));
        CharSetTest.assertEquals((boolean)false, (boolean)dtob.contains('e'));
        CharRange[] array = dtob.getCharRanges();
        CharSetTest.assertEquals((String)"[b-d]", (String)dtob.toString());
        CharSetTest.assertEquals((int)1, (int)array.length);
    }

    public void testSerialization() {
        CharSet set = CharSet.getInstance((String[])new String[]{"a"});
        CharSetTest.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        CharSetTest.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"be-f^a-z"});
        CharSetTest.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
    }

    public void testStatics() {
        Object[] array = CharSet.EMPTY.getCharRanges();
        CharSetTest.assertEquals((int)0, (int)array.length);
        array = CharSet.ASCII_ALPHA.getCharRanges();
        CharSetTest.assertEquals((int)2, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_ALPHA_LOWER.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        array = CharSet.ASCII_ALPHA_UPPER.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_NUMERIC.getCharRanges();
        CharSetTest.assertEquals((int)1, (int)array.length);
        CharSetTest.assertEquals((boolean)true, (boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'0', (char)'9')));
    }
}

