/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtilsTest
extends TestCase {
    public ClassUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        ClassUtilsTest.assertNotNull((Object)new ClassUtils());
        Constructor<?>[] cons = ClassUtils.class.getDeclaredConstructors();
        ClassUtilsTest.assertEquals((int)1, (int)cons.length);
        ClassUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        ClassUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(ClassUtils.class.getModifiers()));
        ClassUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(ClassUtils.class.getModifiers()));
    }

    public void test_getShortClassName_Object() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortClassName((Object)new ClassUtils(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"String", (String)ClassUtils.getShortClassName((Object)"hello", (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"<null>", (String)ClassUtils.getShortClassName(null, (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.1", (String)ClassUtils.getShortClassName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.1Named", (String)ClassUtils.getShortClassName((Object)new Named(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
    }

    public void test_getShortClassName_Class() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortClassName(ClassUtils.class));
        ClassUtilsTest.assertEquals((String)"Map.Entry", (String)ClassUtils.getShortClassName(Map.Entry.class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getShortClassName((Class)null));
        ClassUtilsTest.assertEquals((String)"String[]", (String)ClassUtils.getShortClassName(String[].class));
        ClassUtilsTest.assertEquals((String)"Map.Entry[]", (String)ClassUtils.getShortClassName(Map.Entry[].class));
        ClassUtilsTest.assertEquals((String)"boolean", (String)ClassUtils.getShortClassName(Boolean.TYPE));
        ClassUtilsTest.assertEquals((String)"byte", (String)ClassUtils.getShortClassName(Byte.TYPE));
        ClassUtilsTest.assertEquals((String)"char", (String)ClassUtils.getShortClassName(Character.TYPE));
        ClassUtilsTest.assertEquals((String)"short", (String)ClassUtils.getShortClassName(Short.TYPE));
        ClassUtilsTest.assertEquals((String)"int", (String)ClassUtils.getShortClassName(Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"long", (String)ClassUtils.getShortClassName(Long.TYPE));
        ClassUtilsTest.assertEquals((String)"float", (String)ClassUtils.getShortClassName(Float.TYPE));
        ClassUtilsTest.assertEquals((String)"double", (String)ClassUtils.getShortClassName(Double.TYPE));
        ClassUtilsTest.assertEquals((String)"boolean[]", (String)ClassUtils.getShortClassName(boolean[].class));
        ClassUtilsTest.assertEquals((String)"byte[]", (String)ClassUtils.getShortClassName(byte[].class));
        ClassUtilsTest.assertEquals((String)"char[]", (String)ClassUtils.getShortClassName(char[].class));
        ClassUtilsTest.assertEquals((String)"short[]", (String)ClassUtils.getShortClassName(short[].class));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getShortClassName(int[].class));
        ClassUtilsTest.assertEquals((String)"long[]", (String)ClassUtils.getShortClassName(long[].class));
        ClassUtilsTest.assertEquals((String)"float[]", (String)ClassUtils.getShortClassName(float[].class));
        ClassUtilsTest.assertEquals((String)"double[]", (String)ClassUtils.getShortClassName(double[].class));
        ClassUtilsTest.assertEquals((String)"String[][]", (String)ClassUtils.getShortClassName(String[][].class));
        ClassUtilsTest.assertEquals((String)"String[][][]", (String)ClassUtils.getShortClassName(String[][][].class));
        ClassUtilsTest.assertEquals((String)"String[][][][]", (String)ClassUtils.getShortClassName(String[][][][].class));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.2", (String)ClassUtils.getShortClassName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.2Named", (String)ClassUtils.getShortClassName(Named.class));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortClassName(Inner.class));
    }

    public void test_getShortClassName_String() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortClassName((String)ClassUtils.class.getName()));
        ClassUtilsTest.assertEquals((String)"Map.Entry", (String)ClassUtils.getShortClassName((String)Map.Entry.class.getName()));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getShortClassName((String)null));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getShortClassName((String)""));
    }

    public void test_getSimpleName_Class() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getSimpleName(ClassUtils.class));
        ClassUtilsTest.assertEquals((String)"Entry", (String)ClassUtils.getSimpleName(Map.Entry.class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getSimpleName((Class)null));
        ClassUtilsTest.assertEquals((String)"String[]", (String)ClassUtils.getSimpleName(String[].class));
        ClassUtilsTest.assertEquals((String)"Entry[]", (String)ClassUtils.getSimpleName(Map.Entry[].class));
        ClassUtilsTest.assertEquals((String)"boolean", (String)ClassUtils.getSimpleName(Boolean.TYPE));
        ClassUtilsTest.assertEquals((String)"byte", (String)ClassUtils.getSimpleName(Byte.TYPE));
        ClassUtilsTest.assertEquals((String)"char", (String)ClassUtils.getSimpleName(Character.TYPE));
        ClassUtilsTest.assertEquals((String)"short", (String)ClassUtils.getSimpleName(Short.TYPE));
        ClassUtilsTest.assertEquals((String)"int", (String)ClassUtils.getSimpleName(Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"long", (String)ClassUtils.getSimpleName(Long.TYPE));
        ClassUtilsTest.assertEquals((String)"float", (String)ClassUtils.getSimpleName(Float.TYPE));
        ClassUtilsTest.assertEquals((String)"double", (String)ClassUtils.getSimpleName(Double.TYPE));
        ClassUtilsTest.assertEquals((String)"boolean[]", (String)ClassUtils.getSimpleName(boolean[].class));
        ClassUtilsTest.assertEquals((String)"byte[]", (String)ClassUtils.getSimpleName(byte[].class));
        ClassUtilsTest.assertEquals((String)"char[]", (String)ClassUtils.getSimpleName(char[].class));
        ClassUtilsTest.assertEquals((String)"short[]", (String)ClassUtils.getSimpleName(short[].class));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getSimpleName(int[].class));
        ClassUtilsTest.assertEquals((String)"long[]", (String)ClassUtils.getSimpleName(long[].class));
        ClassUtilsTest.assertEquals((String)"float[]", (String)ClassUtils.getSimpleName(float[].class));
        ClassUtilsTest.assertEquals((String)"double[]", (String)ClassUtils.getSimpleName(double[].class));
        ClassUtilsTest.assertEquals((String)"String[][]", (String)ClassUtils.getSimpleName(String[][].class));
        ClassUtilsTest.assertEquals((String)"String[][][]", (String)ClassUtils.getSimpleName(String[][][].class));
        ClassUtilsTest.assertEquals((String)"String[][][][]", (String)ClassUtils.getSimpleName(String[][][][].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getSimpleName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"Named", (String)ClassUtils.getSimpleName(Named.class));
    }

    public void test_getSimpleName_Object() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getSimpleName((Object)new ClassUtils(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"Inner", (String)ClassUtils.getSimpleName((Object)new Inner(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"String", (String)ClassUtils.getSimpleName((Object)"hello", (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"<null>", (String)ClassUtils.getSimpleName(null, (String)"<null>"));
    }

    public void test_getPackageName_Object() {
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageName((Object)new ClassUtils(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageName((Object)new Inner(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"<null>", (String)ClassUtils.getPackageName(null, (String)"<null>"));
    }

    public void test_getPackageName_Class() {
        ClassUtilsTest.assertEquals((String)"java.lang", (String)ClassUtils.getPackageName(String.class));
        ClassUtilsTest.assertEquals((String)"java.util", (String)ClassUtils.getPackageName(Map.Entry.class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName((Class)null));
        ClassUtilsTest.assertEquals((String)"java.lang", (String)ClassUtils.getPackageName(String[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(boolean[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(byte[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(char[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(short[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(int[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(long[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(float[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName(double[].class));
        ClassUtilsTest.assertEquals((String)"java.lang", (String)ClassUtils.getPackageName(String[][].class));
        ClassUtilsTest.assertEquals((String)"java.lang", (String)ClassUtils.getPackageName(String[][][].class));
        ClassUtilsTest.assertEquals((String)"java.lang", (String)ClassUtils.getPackageName(String[][][][].class));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageName(Named.class));
    }

    public void test_getPackageName_String() {
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageName((String)ClassUtils.class.getName()));
        ClassUtilsTest.assertEquals((String)"java.util", (String)ClassUtils.getPackageName((String)Map.Entry.class.getName()));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName((String)null));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageName((String)""));
    }

    public void test_getAllSuperclasses_Class() {
        List list = ClassUtils.getAllSuperclasses(CY.class);
        ClassUtilsTest.assertEquals((int)2, (int)list.size());
        ClassUtilsTest.assertEquals(CX.class, list.get(0));
        ClassUtilsTest.assertEquals(Object.class, list.get(1));
        ClassUtilsTest.assertEquals(null, (Object)ClassUtils.getAllSuperclasses(null));
    }

    public void test_getAllInterfaces_Class() {
        List list = ClassUtils.getAllInterfaces(CY.class);
        ClassUtilsTest.assertEquals((int)6, (int)list.size());
        ClassUtilsTest.assertEquals(IB.class, list.get(0));
        ClassUtilsTest.assertEquals(IC.class, list.get(1));
        ClassUtilsTest.assertEquals(ID.class, list.get(2));
        ClassUtilsTest.assertEquals(IE.class, list.get(3));
        ClassUtilsTest.assertEquals(IF.class, list.get(4));
        ClassUtilsTest.assertEquals(IA.class, list.get(5));
        ClassUtilsTest.assertEquals(null, (Object)ClassUtils.getAllInterfaces(null));
    }

    public void test_convertClassNamesToClasses_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassNamesToClasses(list);
        ClassUtilsTest.assertEquals((int)0, (int)result.size());
        list.add("java.lang.String");
        list.add("java.lang.xxx");
        list.add("java.lang.Object");
        result = ClassUtils.convertClassNamesToClasses(list);
        ClassUtilsTest.assertEquals((int)3, (int)result.size());
        ClassUtilsTest.assertEquals(String.class, result.get(0));
        ClassUtilsTest.assertEquals(null, result.get(1));
        ClassUtilsTest.assertEquals(Object.class, result.get(2));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        try {
            ClassUtils.convertClassNamesToClasses(list);
            ClassUtilsTest.fail((String)"Should not have been able to convert list");
        }
        catch (ClassCastException expected) {
            // empty catch block
        }
        ClassUtilsTest.assertEquals(null, (Object)ClassUtils.convertClassNamesToClasses(null));
    }

    public void test_convertClassesToClassNames_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassesToClassNames(list);
        ClassUtilsTest.assertEquals((int)0, (int)result.size());
        list.add(String.class);
        list.add(null);
        list.add(Object.class);
        result = ClassUtils.convertClassesToClassNames(list);
        ClassUtilsTest.assertEquals((int)3, (int)result.size());
        ClassUtilsTest.assertEquals((String)"java.lang.String", (String)((String)result.get(0)));
        ClassUtilsTest.assertEquals(null, (String)((String)result.get(1)));
        ClassUtilsTest.assertEquals((String)"java.lang.Object", (String)((String)result.get(2)));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        try {
            ClassUtils.convertClassesToClassNames(list);
            ClassUtilsTest.fail((String)"Should not have been able to convert list");
        }
        catch (ClassCastException expected) {
            // empty catch block
        }
        ClassUtilsTest.assertEquals(null, (Object)ClassUtils.convertClassesToClassNames(null));
    }

    public void test_isInnerClass_Class() {
        ClassUtilsTest.assertEquals((boolean)true, (boolean)ClassUtils.isInnerClass(Inner.class));
        ClassUtilsTest.assertEquals((boolean)true, (boolean)ClassUtils.isInnerClass(Map.Entry.class));
        ClassUtilsTest.assertEquals((boolean)true, (boolean)ClassUtils.isInnerClass(new Cloneable(){}.getClass()));
        ClassUtilsTest.assertEquals((boolean)false, (boolean)ClassUtils.isInnerClass(((Object)((Object)this)).getClass()));
        ClassUtilsTest.assertEquals((boolean)false, (boolean)ClassUtils.isInnerClass(String.class));
        ClassUtilsTest.assertEquals((boolean)false, (boolean)ClassUtils.isInnerClass(null));
    }

    public void test_isAssignable_ClassArray_ClassArray() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])null));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1));
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2));
    }

    public void test_isAssignable_ClassArray_ClassArray_Autoboxing() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)true));
    }

    public void test_isAssignable_ClassArray_ClassArray_NoAutoboxing() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)false));
    }

    public void test_isAssignable() throws Exception {
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(String.class, null));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class));
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Object.class));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Boolean.TYPE, Object.class));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE));
        ClassUtilsTest.assertEquals((boolean)autoboxing, (boolean)ClassUtils.isAssignable(Boolean.class, Object.class));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class));
    }

    public void test_isAssignable_Autoboxing() throws Exception {
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)true));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Object.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)true));
    }

    public void test_isAssignable_NoAutoboxing() throws Exception {
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Object.class, (boolean)false));
        ClassUtilsTest.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)false));
        ClassUtilsTest.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)false));
    }

    public void test_isAssignable_Widening() throws Exception {
        ClassUtilsTest.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.TYPE, Character.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> byte", (boolean)ClassUtils.isAssignable(Byte.TYPE, Byte.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> short", (boolean)ClassUtils.isAssignable(Byte.TYPE, Short.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> int", (boolean)ClassUtils.isAssignable(Byte.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> long", (boolean)ClassUtils.isAssignable(Byte.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> float", (boolean)ClassUtils.isAssignable(Byte.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"byte -> double", (boolean)ClassUtils.isAssignable(Byte.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.TYPE, Byte.TYPE));
        ClassUtilsTest.assertTrue((String)"short -> short", (boolean)ClassUtils.isAssignable(Short.TYPE, Short.TYPE));
        ClassUtilsTest.assertTrue((String)"short -> int", (boolean)ClassUtils.isAssignable(Short.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((String)"short -> long", (boolean)ClassUtils.isAssignable(Short.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"short -> float", (boolean)ClassUtils.isAssignable(Short.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"short -> double", (boolean)ClassUtils.isAssignable(Short.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertTrue((String)"char -> char", (boolean)ClassUtils.isAssignable(Character.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.TYPE, Short.TYPE));
        ClassUtilsTest.assertTrue((String)"char -> int", (boolean)ClassUtils.isAssignable(Character.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((String)"char -> long", (boolean)ClassUtils.isAssignable(Character.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"char -> float", (boolean)ClassUtils.isAssignable(Character.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"char -> double", (boolean)ClassUtils.isAssignable(Character.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.TYPE, Short.TYPE));
        ClassUtilsTest.assertTrue((String)"int -> int", (boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((String)"int -> long", (boolean)ClassUtils.isAssignable(Integer.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"int -> float", (boolean)ClassUtils.isAssignable(Integer.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"int -> double", (boolean)ClassUtils.isAssignable(Integer.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.TYPE, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.TYPE, Integer.TYPE));
        ClassUtilsTest.assertTrue((String)"long -> long", (boolean)ClassUtils.isAssignable(Long.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"long -> float", (boolean)ClassUtils.isAssignable(Long.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"long -> double", (boolean)ClassUtils.isAssignable(Long.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.TYPE, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.TYPE, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.TYPE, Long.TYPE));
        ClassUtilsTest.assertTrue((String)"float -> float", (boolean)ClassUtils.isAssignable(Float.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"float -> double", (boolean)ClassUtils.isAssignable(Float.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.TYPE, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.TYPE, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.TYPE, Long.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.TYPE, Float.TYPE));
        ClassUtilsTest.assertTrue((String)"double -> double", (boolean)ClassUtils.isAssignable(Double.TYPE, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.TYPE, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Long.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Float.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Double.TYPE));
        ClassUtilsTest.assertTrue((String)"boolean -> boolean", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
    }

    public void test_isAssignable_DefaultUnboxing_Widening() throws Exception {
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        ClassUtilsTest.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> byte", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Byte.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> short", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Short.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> int", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> long", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Byte.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> short", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Short.class, Short.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> int", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Short.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> long", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Short.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Short.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Short.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> char", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Character.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.class, Short.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> int", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Character.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> long", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Character.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Character.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Character.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE));
        ClassUtilsTest.assertEquals((String)"int -> int", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"int -> long", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"int -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"int -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Integer.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.class, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"long -> long", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Long.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"long -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Long.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"long -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Long.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.class, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.class, Long.TYPE));
        ClassUtilsTest.assertEquals((String)"float -> float", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Float.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"float -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Float.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.class, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.class, Long.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.class, Float.TYPE));
        ClassUtilsTest.assertEquals((String)"double -> double", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Double.class, Double.TYPE));
        ClassUtilsTest.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE));
        ClassUtilsTest.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE));
        ClassUtilsTest.assertEquals((String)"boolean -> boolean", (boolean)autoboxing, (boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE));
    }

    public void test_isAssignable_Unboxing_Widening() throws Exception {
        ClassUtilsTest.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> byte", (boolean)ClassUtils.isAssignable(Byte.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> short", (boolean)ClassUtils.isAssignable(Byte.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> int", (boolean)ClassUtils.isAssignable(Byte.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> long", (boolean)ClassUtils.isAssignable(Byte.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> float", (boolean)ClassUtils.isAssignable(Byte.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"byte -> double", (boolean)ClassUtils.isAssignable(Byte.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"short -> short", (boolean)ClassUtils.isAssignable(Short.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"short -> int", (boolean)ClassUtils.isAssignable(Short.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"short -> long", (boolean)ClassUtils.isAssignable(Short.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"short -> float", (boolean)ClassUtils.isAssignable(Short.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"short -> double", (boolean)ClassUtils.isAssignable(Short.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"char -> char", (boolean)ClassUtils.isAssignable(Character.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"char -> int", (boolean)ClassUtils.isAssignable(Character.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"char -> long", (boolean)ClassUtils.isAssignable(Character.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"char -> float", (boolean)ClassUtils.isAssignable(Character.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"char -> double", (boolean)ClassUtils.isAssignable(Character.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"int -> int", (boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"int -> long", (boolean)ClassUtils.isAssignable(Integer.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"int -> float", (boolean)ClassUtils.isAssignable(Integer.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"int -> double", (boolean)ClassUtils.isAssignable(Integer.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"long -> long", (boolean)ClassUtils.isAssignable(Long.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"long -> float", (boolean)ClassUtils.isAssignable(Long.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"long -> double", (boolean)ClassUtils.isAssignable(Long.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"float -> float", (boolean)ClassUtils.isAssignable(Float.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"float -> double", (boolean)ClassUtils.isAssignable(Float.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"double -> double", (boolean)ClassUtils.isAssignable(Double.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE, (boolean)true));
        ClassUtilsTest.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE, (boolean)true));
        ClassUtilsTest.assertTrue((String)"boolean -> boolean", (boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
    }

    public void testPrimitiveToWrapper() {
        ClassUtilsTest.assertEquals((String)"boolean -> Boolean.class", Boolean.class, (Object)ClassUtils.primitiveToWrapper(Boolean.TYPE));
        ClassUtilsTest.assertEquals((String)"byte -> Byte.class", Byte.class, (Object)ClassUtils.primitiveToWrapper(Byte.TYPE));
        ClassUtilsTest.assertEquals((String)"char -> Character.class", Character.class, (Object)ClassUtils.primitiveToWrapper(Character.TYPE));
        ClassUtilsTest.assertEquals((String)"short -> Short.class", Short.class, (Object)ClassUtils.primitiveToWrapper(Short.TYPE));
        ClassUtilsTest.assertEquals((String)"int -> Integer.class", Integer.class, (Object)ClassUtils.primitiveToWrapper(Integer.TYPE));
        ClassUtilsTest.assertEquals((String)"long -> Long.class", Long.class, (Object)ClassUtils.primitiveToWrapper(Long.TYPE));
        ClassUtilsTest.assertEquals((String)"double -> Double.class", Double.class, (Object)ClassUtils.primitiveToWrapper(Double.TYPE));
        ClassUtilsTest.assertEquals((String)"float -> Float.class", Float.class, (Object)ClassUtils.primitiveToWrapper(Float.TYPE));
        ClassUtilsTest.assertEquals((String)"String.class -> String.class", String.class, (Object)ClassUtils.primitiveToWrapper(String.class));
        ClassUtilsTest.assertEquals((String)"ClassUtils.class -> ClassUtils.class", ClassUtils.class, (Object)ClassUtils.primitiveToWrapper(ClassUtils.class));
        ClassUtilsTest.assertEquals((String)"Void.TYPE -> Void.TYPE", Void.TYPE, (Object)ClassUtils.primitiveToWrapper(Void.TYPE));
        ClassUtilsTest.assertNull((String)"null -> null", (Object)ClassUtils.primitiveToWrapper(null));
    }

    public void testPrimitivesToWrappers() {
        ClassUtilsTest.assertNull((String)"null -> null", (Object)ClassUtils.primitivesToWrappers((Class[])null));
        ClassUtilsTest.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.primitivesToWrappers((Class[])new Class[0])));
        Object[] castNull = ClassUtils.primitivesToWrappers((Class[])new Class[]{null});
        ClassUtilsTest.assertTrue((String)"(Class<?>)null -> [null]", (boolean)Arrays.equals(new Class[]{null}, castNull));
        ClassUtilsTest.assertEquals((String)"empty -> empty", (Object)ArrayUtils.EMPTY_CLASS_ARRAY, (Object)ClassUtils.primitivesToWrappers((Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, String.class, ClassUtils.class};
        Class[] wrappers = ClassUtils.primitivesToWrappers((Class[])primitives);
        for (int i = 0; i < primitives.length; ++i) {
            Class primitive = primitives[i];
            Class expectedWrapper = ClassUtils.primitiveToWrapper((Class)primitive);
            ClassUtilsTest.assertEquals((String)(primitive + " -> " + expectedWrapper), (Object)expectedWrapper, (Object)wrappers[i]);
        }
        Class[] noPrimitives = new Class[]{String.class, ClassUtils.class, Void.TYPE};
        ClassUtilsTest.assertNotSame((String)"unmodified", (Object)noPrimitives, (Object)ClassUtils.primitivesToWrappers((Class[])noPrimitives));
    }

    public void testWrapperToPrimitive() {
        Class[] primitives;
        for (Class primitive : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            Class wrapperCls = ClassUtils.primitiveToWrapper((Class)primitive);
            ClassUtilsTest.assertFalse((String)"Still primitive", (boolean)wrapperCls.isPrimitive());
            ClassUtilsTest.assertEquals((String)(wrapperCls + " -> " + primitive), (Object)primitive, (Object)ClassUtils.wrapperToPrimitive((Class)wrapperCls));
        }
    }

    public void testWrapperToPrimitiveNoWrapper() {
        ClassUtilsTest.assertNull((String)"Wrong result for non wrapper class", (Object)ClassUtils.wrapperToPrimitive(String.class));
    }

    public void testWrapperToPrimitiveNull() {
        ClassUtilsTest.assertNull((String)"Wrong result for null class", (Object)ClassUtils.wrapperToPrimitive(null));
    }

    public void testWrappersToPrimitives() {
        Class[] classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, ClassUtils.class, null};
        Class[] primitives = ClassUtils.wrappersToPrimitives((Class[])classes);
        ClassUtilsTest.assertEquals((String)"Wrong length of result array", (int)classes.length, (int)primitives.length);
        for (int i = 0; i < classes.length; ++i) {
            Class expectedPrimitive = ClassUtils.wrapperToPrimitive((Class)classes[i]);
            ClassUtilsTest.assertEquals((String)(classes[i] + " -> " + expectedPrimitive), (Object)expectedPrimitive, (Object)primitives[i]);
        }
    }

    public void testWrappersToPrimitivesNull() {
        ClassUtilsTest.assertNull((String)"Wrong result for null input", (Object)ClassUtils.wrappersToPrimitives((Class[])null));
        ClassUtilsTest.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.wrappersToPrimitives((Class[])new Class[0])));
        Object[] castNull = ClassUtils.wrappersToPrimitives((Class[])new Class[]{null});
        ClassUtilsTest.assertTrue((String)"(Class<?>)null -> [null]", (boolean)Arrays.equals(new Class[]{null}, castNull));
    }

    public void testWrappersToPrimitivesEmpty() {
        Class[] empty = new Class[]{};
        ClassUtilsTest.assertEquals((String)"Wrong result for empty input", (Object)empty, (Object)ClassUtils.wrappersToPrimitives((Class[])empty));
    }

    public void testGetClassClassNotFound() throws Exception {
        this.assertGetClassThrowsClassNotFound("bool");
        this.assertGetClassThrowsClassNotFound("bool[]");
        this.assertGetClassThrowsClassNotFound("integer[]");
    }

    public void testGetClassInvalidArguments() throws Exception {
        this.assertGetClassThrowsNullPointerException(null);
        this.assertGetClassThrowsClassNotFound("[][][]");
        this.assertGetClassThrowsClassNotFound("[[]");
        this.assertGetClassThrowsClassNotFound("[");
        this.assertGetClassThrowsClassNotFound("java.lang.String][");
        this.assertGetClassThrowsClassNotFound(".hello.world");
        this.assertGetClassThrowsClassNotFound("hello..world");
    }

    public void testWithInterleavingWhitespace() throws ClassNotFoundException {
        ClassUtilsTest.assertEquals(int[].class, (Object)ClassUtils.getClass((String)" int [ ] "));
        ClassUtilsTest.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"\rlong\t[\n]\r"));
        ClassUtilsTest.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"\tshort                \t\t[]"));
        ClassUtilsTest.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[\t\t\n\r]   "));
    }

    public void testGetInnerClass() throws ClassNotFoundException {
        ClassUtilsTest.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner.DeeplyNested"));
        ClassUtilsTest.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner$DeeplyNested"));
        ClassUtilsTest.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner$DeeplyNested"));
        ClassUtilsTest.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner.DeeplyNested"));
    }

    public void testGetClassByNormalNameArrays() throws ClassNotFoundException {
        ClassUtilsTest.assertEquals(int[].class, (Object)ClassUtils.getClass((String)"int[]"));
        ClassUtilsTest.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"long[]"));
        ClassUtilsTest.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"short[]"));
        ClassUtilsTest.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[]"));
        ClassUtilsTest.assertEquals(char[].class, (Object)ClassUtils.getClass((String)"char[]"));
        ClassUtilsTest.assertEquals(float[].class, (Object)ClassUtils.getClass((String)"float[]"));
        ClassUtilsTest.assertEquals(double[].class, (Object)ClassUtils.getClass((String)"double[]"));
        ClassUtilsTest.assertEquals(boolean[].class, (Object)ClassUtils.getClass((String)"boolean[]"));
        ClassUtilsTest.assertEquals(String[].class, (Object)ClassUtils.getClass((String)"java.lang.String[]"));
        ClassUtilsTest.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map.Entry[]"));
        ClassUtilsTest.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map$Entry[]"));
        ClassUtilsTest.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map.Entry;"));
        ClassUtilsTest.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map$Entry;"));
    }

    public void testGetClassByNormalNameArrays2D() throws ClassNotFoundException {
        ClassUtilsTest.assertEquals(int[][].class, (Object)ClassUtils.getClass((String)"int[][]"));
        ClassUtilsTest.assertEquals(long[][].class, (Object)ClassUtils.getClass((String)"long[][]"));
        ClassUtilsTest.assertEquals(short[][].class, (Object)ClassUtils.getClass((String)"short[][]"));
        ClassUtilsTest.assertEquals(byte[][].class, (Object)ClassUtils.getClass((String)"byte[][]"));
        ClassUtilsTest.assertEquals(char[][].class, (Object)ClassUtils.getClass((String)"char[][]"));
        ClassUtilsTest.assertEquals(float[][].class, (Object)ClassUtils.getClass((String)"float[][]"));
        ClassUtilsTest.assertEquals(double[][].class, (Object)ClassUtils.getClass((String)"double[][]"));
        ClassUtilsTest.assertEquals(boolean[][].class, (Object)ClassUtils.getClass((String)"boolean[][]"));
        ClassUtilsTest.assertEquals(String[][].class, (Object)ClassUtils.getClass((String)"java.lang.String[][]"));
    }

    public void testGetClassWithArrayClasses2D() throws Exception {
        this.assertGetClassReturnsClass(String[][].class);
        this.assertGetClassReturnsClass(int[][].class);
        this.assertGetClassReturnsClass(long[][].class);
        this.assertGetClassReturnsClass(short[][].class);
        this.assertGetClassReturnsClass(byte[][].class);
        this.assertGetClassReturnsClass(char[][].class);
        this.assertGetClassReturnsClass(float[][].class);
        this.assertGetClassReturnsClass(double[][].class);
        this.assertGetClassReturnsClass(boolean[][].class);
    }

    public void testGetClassWithArrayClasses() throws Exception {
        this.assertGetClassReturnsClass(String[].class);
        this.assertGetClassReturnsClass(int[].class);
        this.assertGetClassReturnsClass(long[].class);
        this.assertGetClassReturnsClass(short[].class);
        this.assertGetClassReturnsClass(byte[].class);
        this.assertGetClassReturnsClass(char[].class);
        this.assertGetClassReturnsClass(float[].class);
        this.assertGetClassReturnsClass(double[].class);
        this.assertGetClassReturnsClass(boolean[].class);
    }

    public void testGetClassRawPrimitives() throws ClassNotFoundException {
        ClassUtilsTest.assertEquals(Integer.TYPE, (Object)ClassUtils.getClass((String)"int"));
        ClassUtilsTest.assertEquals(Long.TYPE, (Object)ClassUtils.getClass((String)"long"));
        ClassUtilsTest.assertEquals(Short.TYPE, (Object)ClassUtils.getClass((String)"short"));
        ClassUtilsTest.assertEquals(Byte.TYPE, (Object)ClassUtils.getClass((String)"byte"));
        ClassUtilsTest.assertEquals(Character.TYPE, (Object)ClassUtils.getClass((String)"char"));
        ClassUtilsTest.assertEquals(Float.TYPE, (Object)ClassUtils.getClass((String)"float"));
        ClassUtilsTest.assertEquals(Double.TYPE, (Object)ClassUtils.getClass((String)"double"));
        ClassUtilsTest.assertEquals(Boolean.TYPE, (Object)ClassUtils.getClass((String)"boolean"));
    }

    private void assertGetClassReturnsClass(Class<?> c) throws Exception {
        ClassUtilsTest.assertEquals(c, (Object)ClassUtils.getClass((String)c.getName()));
    }

    private void assertGetClassThrowsException(String className, Class<?> exceptionType) throws Exception {
        try {
            ClassUtils.getClass((String)className);
            ClassUtilsTest.fail((String)("ClassUtils.getClass() should fail with an exception of type " + exceptionType.getName() + " when given class name \"" + className + "\"."));
        }
        catch (Exception e) {
            ClassUtilsTest.assertTrue((boolean)exceptionType.isAssignableFrom(e.getClass()));
        }
    }

    private void assertGetClassThrowsNullPointerException(String className) throws Exception {
        this.assertGetClassThrowsException(className, NullPointerException.class);
    }

    private void assertGetClassThrowsClassNotFound(String className) throws Exception {
        this.assertGetClassThrowsException(className, ClassNotFoundException.class);
    }

    public void testShowJavaBug() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = set.getClass().getMethod("isEmpty", new Class[0]);
        try {
            isEmptyMethod.invoke(set, new Object[0]);
            ClassUtilsTest.fail((String)"Failed to throw IllegalAccessException as expected");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void testGetPublicMethod() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = ClassUtils.getPublicMethod(set.getClass(), (String)"isEmpty", (Class[])new Class[0]);
        ClassUtilsTest.assertTrue((boolean)Modifier.isPublic(isEmptyMethod.getDeclaringClass().getModifiers()));
        try {
            isEmptyMethod.invoke(set, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            ClassUtilsTest.fail((String)"Should not have thrown IllegalAccessException");
        }
        Method toStringMethod = ClassUtils.getPublicMethod(Object.class, (String)"toString", (Class[])new Class[0]);
        ClassUtilsTest.assertEquals((Object)Object.class.getMethod("toString", new Class[0]), (Object)toStringMethod);
    }

    public void testToClass_object() {
        ClassUtilsTest.assertNull((Object)ClassUtils.toClass((Object[])null));
        ClassUtilsTest.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.toClass((Object[])new Object[0])));
        Object[] castNull = ClassUtils.toClass((Object[])new Object[]{null});
        ClassUtilsTest.assertTrue((String)"(Object)null -> [null]", (boolean)Arrays.equals(new Object[]{null}, castNull));
        ClassUtilsTest.assertSame((Object)ArrayUtils.EMPTY_CLASS_ARRAY, (Object)ClassUtils.toClass((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY));
        ClassUtilsTest.assertTrue((boolean)Arrays.equals(new Class[]{String.class, Integer.class, Double.class}, ClassUtils.toClass((Object[])new Object[]{"Test", 1, 99.0})));
        ClassUtilsTest.assertTrue((boolean)Arrays.equals(new Class[]{String.class, null, Double.class}, ClassUtils.toClass((Object[])new Object[]{"Test", null, 99.0})));
    }

    public void test_getShortCanonicalName_Object() {
        ClassUtilsTest.assertEquals((String)"<null>", (String)ClassUtils.getShortCanonicalName(null, (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[]", (String)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[][]", (String)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getShortCanonicalName((Object)new int[0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"int[][]", (String)ClassUtils.getShortCanonicalName((Object)new int[0][0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.6", (String)ClassUtils.getShortCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.5Named", (String)ClassUtils.getShortCanonicalName((Object)new Named(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    public void test_getShortCanonicalName_Class() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortCanonicalName(ClassUtils.class));
        ClassUtilsTest.assertEquals((String)"ClassUtils[]", (String)ClassUtils.getShortCanonicalName(ClassUtils[].class));
        ClassUtilsTest.assertEquals((String)"ClassUtils[][]", (String)ClassUtils.getShortCanonicalName(ClassUtils[][].class));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getShortCanonicalName(int[].class));
        ClassUtilsTest.assertEquals((String)"int[][]", (String)ClassUtils.getShortCanonicalName(int[][].class));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.7", (String)ClassUtils.getShortCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.6Named", (String)ClassUtils.getShortCanonicalName(Named.class));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortCanonicalName(Inner.class));
    }

    public void test_getShortCanonicalName_String() {
        ClassUtilsTest.assertEquals((String)"ClassUtils", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[]", (String)ClassUtils.getShortCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[][]", (String)ClassUtils.getShortCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[]", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        ClassUtilsTest.assertEquals((String)"ClassUtils[][]", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getShortCanonicalName((String)"[I"));
        ClassUtilsTest.assertEquals((String)"int[][]", (String)ClassUtils.getShortCanonicalName((String)"[[I"));
        ClassUtilsTest.assertEquals((String)"int[]", (String)ClassUtils.getShortCanonicalName((String)"int[]"));
        ClassUtilsTest.assertEquals((String)"int[][]", (String)ClassUtils.getShortCanonicalName((String)"int[][]"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.6", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.5Named", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        ClassUtilsTest.assertEquals((String)"ClassUtilsTest.Inner", (String)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
    }

    public void test_getPackageCanonicalName_Object() {
        ClassUtilsTest.assertEquals((String)"<null>", (String)ClassUtils.getPackageCanonicalName(null, (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((Object)new int[0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((Object)new int[0][0], (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new Named(), (String)"<null>"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    public void test_getPackageCanonicalName_Class() {
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(ClassUtils.class));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(ClassUtils[].class));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(ClassUtils[][].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName(int[].class));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName(int[][].class));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(Named.class));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName(Inner.class));
    }

    public void test_getPackageCanonicalName_String() {
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((String)"[I"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((String)"[[I"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((String)"int[]"));
        ClassUtilsTest.assertEquals((String)"", (String)ClassUtils.getPackageCanonicalName((String)"int[][]"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        ClassUtilsTest.assertEquals((String)"org.apache.commons.lang3", (String)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
    }

    private static class CY
    extends CX
    implements IB,
    IC {
        private CY() {
        }
    }

    private static class CX
    implements IB,
    IA,
    IE {
        private CX() {
        }
    }

    private static interface IF {
    }

    private static interface IE
    extends IF {
    }

    private static interface ID {
    }

    private static interface IC
    extends ID,
    IE {
    }

    private static interface IB {
    }

    private static interface IA {
    }

    private static class Inner {
        private Inner() {
        }

        private class DeeplyNested {
            private DeeplyNested() {
            }
        }
    }
}

