/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.TooMany;
import org.apache.commons.lang3.Traffic;
import org.junit.Assert;
import org.junit.Test;

public class EnumUtilsTest {
    @Test
    public void testConstructable() {
        new EnumUtils();
    }

    @Test
    public void test_getEnumMap() {
        Map test = EnumUtils.getEnumMap(Traffic.class);
        Assert.assertEquals((String)"getEnumMap not created correctly", (Object)"{RED=RED, AMBER=AMBER, GREEN=GREEN}", (Object)test.toString());
        Assert.assertEquals((long)3L, (long)test.size());
        Assert.assertEquals((Object)true, (Object)test.containsKey("RED"));
        Assert.assertEquals((Object)((Object)Traffic.RED), test.get("RED"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("AMBER"));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), test.get("AMBER"));
        Assert.assertEquals((Object)true, (Object)test.containsKey("GREEN"));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), test.get("GREEN"));
        Assert.assertEquals((Object)false, (Object)test.containsKey("PURPLE"));
    }

    @Test
    public void test_getEnumList() {
        List test = EnumUtils.getEnumList(Traffic.class);
        Assert.assertEquals((long)3L, (long)test.size());
        Assert.assertEquals((Object)((Object)Traffic.RED), test.get(0));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), test.get(1));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), test.get(2));
    }

    @Test
    public void test_isEnum() {
        Assert.assertEquals((Object)true, (Object)EnumUtils.isValidEnum(Traffic.class, (String)"RED"));
        Assert.assertEquals((Object)true, (Object)EnumUtils.isValidEnum(Traffic.class, (String)"AMBER"));
        Assert.assertEquals((Object)true, (Object)EnumUtils.isValidEnum(Traffic.class, (String)"GREEN"));
        Assert.assertEquals((Object)false, (Object)EnumUtils.isValidEnum(Traffic.class, (String)"PURPLE"));
        Assert.assertEquals((Object)false, (Object)EnumUtils.isValidEnum(Traffic.class, null));
    }

    @Test(expected=NullPointerException.class)
    public void test_isEnum_nullClass() {
        EnumUtils.isValidEnum((Class)null, (String)"PURPLE");
    }

    @Test
    public void test_getEnum() {
        Assert.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED"));
        Assert.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER"));
        Assert.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN"));
        Assert.assertEquals(null, (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE"));
        Assert.assertEquals(null, (Object)EnumUtils.getEnum(Traffic.class, null));
    }

    @Test(expected=NullPointerException.class)
    public void test_getEnum_nullClass() {
        EnumUtils.getEnum((Class)null, (String)"PURPLE");
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullClass() {
        EnumUtils.generateBitVector(null, EnumSet.of(Traffic.RED));
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullIterable() {
        EnumUtils.generateBitVector(null, (Iterable)null);
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullClassWithArray() {
        EnumUtils.generateBitVector(null, (Enum[])new Traffic[]{Traffic.RED});
    }

    @Test(expected=NullPointerException.class)
    public void test_generateBitVector_nullArray() {
        EnumUtils.generateBitVector(null, (Enum[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_longClass() {
        EnumUtils.generateBitVector(TooMany.class, EnumSet.of(TooMany.A1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_longClassWithArray() {
        EnumUtils.generateBitVector(TooMany.class, (Enum[])new TooMany[]{TooMany.A1});
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        EnumUtils.generateBitVector(rawType, rawList);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_generateBitVector_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        EnumUtils.generateBitVector(rawType, (Enum[])new Enum[0]);
    }

    @Test
    public void test_generateBitVector() {
        Assert.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.noneOf(Traffic.class)));
        Assert.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED)));
        Assert.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER)));
        Assert.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.GREEN)));
        Assert.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)));
        Assert.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)));
        Assert.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)));
    }

    @Test
    public void test_generateBitVectorFromArray() {
        Assert.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[0]));
        Assert.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}));
        Assert.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}));
        Assert.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}));
        Assert.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}));
        Assert.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}));
        Assert.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}));
        Assert.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}));
    }

    @Test(expected=NullPointerException.class)
    public void test_processBitVector_nullClass() {
        Class empty = null;
        EnumUtils.processBitVector(empty, (long)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_processBitVector_longClass() {
        EnumUtils.processBitVector(TooMany.class, (long)0L);
    }

    @Test
    public void test_processBitVector() {
        Assert.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVector(Traffic.class, (long)0L));
        Assert.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVector(Traffic.class, (long)1L));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)2L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)3L));
        Assert.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)4L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)5L));
        Assert.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)6L));
        Assert.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)7L));
    }
}

