/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.apache.commons.lang3.mutable.MutableObject;
import org.junit.Assert;
import org.junit.Test;

public class ObjectUtilsTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new ObjectUtils());
        Constructor<?>[] cons = ObjectUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertEquals((Object)true, (Object)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertEquals((Object)true, (Object)Modifier.isPublic(ObjectUtils.class.getModifiers()));
        Assert.assertEquals((Object)false, (Object)Modifier.isFinal(ObjectUtils.class.getModifiers()));
    }

    @Test
    public void testIsNull() {
        String o = FOO;
        String dflt = BAR;
        Assert.assertSame((String)"dflt was not returned when o was null", (Object)dflt, (Object)ObjectUtils.defaultIfNull(null, (Object)dflt));
        Assert.assertSame((String)"dflt was returned when o was not null", (Object)o, (Object)ObjectUtils.defaultIfNull((Object)o, (Object)dflt));
    }

    @Test
    public void testFirstNonNull() {
        Assert.assertEquals(null, (Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        Assert.assertEquals((Object)"", (Object)ObjectUtils.firstNonNull((Object[])new String[]{null, ""}));
        String firstNonNullGenerics = (String)ObjectUtils.firstNonNull((Object[])new String[]{null, null, "123", "456"});
        Assert.assertEquals((Object)"123", (Object)firstNonNullGenerics);
        Assert.assertEquals((Object)"123", (Object)ObjectUtils.firstNonNull((Object[])new String[]{"123", null, "456", null}));
        Assert.assertEquals(null, (Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        Assert.assertSame((Object)Boolean.TRUE, (Object)ObjectUtils.firstNonNull((Object[])new Boolean[]{Boolean.TRUE}));
        Assert.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[0]));
        Assert.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null, null}));
        Assert.assertNull((Object)ObjectUtils.firstNonNull((Object[])new Object[]{null}));
        Assert.assertNull((Object)ObjectUtils.firstNonNull((Object[])null));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((String)"ObjectUtils.equals(null, null) returned false", (boolean)ObjectUtils.equals(null, null));
        Assert.assertTrue((String)"ObjectUtils.equals(\"foo\", null) returned true", (!ObjectUtils.equals((Object)FOO, null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"ObjectUtils.equals(null, \"bar\") returned true", (!ObjectUtils.equals(null, (Object)BAR) ? 1 : 0) != 0);
        Assert.assertTrue((String)"ObjectUtils.equals(\"foo\", \"bar\") returned true", (!ObjectUtils.equals((Object)FOO, (Object)BAR) ? 1 : 0) != 0);
        Assert.assertTrue((String)"ObjectUtils.equals(\"foo\", \"foo\") returned false", (boolean)ObjectUtils.equals((Object)FOO, (Object)FOO));
    }

    @Test
    public void testNotEqual() {
        Assert.assertFalse((String)"ObjectUtils.notEqual(null, null) returned false", (boolean)ObjectUtils.notEqual(null, null));
        Assert.assertTrue((String)"ObjectUtils.notEqual(\"foo\", null) returned true", (boolean)ObjectUtils.notEqual((Object)FOO, null));
        Assert.assertTrue((String)"ObjectUtils.notEqual(null, \"bar\") returned true", (boolean)ObjectUtils.notEqual(null, (Object)BAR));
        Assert.assertTrue((String)"ObjectUtils.notEqual(\"foo\", \"bar\") returned true", (boolean)ObjectUtils.notEqual((Object)FOO, (Object)BAR));
        Assert.assertFalse((String)"ObjectUtils.notEqual(\"foo\", \"foo\") returned false", (boolean)ObjectUtils.notEqual((Object)FOO, (Object)FOO));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)0L, (long)ObjectUtils.hashCode(null));
        Assert.assertEquals((long)"a".hashCode(), (long)ObjectUtils.hashCode((Object)"a"));
    }

    @Test
    public void testHashCodeMulti_multiple_emptyArray() {
        Object[] array = new Object[]{};
        Assert.assertEquals((long)1L, (long)ObjectUtils.hashCodeMulti((Object[])array));
    }

    @Test
    public void testHashCodeMulti_multiple_nullArray() {
        Object[] array = null;
        Assert.assertEquals((long)1L, (long)ObjectUtils.hashCodeMulti(array));
    }

    @Test
    public void testHashCodeMulti_multiple_likeList() {
        ArrayList<Object> list0 = new ArrayList<Object>(Arrays.asList(new Object[0]));
        Assert.assertEquals((long)((Object)list0).hashCode(), (long)ObjectUtils.hashCodeMulti((Object[])new Object[0]));
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList("a"));
        Assert.assertEquals((long)((Object)list1).hashCode(), (long)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a"}));
        ArrayList<String> list2 = new ArrayList<String>(Arrays.asList("a", "b"));
        Assert.assertEquals((long)((Object)list2).hashCode(), (long)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b"}));
        ArrayList<String> list3 = new ArrayList<String>(Arrays.asList("a", "b", "c"));
        Assert.assertEquals((long)((Object)list3).hashCode(), (long)ObjectUtils.hashCodeMulti((Object[])new Object[]{"a", "b", "c"}));
    }

    @Test
    public void testIdentityToString() {
        Assert.assertEquals(null, (Object)ObjectUtils.identityToString(null));
        Assert.assertEquals((Object)("java.lang.String@" + Integer.toHexString(System.identityHashCode(FOO))), (Object)ObjectUtils.identityToString((Object)FOO));
        Integer i = 90;
        String expected = "java.lang.Integer@" + Integer.toHexString(System.identityHashCode(i));
        Assert.assertEquals((Object)expected, (Object)ObjectUtils.identityToString((Object)i));
        StringBuffer buffer = new StringBuffer();
        ObjectUtils.identityToString((StringBuffer)buffer, (Object)i);
        Assert.assertEquals((Object)expected, (Object)buffer.toString());
        try {
            ObjectUtils.identityToString(null, (Object)"tmp");
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            ObjectUtils.identityToString((StringBuffer)new StringBuffer(), null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
    }

    @Test
    public void testToString_Object() {
        Assert.assertEquals((Object)"", (Object)ObjectUtils.toString((Object)null));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE));
    }

    @Test
    public void testToString_ObjectString() {
        Assert.assertEquals((Object)BAR, (Object)ObjectUtils.toString((Object)null, (String)BAR));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)ObjectUtils.toString((Object)Boolean.TRUE, (String)BAR));
    }

    @Test
    public void testNull() {
        Assert.assertNotNull((Object)ObjectUtils.NULL);
        Assert.assertTrue((boolean)(ObjectUtils.NULL instanceof ObjectUtils.Null));
        Assert.assertSame((Object)ObjectUtils.NULL, (Object)SerializationUtils.clone((Serializable)ObjectUtils.NULL));
    }

    @Test
    public void testMax() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullAray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assert.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assert.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null}));
        Assert.assertNull((Object)ObjectUtils.max(nullAray));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, null}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assert.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.max((Comparable[])new Date[]{null, minComparable, null, nonNullComparable1}));
        Assert.assertNull((Object)ObjectUtils.max((Comparable[])new String[]{null, null}));
    }

    @Test
    public void testMin() {
        Calendar calendar = Calendar.getInstance();
        Date nonNullComparable1 = calendar.getTime();
        Date nonNullComparable2 = calendar.getTime();
        Comparable[] nullAray = null;
        calendar.set(1, calendar.get(1) - 1);
        Date minComparable = calendar.getTime();
        Assert.assertNotSame((Object)nonNullComparable1, (Object)nonNullComparable2);
        Assert.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null}));
        Assert.assertNull((Object)ObjectUtils.min(nullAray));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, null}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null}));
        Assert.assertSame((Object)nonNullComparable1, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, nonNullComparable2}));
        Assert.assertSame((Object)nonNullComparable2, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable2, nonNullComparable1}));
        Assert.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{nonNullComparable1, minComparable}));
        Assert.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{minComparable, nonNullComparable1}));
        Assert.assertSame((Object)minComparable, (Object)ObjectUtils.min((Comparable[])new Date[]{null, nonNullComparable1, null, minComparable}));
        Assert.assertNull((Object)ObjectUtils.min((Comparable[])new String[]{null, null}));
    }

    @Test
    public void testCompare() {
        Integer one = 1;
        Integer two = 2;
        Comparable nullValue = null;
        Assert.assertEquals((String)"Null Null false", (long)0L, (long)ObjectUtils.compare(nullValue, nullValue));
        Assert.assertEquals((String)"Null Null true", (long)0L, (long)ObjectUtils.compare(nullValue, nullValue, (boolean)true));
        Assert.assertEquals((String)"Null one false", (long)-1L, (long)ObjectUtils.compare(nullValue, (Comparable)one));
        Assert.assertEquals((String)"Null one true", (long)1L, (long)ObjectUtils.compare(nullValue, (Comparable)one, (boolean)true));
        Assert.assertEquals((String)"one Null false", (long)1L, (long)ObjectUtils.compare((Comparable)one, nullValue));
        Assert.assertEquals((String)"one Null true", (long)-1L, (long)ObjectUtils.compare((Comparable)one, nullValue, (boolean)true));
        Assert.assertEquals((String)"one two false", (long)-1L, (long)ObjectUtils.compare((Comparable)one, (Comparable)two));
        Assert.assertEquals((String)"one two true", (long)-1L, (long)ObjectUtils.compare((Comparable)one, (Comparable)two, (boolean)true));
    }

    @Test
    public void testMedian() {
        Assert.assertEquals((Object)FOO, (Object)ObjectUtils.median((Comparable[])new String[]{FOO}));
        Assert.assertEquals((Object)BAR, (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR}));
        Assert.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz"}));
        Assert.assertEquals((Object)"baz", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah"}));
        Assert.assertEquals((Object)"blah", (Object)ObjectUtils.median((Comparable[])new String[]{FOO, BAR, "baz", "blah", "wah"}));
        Assert.assertEquals((Object)5, (Object)ObjectUtils.median((Comparable[])new Integer[]{1, 5, 10}));
        Assert.assertEquals((Object)7, (Object)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8, 9}));
        Assert.assertEquals((Object)6, (Object)ObjectUtils.median((Comparable[])new Integer[]{5, 6, 7, 8}));
    }

    @Test(expected=NullPointerException.class)
    public void testMedian_nullItems() {
        ObjectUtils.median((Comparable[])((String[])null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMedian_emptyItems() {
        ObjectUtils.median((Comparable[])new String[0]);
    }

    @Test
    public void testComparatorMedian() {
        CharSequenceComparator cmp = new CharSequenceComparator();
        NonComparableCharSequence foo = new NonComparableCharSequence(FOO);
        NonComparableCharSequence bar = new NonComparableCharSequence(BAR);
        NonComparableCharSequence baz = new NonComparableCharSequence("baz");
        NonComparableCharSequence blah = new NonComparableCharSequence("blah");
        NonComparableCharSequence wah = new NonComparableCharSequence("wah");
        Assert.assertSame((Object)foo, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo}));
        Assert.assertSame((Object)bar, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar}));
        Assert.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz}));
        Assert.assertSame((Object)baz, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah}));
        Assert.assertSame((Object)blah, (Object)ObjectUtils.median((Comparator)cmp, (Object[])new CharSequence[]{foo, bar, baz, blah, wah}));
    }

    @Test(expected=NullPointerException.class)
    public void testComparatorMedian_nullComparator() {
        ObjectUtils.median((Comparator)null, (Object[])new CharSequence[]{new NonComparableCharSequence(FOO)});
    }

    @Test(expected=NullPointerException.class)
    public void testComparatorMedian_nullItems() {
        ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testComparatorMedian_emptyItems() {
        ObjectUtils.median((Comparator)new CharSequenceComparator(), (Object[])new CharSequence[0]);
    }

    @Test
    public void testMode() {
        Assert.assertNull((Object)ObjectUtils.mode((Object[])null));
        Assert.assertNull((Object)ObjectUtils.mode((Object[])new Object[0]));
        Assert.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz"}));
        Assert.assertNull((Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO, BAR}));
        Assert.assertEquals((Object)FOO, (Object)ObjectUtils.mode((Object[])new String[]{FOO, BAR, "baz", FOO}));
        Assert.assertEquals((Object)9, (Object)ObjectUtils.mode((Object[])new Serializable[]{FOO, BAR, "baz", Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(9)}));
    }

    @Test
    public void testCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.clone((Object)string);
        Assert.assertEquals((Object)"apache", (Object)stringClone.getValue());
    }

    @Test
    public void testCloneOfNotCloneable() {
        String string = new String("apache");
        Assert.assertNull((Object)ObjectUtils.clone((Object)string));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testCloneOfUncloneable() throws Throwable {
        UncloneableString string = new UncloneableString("apache");
        try {
            ObjectUtils.clone((Object)string);
            Assert.fail((String)("Thrown " + CloneFailedException.class.getName() + " expected"));
        }
        catch (CloneFailedException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testCloneOfStringArray() {
        Assert.assertTrue((boolean)Arrays.deepEquals(new String[]{"string"}, (Object[])ObjectUtils.clone((Object)new String[]{"string"})));
    }

    @Test
    public void testCloneOfPrimitiveArray() {
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, (int[])ObjectUtils.clone((Object)new int[]{1})));
    }

    @Test
    public void testPossibleCloneOfCloneable() {
        CloneableString string = new CloneableString("apache");
        CloneableString stringClone = (CloneableString)ObjectUtils.cloneIfPossible((Object)string);
        Assert.assertEquals((Object)"apache", (Object)stringClone.getValue());
    }

    @Test
    public void testPossibleCloneOfNotCloneable() {
        String string = new String("apache");
        Assert.assertSame((Object)string, (Object)ObjectUtils.cloneIfPossible((Object)string));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testPossibleCloneOfUncloneable() throws Throwable {
        UncloneableString string = new UncloneableString("apache");
        try {
            ObjectUtils.cloneIfPossible((Object)string);
            Assert.fail((String)("Thrown " + CloneFailedException.class.getName() + " expected"));
        }
        catch (CloneFailedException e) {
            throw e.getCause();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CharSequenceComparator
    implements Comparator<CharSequence> {
        CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return ((Object)o1).toString().compareTo(((Object)o2).toString());
        }
    }

    static final class NonComparableCharSequence
    implements CharSequence {
        final String value;

        public NonComparableCharSequence(String value) {
            Validate.notNull((Object)value);
            this.value = value;
        }

        public char charAt(int arg0) {
            return this.value.charAt(arg0);
        }

        public int length() {
            return this.value.length();
        }

        public CharSequence subSequence(int arg0, int arg1) {
            return this.value.subSequence(arg0, arg1);
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UncloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        UncloneableString(String s) {
            super((Object)s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CloneableString
    extends MutableObject<String>
    implements Cloneable {
        private static final long serialVersionUID = 1L;

        CloneableString(String s) {
            super((Object)s);
        }

        public CloneableString clone() throws CloneNotSupportedException {
            return (CloneableString)super.clone();
        }
    }
}

