/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class MultiLineToStringStyleTest
extends TestCase {
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    public MultiLineToStringStyleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "]").toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]").toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "]").append("a", (Object)"hello").toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]").append("a", (Object)"hello").toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  3" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "  b=4" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<Integer>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=[]" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a={}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a={}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        MultiLineToStringStyleTest.assertEquals((String)(pBaseStr + "[" + SystemUtils.LINE_SEPARATOR + "  name=Jane Doe" + SystemUtils.LINE_SEPARATOR + "  age=25" + SystemUtils.LINE_SEPARATOR + "  smoker=true" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  3" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "  b=4" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {<null>,5,{3,6}}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {<null>,5,{3,6}}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {1,2,-3,4}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {1,2,-3,4}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {{1,2},<null>,{5}}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {{1,2},<null>,{5}}" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        MultiLineToStringStyleTest.assertEquals((String)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

