/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class NoFieldNamesToStringStyleTest
extends TestCase {
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    public NoFieldNamesToStringStyleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.NO_FIELD_NAMES_STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>,hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[hello]"), (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3,4]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<Integer>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[[]]"), (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{}]"), (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<size=0>]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{}]"), (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Ron Paul";
        p.age = 72;
        p.smoker = false;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        NoFieldNamesToStringStyleTest.assertEquals((String)(pBaseStr + "[Ron Paul,72,false]"), (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[3,4]"), (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{<null>,5,{3,6}}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{1,2,-3,4}]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[{{1,2},<null>,{5}}]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        NoFieldNamesToStringStyleTest.assertEquals((String)(this.baseStr + "[<null>]"), (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

