/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class ShortPrefixToStringStyleTest
extends TestCase {
    private final Integer base = 5;
    private final String baseStr = "Integer";

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[]", (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>,a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[<null>]").append("a", (Object)"hello").toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[3]", (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=<null>]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=3]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=3,b=4]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=<Integer>]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=<size=0>]", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=[]]", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=<size=0>]", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a={}]", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=<size=0>]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a={}]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "John Q. Public";
        p.age = 45;
        p.smoker = true;
        String pBaseStr = "ToStringStyleTest.Person";
        ShortPrefixToStringStyleTest.assertEquals((String)(pBaseStr + "[name=John Q. Public,age=45,smoker=true]"), (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[3]", (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=3]", (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[a=3,b=4]", (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{<null>,5,{3,6}}]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{<null>,5,{3,6}}]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{1,2,-3,4}]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{1,2,-3,4}]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{{1,2},<null>,{5}}]", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[{{1,2},<null>,{5}}]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        ShortPrefixToStringStyleTest.assertEquals((String)"Integer[<null>]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

