/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;

public class StandardToStringStyleTest
extends TestCase {
    private final Integer base = 5;
    private final String baseStr = "Integer";
    private static final StandardToStringStyle STYLE = new StandardToStringStyle();

    public StandardToStringStyleTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ToStringBuilder.setDefaultStyle((ToStringStyle)STYLE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    public void testBlank() {
        StandardToStringStyleTest.assertEquals((String)"Integer[]", (String)new ToStringBuilder((Object)this.base).toString());
    }

    public void testAppendSuper() {
        StandardToStringStyleTest.assertEquals((String)"Integer[]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%,a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").append("a", (Object)"hello").toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=hello]", (String)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append((Object)null).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[3]", (String)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=%NULL%]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)null).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=3]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=3,b=4]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=%Integer%]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=%SIZE=0%]", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=[]]", (String)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=%SIZE=0%]", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a={}]", (String)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=%SIZE=0%]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=[]]", (String)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Suzy Queue";
        p.age = 19;
        p.smoker = false;
        String pBaseStr = "ToStringStyleTest.Person";
        StandardToStringStyleTest.assertEquals((String)(pBaseStr + "[name=Suzy Queue,age=19,smoker=false]"), (String)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    public void testLong() {
        StandardToStringStyleTest.assertEquals((String)"Integer[3]", (String)new ToStringBuilder((Object)this.base).append(3L).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=3]", (String)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[a=3,b=4]", (String)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        StandardToStringStyleTest.assertEquals((String)"Integer[[%NULL%, 5, [3, 6]]]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[[%NULL%, 5, [3, 6]]]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        StandardToStringStyleTest.assertEquals((String)"Integer[[1, 2, -3, 4]]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[[1, 2, -3, 4]]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        StandardToStringStyleTest.assertEquals((String)"Integer[[[1, 2], %NULL%, [5]]]", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[[[1, 2], %NULL%, [5]]]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        StandardToStringStyleTest.assertEquals((String)"Integer[%NULL%]", (String)new ToStringBuilder((Object)this.base).append(array).toString());
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
        STYLE.setArrayStart("[");
        STYLE.setArraySeparator(", ");
        STYLE.setArrayEnd("]");
        STYLE.setNullText("%NULL%");
        STYLE.setSizeStartText("%SIZE=");
        STYLE.setSizeEndText("%");
        STYLE.setSummaryObjectStartText("%");
        STYLE.setSummaryObjectEndText("%");
    }
}

