/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConcurrentInitializerTest {
    @Test
    public void testGet() throws ConcurrentException {
        Assert.assertNotNull((String)"No managed object", (Object)this.createInitializer().get());
    }

    @Test
    public void testGetMultipleTimes() throws ConcurrentException {
        ConcurrentInitializer<Object> initializer = this.createInitializer();
        Object obj = initializer.get();
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)("Got different object at " + i), (Object)obj, (Object)initializer.get());
        }
    }

    @Test
    public void testGetConcurrent() throws ConcurrentException, InterruptedException {
        final ConcurrentInitializer<Object> initializer = this.createInitializer();
        int threadCount = 20;
        final CountDownLatch startLatch = new CountDownLatch(1);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GetThread
        extends Thread {
            Object object;

            GetThread() {
            }

            @Override
            public void run() {
                try {
                    startLatch.await();
                    this.object = initializer.get();
                }
                catch (InterruptedException iex) {
                }
                catch (ConcurrentException cex) {
                    this.object = cex;
                }
            }
        }
        GetThread[] threads = new GetThread[20];
        for (int i = 0; i < 20; ++i) {
            threads[i] = new GetThread();
            threads[i].start();
        }
        startLatch.countDown();
        for (GetThread t : threads) {
            t.join();
        }
        Object managedObject = initializer.get();
        for (GetThread t : threads) {
            Assert.assertEquals((String)"Wrong object", (Object)managedObject, (Object)t.object);
        }
    }

    protected abstract ConcurrentInitializer<Object> createInitializer();
}

