/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionUtilsTest
extends TestCase {
    private NestableException nested;
    private Throwable withCause;
    private Throwable withoutCause;
    private Throwable jdkNoCause;
    private ExceptionWithCause cyclicCause;

    public ExceptionUtilsTest(String name) {
        super(name);
    }

    public void setUp() {
        this.withoutCause = this.createExceptionWithoutCause();
        this.nested = new NestableException(this.withoutCause);
        this.withCause = new ExceptionWithCause(this.nested);
        this.jdkNoCause = new NullPointerException();
        ExceptionWithCause a = new ExceptionWithCause(null);
        ExceptionWithCause b = new ExceptionWithCause(a);
        a.setCause(b);
        this.cyclicCause = new ExceptionWithCause(a);
    }

    protected void tearDown() throws Exception {
        this.withoutCause = null;
        this.nested = null;
        this.withCause = null;
        this.jdkNoCause = null;
        this.cyclicCause = null;
    }

    private Throwable createExceptionWithoutCause() {
        try {
            throw new ExceptionWithoutCause();
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Throwable createExceptionWithCause() {
        try {
            try {
                throw new ExceptionWithCause(this.createExceptionWithoutCause());
            }
            catch (Throwable t) {
                throw new ExceptionWithCause(t);
            }
        }
        catch (Throwable t) {
            return t;
        }
    }

    public void testConstructor() {
        ExceptionUtilsTest.assertNotNull((Object)new ExceptionUtils());
        Constructor<?>[] cons = ExceptionUtils.class.getDeclaredConstructors();
        ExceptionUtilsTest.assertEquals((int)1, (int)cons.length);
        ExceptionUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        ExceptionUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(ExceptionUtils.class.getModifiers()));
        ExceptionUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(ExceptionUtils.class.getModifiers()));
    }

    public void testGetCause_Throwable() {
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause(null));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause));
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getCause((Throwable)this.nested));
        ExceptionUtilsTest.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.jdkNoCause));
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause));
        ExceptionUtilsTest.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)ExceptionUtils.getCause((Throwable)this.cyclicCause.getCause()));
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause.getCause(), (Object)ExceptionUtils.getCause((Throwable)((ExceptionWithCause)this.cyclicCause.getCause()).getCause()));
    }

    public void testGetCause_ThrowableArray() {
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause(null, null));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause(null, (String[])new String[0]));
        ExceptionUtilsTest.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, null));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[0]));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{null}));
        ExceptionUtilsTest.assertSame((Object)this.nested, (Object)ExceptionUtils.getCause((Throwable)this.withCause, (String[])new String[]{"getCause"}));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, null));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[0]));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{null}));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getCause"}));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getCause((Throwable)this.withoutCause, (String[])new String[]{"getTargetException"}));
    }

    public void testGetRootCause_Throwable() {
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getRootCause(null));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getRootCause((Throwable)this.withoutCause));
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.nested));
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)ExceptionUtils.getRootCause((Throwable)this.withCause));
        ExceptionUtilsTest.assertSame(null, (Object)ExceptionUtils.getRootCause((Throwable)this.jdkNoCause));
        ExceptionUtilsTest.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)ExceptionUtils.getRootCause((Throwable)this.cyclicCause));
    }

    public void testGetThrowableCount_Throwable() {
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.getThrowableCount(null));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)this.withoutCause));
        ExceptionUtilsTest.assertEquals((int)2, (int)ExceptionUtils.getThrowableCount((Throwable)this.nested));
        ExceptionUtilsTest.assertEquals((int)3, (int)ExceptionUtils.getThrowableCount((Throwable)this.withCause));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.getThrowableCount((Throwable)this.jdkNoCause));
        ExceptionUtilsTest.assertEquals((int)3, (int)ExceptionUtils.getThrowableCount((Throwable)this.cyclicCause));
    }

    public void testGetThrowables_Throwable_null() {
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.getThrowables(null).length);
    }

    public void testGetThrowables_Throwable_withoutCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withoutCause);
        ExceptionUtilsTest.assertEquals((int)1, (int)throwables.length);
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)throwables[0]);
    }

    public void testGetThrowables_Throwable_nested() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.nested);
        ExceptionUtilsTest.assertEquals((int)2, (int)throwables.length);
        ExceptionUtilsTest.assertSame((Object)this.nested, (Object)throwables[0]);
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)throwables[1]);
    }

    public void testGetThrowables_Throwable_withCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.withCause);
        ExceptionUtilsTest.assertEquals((int)3, (int)throwables.length);
        ExceptionUtilsTest.assertSame((Object)this.withCause, (Object)throwables[0]);
        ExceptionUtilsTest.assertSame((Object)this.nested, (Object)throwables[1]);
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, (Object)throwables[2]);
    }

    public void testGetThrowables_Throwable_jdkNoCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.jdkNoCause);
        ExceptionUtilsTest.assertEquals((int)1, (int)throwables.length);
        ExceptionUtilsTest.assertSame((Object)this.jdkNoCause, (Object)throwables[0]);
    }

    public void testGetThrowables_Throwable_recursiveCause() {
        Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)this.cyclicCause);
        ExceptionUtilsTest.assertEquals((int)3, (int)throwables.length);
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause, (Object)throwables[0]);
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause.getCause(), (Object)throwables[1]);
        ExceptionUtilsTest.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), (Object)throwables[2]);
    }

    public void testGetThrowableList_Throwable_null() {
        List throwables = ExceptionUtils.getThrowableList(null);
        ExceptionUtilsTest.assertEquals((int)0, (int)throwables.size());
    }

    public void testGetThrowableList_Throwable_withoutCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withoutCause);
        ExceptionUtilsTest.assertEquals((int)1, (int)throwables.size());
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, throwables.get(0));
    }

    public void testGetThrowableList_Throwable_nested() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.nested);
        ExceptionUtilsTest.assertEquals((int)2, (int)throwables.size());
        ExceptionUtilsTest.assertSame((Object)this.nested, throwables.get(0));
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, throwables.get(1));
    }

    public void testGetThrowableList_Throwable_withCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.withCause);
        ExceptionUtilsTest.assertEquals((int)3, (int)throwables.size());
        ExceptionUtilsTest.assertSame((Object)this.withCause, throwables.get(0));
        ExceptionUtilsTest.assertSame((Object)this.nested, throwables.get(1));
        ExceptionUtilsTest.assertSame((Object)this.withoutCause, throwables.get(2));
    }

    public void testGetThrowableList_Throwable_jdkNoCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.jdkNoCause);
        ExceptionUtilsTest.assertEquals((int)1, (int)throwables.size());
        ExceptionUtilsTest.assertSame((Object)this.jdkNoCause, throwables.get(0));
    }

    public void testGetThrowableList_Throwable_recursiveCause() {
        List throwables = ExceptionUtils.getThrowableList((Throwable)this.cyclicCause);
        ExceptionUtilsTest.assertEquals((int)3, (int)throwables.size());
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause, throwables.get(0));
        ExceptionUtilsTest.assertSame((Object)this.cyclicCause.getCause(), throwables.get(1));
        ExceptionUtilsTest.assertSame((Object)((ExceptionWithCause)this.cyclicCause.getCause()).getCause(), throwables.get(2));
    }

    public void testIndexOf_ThrowableClass() {
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)2, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class));
    }

    public void testIndexOf_ThrowableClassInt() {
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, null, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable(null, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, null, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, null));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)2, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfThrowable((Throwable)this.withCause, Exception.class, (int)0));
    }

    public void testIndexOfType_ThrowableClass() {
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class));
        ExceptionUtilsTest.assertEquals((int)2, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class));
    }

    public void testIndexOfType_ThrowableClassInt() {
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, null, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType(null, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, null));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withoutCause, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, null, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.nested, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.nested, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, null));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, NestableException.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)2, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithoutCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)-1));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)0));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)1));
        ExceptionUtilsTest.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, ExceptionWithCause.class, (int)9));
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.indexOfType((Throwable)this.withCause, Exception.class, (int)0));
    }

    public void testPrintRootCauseStackTrace_Throwable() throws Exception {
        ExceptionUtils.printRootCauseStackTrace(null);
    }

    public void testPrintRootCauseStackTrace_ThrowableStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintStream)new PrintStream(out));
        ExceptionUtilsTest.assertEquals((int)0, (int)out.toString().length());
        out = new ByteArrayOutputStream(1024);
        try {
            ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintStream)null);
            ExceptionUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        out = new ByteArrayOutputStream(1024);
        Throwable withCause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)withCause, (PrintStream)new PrintStream(out));
        String stackTrace = out.toString();
        ExceptionUtilsTest.assertTrue((stackTrace.indexOf(" [wrapped] ") != -1 ? 1 : 0) != 0);
        out = new ByteArrayOutputStream(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintStream)new PrintStream(out));
        stackTrace = out.toString();
        ExceptionUtilsTest.assertTrue((stackTrace.indexOf(" [wrapped] ") == -1 ? 1 : 0) != 0);
    }

    public void testPrintRootCauseStackTrace_ThrowableWriter() throws Exception {
        StringWriter writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)null);
        ExceptionUtils.printRootCauseStackTrace(null, (PrintWriter)new PrintWriter(writer));
        ExceptionUtilsTest.assertEquals((int)0, (int)writer.getBuffer().length());
        writer = new StringWriter(1024);
        try {
            ExceptionUtils.printRootCauseStackTrace((Throwable)this.withCause, (PrintWriter)null);
            ExceptionUtilsTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        writer = new StringWriter(1024);
        Throwable withCause = this.createExceptionWithCause();
        ExceptionUtils.printRootCauseStackTrace((Throwable)withCause, (PrintWriter)new PrintWriter(writer));
        String stackTrace = writer.toString();
        ExceptionUtilsTest.assertTrue((stackTrace.indexOf(" [wrapped] ") != -1 ? 1 : 0) != 0);
        writer = new StringWriter(1024);
        ExceptionUtils.printRootCauseStackTrace((Throwable)this.withoutCause, (PrintWriter)new PrintWriter(writer));
        stackTrace = writer.toString();
        ExceptionUtilsTest.assertTrue((stackTrace.indexOf(" [wrapped] ") == -1 ? 1 : 0) != 0);
    }

    public void testGetRootCauseStackTrace_Throwable() throws Exception {
        ExceptionUtilsTest.assertEquals((int)0, (int)ExceptionUtils.getRootCauseStackTrace(null).length);
        Throwable withCause = this.createExceptionWithCause();
        String[] stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)withCause);
        boolean match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        ExceptionUtilsTest.assertEquals((boolean)true, (boolean)match);
        stackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)this.withoutCause);
        match = false;
        for (String element : stackTrace) {
            if (!element.startsWith(" [wrapped] ")) continue;
            match = true;
            break;
        }
        ExceptionUtilsTest.assertEquals((boolean)false, (boolean)match);
    }

    public void testRemoveCommonFrames_ListList() throws Exception {
        try {
            ExceptionUtils.removeCommonFrames(null, null);
            ExceptionUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_getMessage_Throwable() {
        Exception th = null;
        ExceptionUtilsTest.assertEquals((String)"", (String)ExceptionUtils.getMessage(th));
        th = new IllegalArgumentException("Base");
        ExceptionUtilsTest.assertEquals((String)"IllegalArgumentException: Base", (String)ExceptionUtils.getMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        ExceptionUtilsTest.assertEquals((String)"ExceptionUtilsTest.ExceptionWithCause: Wrapper", (String)ExceptionUtils.getMessage((Throwable)th));
    }

    public void test_getRootCauseMessage_Throwable() {
        Exception th = null;
        ExceptionUtilsTest.assertEquals((String)"", (String)ExceptionUtils.getRootCauseMessage(th));
        th = new IllegalArgumentException("Base");
        ExceptionUtilsTest.assertEquals((String)"IllegalArgumentException: Base", (String)ExceptionUtils.getRootCauseMessage((Throwable)th));
        th = new ExceptionWithCause("Wrapper", th);
        ExceptionUtilsTest.assertEquals((String)"IllegalArgumentException: Base", (String)ExceptionUtils.getRootCauseMessage((Throwable)th));
    }

    private static class NestableException
    extends Exception {
        public NestableException() {
        }

        public NestableException(Throwable t) {
            super(t);
        }
    }

    private static class ExceptionWithoutCause
    extends Exception {
        private ExceptionWithoutCause() {
        }

        public void getTargetException() {
        }
    }

    private static class ExceptionWithCause
    extends Exception {
        private Throwable cause;

        public ExceptionWithCause(String str, Throwable cause) {
            super(str);
            this.setCause(cause);
        }

        public ExceptionWithCause(Throwable cause) {
            this.setCause(cause);
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }
    }
}

