/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class StrBuilderAppendInsertTest
extends TestCase {
    private static final String SEP = SystemUtils.LINE_SEPARATOR;
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    public StrBuilderAppendInsertTest(String name) {
        super(name);
    }

    public void testAppendNewLine() {
        StrBuilder sb = new StrBuilder("---");
        sb.appendNewLine().append("+++");
        StrBuilderAppendInsertTest.assertEquals((String)("---" + SEP + "+++"), (String)sb.toString());
        sb = new StrBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        StrBuilderAppendInsertTest.assertEquals((String)("---#" + SEP), (String)sb.toString());
    }

    public void testAppendWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.appendNull();
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb.append((Object)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULL", (String)sb.toString());
        sb.append(FOO);
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfoo", (String)sb.toString());
        sb.append((String)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfooNULL", (String)sb.toString());
        sb.append("");
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfooNULL", (String)sb.toString());
        sb.append("bar");
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfooNULLbar", (String)sb.toString());
        sb.append((StringBuffer)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfooNULLbarNULL", (String)sb.toString());
        sb.append(new StringBuffer("baz"));
        StrBuilderAppendInsertTest.assertEquals((String)"NULLNULLfooNULLbarNULLbaz", (String)sb.toString());
    }

    public void testAppend_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendNull();
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append((Object)null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append(FOO);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append((StringBuffer)null);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StringBuffer("baz"));
        StrBuilderAppendInsertTest.assertEquals((String)"foobaz", (String)sb.toString());
        sb.append(new StrBuilder("yes"));
        StrBuilderAppendInsertTest.assertEquals((String)"foobazyes", (String)sb.toString());
        sb.append((CharSequence)"Seq");
        StrBuilderAppendInsertTest.assertEquals((String)"foobazyesSeq", (String)sb.toString());
    }

    public void testAppend_String() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append("");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append("bar");
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_String_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append("foo", 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        try {
            sb.append("bar", -1, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append("bar", 3, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, -1);
            StrBuilderAppendInsertTest.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append("bar", 1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append("bar", -1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append("bar", 4, 0);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append("bar", 3, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append("abcbardef", 3, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
        sb.append((CharSequence)"abcbardef", 4, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarard", (String)sb.toString());
    }

    public void testAppend_StringBuffer() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"));
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StringBuffer(""));
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StringBuffer("bar"));
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_StringBuffer_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null, 0, 1);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        try {
            sb.append(new StringBuffer("bar"), -1, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 3, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, -1);
            StrBuilderAppendInsertTest.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), -1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StringBuffer("bar"), 4, 0);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StringBuffer("bar"), 3, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_StrBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"));
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StrBuilder(""));
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StrBuilder("bar"));
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_StrBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null, 0, 1);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"), 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        try {
            sb.append(new StrBuilder("bar"), -1, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 3, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, -1);
            StrBuilderAppendInsertTest.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), -1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new StrBuilder("bar"), 4, 0);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new StrBuilder("bar"), 3, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new StrBuilder("abcbardef"), 3, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_CharArray() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[0]);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append(new char[]{'f', 'o', 'o'});
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
    }

    public void testAppend_CharArray_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null, 0, 1);
        StrBuilderAppendInsertTest.assertEquals((String)"NULL", (String)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 3, 1);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, -1);
            StrBuilderAppendInsertTest.fail((String)"append(char[],, -1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, -1, 3);
            StrBuilderAppendInsertTest.fail((String)"append(char[], -1, 3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.append(new char[]{'b', 'a', 'r'}, 4, 0);
            StrBuilderAppendInsertTest.fail((String)"append(char[], 4, 0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobar", (String)sb.toString());
    }

    public void testAppend_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.append(true);
        StrBuilderAppendInsertTest.assertEquals((String)"true", (String)sb.toString());
        sb.append(false);
        StrBuilderAppendInsertTest.assertEquals((String)"truefalse", (String)sb.toString());
        sb.append('!');
        StrBuilderAppendInsertTest.assertEquals((String)"truefalse!", (String)sb.toString());
    }

    public void testAppend_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.append(0);
        StrBuilderAppendInsertTest.assertEquals((String)"0", (String)sb.toString());
        sb.append(1L);
        StrBuilderAppendInsertTest.assertEquals((String)"01", (String)sb.toString());
        sb.append(2.3f);
        StrBuilderAppendInsertTest.assertEquals((String)"012.3", (String)sb.toString());
        sb.append(4.5);
        StrBuilderAppendInsertTest.assertEquals((String)"012.34.5", (String)sb.toString());
    }

    public void testAppendln_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendln((Object)null);
        StrBuilderAppendInsertTest.assertEquals((String)("" + SEP), (String)sb.toString());
        sb.appendln(FOO);
        StrBuilderAppendInsertTest.assertEquals((String)(SEP + "foo" + SEP), (String)sb.toString());
        sb.appendln((Object)6);
        StrBuilderAppendInsertTest.assertEquals((String)(SEP + "foo" + SEP + "6" + SEP), (String)sb.toString());
    }

    public void testAppendln_String() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo");
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)2, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_String_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(String str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo", 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_StringBuffer() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(StringBuffer str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"));
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_StringBuffer_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(StringBuffer str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"), 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_StrBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(StrBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"));
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_StrBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(StrBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"), 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_CharArray() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(char[] str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray());
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_CharArray_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(){

            public StrBuilder append(char[] str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray(), 0, 3);
        StrBuilderAppendInsertTest.assertEquals((String)("foo" + SEP), (String)sb.toString());
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[0]);
        StrBuilderAppendInsertTest.assertEquals((int)1, (int)count[1]);
    }

    public void testAppendln_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(true);
        StrBuilderAppendInsertTest.assertEquals((String)("true" + SEP), (String)sb.toString());
        sb.clear();
        sb.appendln(false);
        StrBuilderAppendInsertTest.assertEquals((String)("false" + SEP), (String)sb.toString());
    }

    public void testAppendln_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(0);
        StrBuilderAppendInsertTest.assertEquals((String)("0" + SEP), (String)sb.toString());
        sb.clear();
        sb.appendln(1L);
        StrBuilderAppendInsertTest.assertEquals((String)("1" + SEP), (String)sb.toString());
        sb.clear();
        sb.appendln(2.3f);
        StrBuilderAppendInsertTest.assertEquals((String)("2.3" + SEP), (String)sb.toString());
        sb.clear();
        sb.appendln(4.5);
        StrBuilderAppendInsertTest.assertEquals((String)("4.5" + SEP), (String)sb.toString());
    }

    public void testAppendPadding() {
        StrBuilder sb = new StrBuilder();
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendPadding(-1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendPadding(0, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendPadding(1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo-", (String)sb.toString());
        sb.appendPadding(16, '-');
        StrBuilderAppendInsertTest.assertEquals((int)20, (int)sb.length());
        StrBuilderAppendInsertTest.assertEquals((String)"foo-----------------", (String)sb.toString());
    }

    public void testAppendFixedWidthPadLeft() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"o", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"oo", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"-foo", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        StrBuilderAppendInsertTest.assertEquals((int)10, (int)sb.length());
        StrBuilderAppendInsertTest.assertEquals((String)"-------foo", (String)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"-null", (String)sb.toString());
    }

    public void testAppendFixedWidthPadLeft_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"3", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"23", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"123", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"-123", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        StrBuilderAppendInsertTest.assertEquals((int)10, (int)sb.length());
        StrBuilderAppendInsertTest.assertEquals((String)"-------123", (String)sb.toString());
    }

    public void testAppendFixedWidthPadRight() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"f", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"fo", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"foo-", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        StrBuilderAppendInsertTest.assertEquals((int)10, (int)sb.length());
        StrBuilderAppendInsertTest.assertEquals((String)"foo-------", (String)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"null-", (String)sb.toString());
    }

    public void testLang299() {
        StrBuilder sb = new StrBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"f", (String)sb.toString());
    }

    public void testAppendFixedWidthPadRight_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"1", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"12", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"123", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        StrBuilderAppendInsertTest.assertEquals((String)"123-", (String)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        StrBuilderAppendInsertTest.assertEquals((int)10, (int)sb.length());
        StrBuilderAppendInsertTest.assertEquals((String)"123-------", (String)sb.toString());
    }

    public void testAppendAll_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Object[])null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll(new Object[0]);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll(new Object[]{"foo", "bar", "baz"});
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
    }

    public void testAppendAll_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterable)null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
    }

    public void testAppendAll_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterator)null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
    }

    public void testAppendWithSeparators_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[0], ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,bar,baz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,,baz", (String)sb.toString());
    }

    public void testAppendWithSeparators_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,bar,baz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,,baz", (String)sb.toString());
    }

    public void testAppendWithSeparators_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,bar,baz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,,baz", (String)sb.toString());
    }

    public void testAppendWithSeparatorsWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,null,baz", (String)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,null,baz", (String)sb.toString());
    }

    public void testAppendSeparator_String() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",");
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendSeparator(",");
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
    }

    public void testAppendSeparator_String_String() {
        StrBuilder sb = new StrBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.appendSeparator(",", null);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.appendSeparator(",", "order by ");
        StrBuilderAppendInsertTest.assertEquals((String)"order by ", (String)sb.toString());
        sb.appendSeparator(null, null);
        StrBuilderAppendInsertTest.assertEquals((String)"order by ", (String)sb.toString());
        sb.appendSeparator(null, "order by ");
        StrBuilderAppendInsertTest.assertEquals((String)"order by ", (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"order by foo", (String)sb.toString());
        sb.appendSeparator(",", "order by ");
        StrBuilderAppendInsertTest.assertEquals((String)"order by foo,", (String)sb.toString());
    }

    public void testAppendSeparator_char() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',');
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendSeparator(',');
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
    }

    public void testAppendSeparator_char_char() {
        StrBuilder sb = new StrBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        StrBuilderAppendInsertTest.assertEquals((String)String.valueOf(':'), (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)(String.valueOf(':') + "foo"), (String)sb.toString());
        sb.appendSeparator(',', ':');
        StrBuilderAppendInsertTest.assertEquals((String)(String.valueOf(':') + "foo" + ','), (String)sb.toString());
    }

    public void testAppendSeparator_String_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",", 0);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendSeparator(",", 1);
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
        sb.appendSeparator(",", -1);
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
    }

    public void testAppendSeparator_char_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',', 0);
        StrBuilderAppendInsertTest.assertEquals((String)"", (String)sb.toString());
        sb.append("foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foo", (String)sb.toString());
        sb.appendSeparator(',', 1);
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
        sb.appendSeparator(',', -1);
        StrBuilderAppendInsertTest.assertEquals((String)"foo,", (String)sb.toString());
    }

    public void testInsert() {
        StrBuilder sb = new StrBuilder();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, FOO);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            StrBuilderAppendInsertTest.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, (Object)null);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, FOO);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, "foo");
            StrBuilderAppendInsertTest.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            StrBuilderAppendInsertTest.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, "foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, new char[]{'f', 'o', 'o'});
            StrBuilderAppendInsertTest.fail((String)"insert(-1, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'f', 'o', 'o'});
            StrBuilderAppendInsertTest.fail((String)"insert(7, char[]) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, (char[])null);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, new char[0]);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, new char[]{'f', 'o', 'o'});
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
            StrBuilderAppendInsertTest.fail((String)"insert(7, char[], 3, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, (char[])null, 0, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, new char[0], 0, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3);
            StrBuilderAppendInsertTest.fail((String)"insert(0, char[], -1, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3);
            StrBuilderAppendInsertTest.fail((String)"insert(0, char[], 10, 3) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1);
            StrBuilderAppendInsertTest.fail((String)"insert(0, char[], 0, -1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10);
            StrBuilderAppendInsertTest.fail((String)"insert(0, char[], 0, 10) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        StrBuilderAppendInsertTest.assertEquals((String)"foobarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, true);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, true);
            StrBuilderAppendInsertTest.fail((String)"insert(7, boolean) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, true);
        StrBuilderAppendInsertTest.assertEquals((String)"truebarbaz", (String)sb.toString());
        sb.insert(0, false);
        StrBuilderAppendInsertTest.assertEquals((String)"falsetruebarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, '!');
            StrBuilderAppendInsertTest.fail((String)"insert(-1, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, '!');
            StrBuilderAppendInsertTest.fail((String)"insert(7, char) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, '!');
        StrBuilderAppendInsertTest.assertEquals((String)"!barbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, 0);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, 0);
            StrBuilderAppendInsertTest.fail((String)"insert(7, int) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, '0');
        StrBuilderAppendInsertTest.assertEquals((String)"0barbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, 1L);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, 1L);
            StrBuilderAppendInsertTest.fail((String)"insert(7, long) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, 1L);
        StrBuilderAppendInsertTest.assertEquals((String)"1barbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, 2.3f);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, 2.3f);
            StrBuilderAppendInsertTest.fail((String)"insert(7, float) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, 2.3f);
        StrBuilderAppendInsertTest.assertEquals((String)"2.3barbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, 4.5);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, 4.5);
            StrBuilderAppendInsertTest.fail((String)"insert(7, double) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, 4.5);
        StrBuilderAppendInsertTest.assertEquals((String)"4.5barbaz", (String)sb.toString());
    }

    public void testInsertWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, FOO);
            StrBuilderAppendInsertTest.fail((String)"insert(-1, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, FOO);
            StrBuilderAppendInsertTest.fail((String)"insert(7, Object) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.insert(0, (Object)null);
        StrBuilderAppendInsertTest.assertEquals((String)"nullbarbaz", (String)sb.toString());
        sb.insert(0, FOO);
        StrBuilderAppendInsertTest.assertEquals((String)"foonullbarbaz", (String)sb.toString());
        sb.clear();
        sb.append("barbaz");
        StrBuilderAppendInsertTest.assertEquals((String)"barbaz", (String)sb.toString());
        try {
            sb.insert(-1, "foo");
            StrBuilderAppendInsertTest.fail((String)"insert(-1, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.insert(7, "foo");
            StrBuilderAppendInsertTest.fail((String)"insert(7, String) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.insert(0, (String)null);
        StrBuilderAppendInsertTest.assertEquals((String)"nullbarbaz", (String)sb.toString());
        sb.insert(0, "foo");
        StrBuilderAppendInsertTest.assertEquals((String)"foonullbarbaz", (String)sb.toString());
        sb.insert(0, (char[])null);
        StrBuilderAppendInsertTest.assertEquals((String)"nullfoonullbarbaz", (String)sb.toString());
        sb.insert(0, (char[])null, 0, 0);
        StrBuilderAppendInsertTest.assertEquals((String)"nullnullfoonullbarbaz", (String)sb.toString());
    }
}

