/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Test;

public class PairTest {
    @Test
    public void testPairOf() throws Exception {
        Pair pair = Pair.of((Object)0, (Object)"foo");
        Assert.assertTrue((boolean)(pair instanceof ImmutablePair));
        Assert.assertEquals((long)0L, (long)((Integer)((ImmutablePair)pair).left).intValue());
        Assert.assertEquals((Object)"foo", (Object)((ImmutablePair)pair).right);
        Pair pair2 = Pair.of(null, (Object)"bar");
        Assert.assertTrue((boolean)(pair2 instanceof ImmutablePair));
        Assert.assertNull((Object)((ImmutablePair)pair2).left);
        Assert.assertEquals((Object)"bar", (Object)((ImmutablePair)pair2).right);
    }

    @Test
    public void testCompatibilityBetweenPairs() throws Exception {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        MutablePair pair2 = MutablePair.of((Object)0, (Object)"foo");
        Assert.assertEquals((Object)pair, (Object)pair2);
        Assert.assertEquals((long)pair.hashCode(), (long)pair2.hashCode());
        HashSet<ImmutablePair> set = new HashSet<ImmutablePair>();
        set.add(pair);
        Assert.assertTrue((boolean)set.contains(pair2));
        pair2.setValue((Object)"bar");
        Assert.assertFalse((boolean)pair.equals((Object)pair2));
        Assert.assertFalse((pair.hashCode() == pair2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testMapEntry() throws Exception {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        Assert.assertEquals((Object)pair, entry);
        Assert.assertEquals((long)pair.hashCode(), (long)((Object)entry).hashCode());
    }

    @Test
    public void testComparable1() throws Exception {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        Assert.assertEquals((Object)true, (Object)(pair1.compareTo(pair1) == 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair1.compareTo(pair2) < 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair2.compareTo(pair2) == 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair2.compareTo(pair1) > 0 ? 1 : 0));
    }

    @Test
    public void testComparable2() throws Exception {
        Pair pair1 = Pair.of((Object)"A", (Object)"C");
        Pair pair2 = Pair.of((Object)"A", (Object)"D");
        Assert.assertEquals((Object)true, (Object)(pair1.compareTo(pair1) == 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair1.compareTo(pair2) < 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair2.compareTo(pair2) == 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(pair2.compareTo(pair1) > 0 ? 1 : 0));
    }

    @Test
    public void testToString() throws Exception {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assert.assertEquals((Object)"(Key,Value)", (Object)pair.toString());
    }

    @Test
    public void testToStringCustom() throws Exception {
        Calendar date = Calendar.getInstance();
        date.set(2011, 3, 25);
        Pair pair = Pair.of((Object)"DOB", (Object)date);
        Assert.assertEquals((Object)"Test created on 04-25-2011", (Object)pair.toString("Test created on %2$tm-%2$td-%2$tY"));
    }

    @Test
    public void testFormattable_simple() throws Exception {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assert.assertEquals((Object)"(Key,Value)", (Object)String.format("%1$s", pair));
    }

    @Test
    public void testFormattable_padded() throws Exception {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assert.assertEquals((Object)"         (Key,Value)", (Object)String.format("%1$20s", pair));
    }
}

