/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class StringUtilsStartsEndsWithTest
extends TestCase {
    private static final String foo = "foo";
    private static final String bar = "bar";
    private static final String foobar = "foobar";
    private static final String FOO = "FOO";
    private static final String BAR = "BAR";
    private static final String FOOBAR = "FOOBAR";

    public StringUtilsStartsEndsWithTest(String name) {
        super(name);
    }

    public void testStartsWith() {
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWith(null, null)", (boolean)StringUtils.startsWith(null, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(FOOBAR, null)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(null, FOO)", (boolean)StringUtils.startsWith(null, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWith(FOOBAR, \"\")", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)""));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWith(foobar, foo)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWith(FOOBAR, FOO)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(foobar, FOO)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(FOOBAR, foo)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(foo, foobar)", (boolean)StringUtils.startsWith((CharSequence)foo, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(foo, foobar)", (boolean)StringUtils.startsWith((CharSequence)bar, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(foobar, bar)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)bar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(FOOBAR, BAR)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(foobar, BAR)", (boolean)StringUtils.startsWith((CharSequence)foobar, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWith(FOOBAR, bar)", (boolean)StringUtils.startsWith((CharSequence)FOOBAR, (CharSequence)bar));
    }

    public void testStartsWithIgnoreCase() {
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(null, null)", (boolean)StringUtils.startsWithIgnoreCase(null, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(FOOBAR, null)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(null, FOO)", (boolean)StringUtils.startsWithIgnoreCase(null, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(FOOBAR, \"\")", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(foobar, foo)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(FOOBAR, FOO)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(foobar, FOO)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"startsWithIgnoreCase(FOOBAR, foo)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(foobar, bar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(FOOBAR, BAR)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(foobar, BAR)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"startsWithIgnoreCase(FOOBAR, bar)", (boolean)StringUtils.startsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar));
    }

    public void testStartsWithAny() {
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])null));
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.startsWithAny(null, (CharSequence[])new CharSequence[]{"abc"}));
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])null));
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[0]));
        StringUtilsStartsEndsWithTest.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{"abc"}));
        StringUtilsStartsEndsWithTest.assertTrue((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abc"}));
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null, "xyz", "abcd"}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.startsWithAny(abcxyz, StringBuilder(xyz), StringBuffer(abc))", (boolean)StringUtils.startsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.startsWithAny( StrBuilder(abcxyz), StringBuilder(xyz), StringBuffer(abc))", (boolean)StringUtils.startsWithAny((CharSequence)new StrBuilder("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("xyz"), new StringBuffer("abc")}));
    }

    public void testEndsWith() {
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWith(null, null)", (boolean)StringUtils.endsWith(null, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(FOOBAR, null)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(null, FOO)", (boolean)StringUtils.endsWith(null, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWith(FOOBAR, \"\")", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)""));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(foobar, foo)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(FOOBAR, FOO)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(foobar, FOO)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(FOOBAR, foo)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(foo, foobar)", (boolean)StringUtils.endsWith((CharSequence)foo, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(foo, foobar)", (boolean)StringUtils.endsWith((CharSequence)bar, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWith(foobar, bar)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)bar));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWith(FOOBAR, BAR)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(foobar, BAR)", (boolean)StringUtils.endsWith((CharSequence)foobar, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWith(FOOBAR, bar)", (boolean)StringUtils.endsWith((CharSequence)FOOBAR, (CharSequence)bar));
    }

    public void testEndsWithIgnoreCase() {
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(null, null)", (boolean)StringUtils.endsWithIgnoreCase(null, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(FOOBAR, null)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)null));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(null, FOO)", (boolean)StringUtils.endsWithIgnoreCase(null, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(FOOBAR, \"\")", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)""));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(foobar, foo)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(FOOBAR, FOO)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(foobar, FOO)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)FOO));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(FOOBAR, foo)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)foo));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foo, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertFalse((String)"endsWithIgnoreCase(foo, foobar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)bar, (CharSequence)foobar));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(foobar, bar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)bar));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(FOOBAR, BAR)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(foobar, BAR)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)foobar, (CharSequence)BAR));
        StringUtilsStartsEndsWithTest.assertTrue((String)"endsWithIgnoreCase(FOOBAR, bar)", (boolean)StringUtils.endsWithIgnoreCase((CharSequence)FOOBAR, (CharSequence)bar));
        StringUtilsStartsEndsWithTest.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"abcdef", (CharSequence)"def"));
        StringUtilsStartsEndsWithTest.assertTrue((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"def"));
        StringUtilsStartsEndsWithTest.assertFalse((boolean)StringUtils.endsWithIgnoreCase((CharSequence)"ABCDEF", (CharSequence)"cde"));
    }

    public void testEndsWithAny() {
        StringUtilsStartsEndsWithTest.assertFalse((String)"StringUtils.endsWithAny(null, null)", (boolean)StringUtils.endsWithAny(null, (CharSequence[])new CharSequence[]{null}));
        StringUtilsStartsEndsWithTest.assertFalse((String)"StringUtils.endsWithAny(null, new String[] {abc})", (boolean)StringUtils.endsWithAny(null, (CharSequence[])new String[]{"abc"}));
        StringUtilsStartsEndsWithTest.assertFalse((String)"StringUtils.endsWithAny(abcxyz, null)", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{null}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {\"\"})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{""}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {xyz})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{"xyz"}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.endsWithAny(abcxyz, new String[] {null, xyz, abc})", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new String[]{null, "xyz", "abc"}));
        StringUtilsStartsEndsWithTest.assertFalse((String)"StringUtils.endsWithAny(defg, new String[] {null, xyz, abc})", (boolean)StringUtils.endsWithAny((CharSequence)"defg", (CharSequence[])new String[]{null, "xyz", "abc"}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.endsWithAny(abcxyz, StringBuilder(abc), StringBuffer(xyz))", (boolean)StringUtils.endsWithAny((CharSequence)"abcxyz", (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}));
        StringUtilsStartsEndsWithTest.assertTrue((String)"StringUtils.endsWithAny( StrBuilder(abcxyz), StringBuilder(abc), StringBuffer(xyz))", (boolean)StringUtils.endsWithAny((CharSequence)new StrBuilder("abcxyz"), (CharSequence[])new CharSequence[]{new StringBuilder("abc"), new StringBuffer("xyz")}));
    }
}

