/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.Assert;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionToStringBuilderConcurrencyTest {
    private static final int DATA_SIZE = 100000;
    private static final int REPEAT = 100;

    @Test
    @Ignore
    public void testLinkedList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new LinkedList()));
    }

    @Test
    @Ignore
    public void testArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new ArrayList()));
    }

    @Test
    @Ignore
    public void testCopyOnWriteArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new CopyOnWriteArrayList()));
    }

    private void testConcurrency(final CollectionHolder<List<Integer>> holder) throws InterruptedException, ExecutionException {
        final List list = (List)holder.collection;
        for (int i = 0; i < 100000; ++i) {
            list.add(i);
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        Callable<Integer> consumer = new Callable<Integer>(){

            @Override
            public Integer call() {
                for (int i = 0; i < 100; ++i) {
                    String s = ReflectionToStringBuilder.toString((Object)holder);
                    Assert.assertNotNull((Object)s);
                }
                return 100;
            }
        };
        Callable<Integer> producer = new Callable<Integer>(){

            @Override
            public Integer call() {
                for (int i = 0; i < 100000; ++i) {
                    list.remove(list.get(0));
                }
                return 100;
            }
        };
        ArrayList<Callable<Integer>> tasks = new ArrayList<Callable<Integer>>();
        tasks.add(consumer);
        tasks.add(producer);
        List futures = threadPool.invokeAll(tasks);
        for (Future future : futures) {
            Assert.assertEquals((int)100, (int)((Integer)future.get()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionHolder<T extends Collection<?>> {
        T collection;

        CollectionHolder(T collection) {
            this.collection = collection;
        }
    }
}

