/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExceptionContextTest<T extends ExceptionContext & Serializable>
extends TestCase {
    protected static final String TEST_MESSAGE_2 = "This is monotonous";
    protected static final String TEST_MESSAGE = "Test Message";
    protected T exceptionContext;

    protected void setUp() throws Exception {
        this.exceptionContext.addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new ObjectWithFaultyToString());
    }

    public void testAddContextValue() {
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        AbstractExceptionContextTest.assertTrue((message.indexOf(TEST_MESSAGE) >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("test1") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("test2") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("test Date") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("test Nbr") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("some value") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("5") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((this.exceptionContext.getFirstContextValue("test1") == null ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("some value"));
        AbstractExceptionContextTest.assertEquals((int)5, (int)this.exceptionContext.getContextLabels().size());
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test1"));
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Date"));
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Nbr"));
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        AbstractExceptionContextTest.assertEquals((int)5, (int)this.exceptionContext.getContextLabels().size());
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        AbstractExceptionContextTest.assertTrue((contextMessage.indexOf(TEST_MESSAGE) == -1 ? 1 : 0) != 0);
    }

    public void testSetContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        this.exceptionContext.setContextValue("test3", (Object)"3");
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        AbstractExceptionContextTest.assertTrue((message.indexOf(TEST_MESSAGE) >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("test Poorly written obj") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((message.indexOf("Crap") >= 0 ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((this.exceptionContext.getFirstContextValue("crap") == null ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((boolean)(this.exceptionContext.getFirstContextValue("test Poorly written obj") instanceof ObjectWithFaultyToString));
        AbstractExceptionContextTest.assertEquals((int)7, (int)this.exceptionContext.getContextEntries().size());
        AbstractExceptionContextTest.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Poorly written obj"));
        AbstractExceptionContextTest.assertTrue((!this.exceptionContext.getContextLabels().contains("crap") ? 1 : 0) != 0);
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"replacement");
        AbstractExceptionContextTest.assertEquals((int)7, (int)this.exceptionContext.getContextEntries().size());
        AbstractExceptionContextTest.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        this.exceptionContext.setContextValue("test2", (Object)"another");
        AbstractExceptionContextTest.assertEquals((int)6, (int)this.exceptionContext.getContextEntries().size());
        AbstractExceptionContextTest.assertEquals((int)6, (int)this.exceptionContext.getContextLabels().size());
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        AbstractExceptionContextTest.assertTrue((contextMessage.indexOf(TEST_MESSAGE) == -1 ? 1 : 0) != 0);
    }

    public void testGetFirstContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        AbstractExceptionContextTest.assertTrue((this.exceptionContext.getFirstContextValue("test1") == null ? 1 : 0) != 0);
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("some value"));
        AbstractExceptionContextTest.assertTrue((this.exceptionContext.getFirstContextValue("crap") == null ? 1 : 0) != 0);
        this.exceptionContext.setContextValue("test2", (Object)"another");
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("another"));
    }

    public void testGetContextValues() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        AbstractExceptionContextTest.assertEquals((Object)this.exceptionContext.getContextValues("test1"), Collections.singletonList(null));
        AbstractExceptionContextTest.assertEquals((Object)this.exceptionContext.getContextValues("test2"), Arrays.asList("some value", "different value"));
        this.exceptionContext.setContextValue("test2", (Object)"another");
        AbstractExceptionContextTest.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("another"));
    }

    public void testGetContextLabels() {
        AbstractExceptionContextTest.assertEquals((int)5, (int)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Set labels = this.exceptionContext.getContextLabels();
        AbstractExceptionContextTest.assertEquals((int)6, (int)this.exceptionContext.getContextEntries().size());
        AbstractExceptionContextTest.assertEquals((int)5, (int)labels.size());
        AbstractExceptionContextTest.assertTrue((boolean)labels.contains("test1"));
        AbstractExceptionContextTest.assertTrue((boolean)labels.contains("test2"));
        AbstractExceptionContextTest.assertTrue((boolean)labels.contains("test Date"));
        AbstractExceptionContextTest.assertTrue((boolean)labels.contains("test Nbr"));
    }

    public void testGetContextEntries() {
        AbstractExceptionContextTest.assertEquals((int)5, (int)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        List entries = this.exceptionContext.getContextEntries();
        AbstractExceptionContextTest.assertEquals((int)6, (int)entries.size());
        AbstractExceptionContextTest.assertEquals((String)"test1", (String)((String)((Pair)entries.get(0)).getKey()));
        AbstractExceptionContextTest.assertEquals((String)"test2", (String)((String)((Pair)entries.get(1)).getKey()));
        AbstractExceptionContextTest.assertEquals((String)"test Date", (String)((String)((Pair)entries.get(2)).getKey()));
        AbstractExceptionContextTest.assertEquals((String)"test Nbr", (String)((String)((Pair)entries.get(3)).getKey()));
        AbstractExceptionContextTest.assertEquals((String)"test Poorly written obj", (String)((String)((Pair)entries.get(4)).getKey()));
        AbstractExceptionContextTest.assertEquals((String)"test2", (String)((String)((Pair)entries.get(5)).getKey()));
    }

    public void testJavaSerialization() {
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"serializable replacement");
        ExceptionContext clone = (ExceptionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)this.exceptionContext)));
        AbstractExceptionContextTest.assertEquals((String)this.exceptionContext.getFormattedExceptionMessage(null), (String)clone.getFormattedExceptionMessage(null));
    }

    protected static class ObjectWithFaultyToString {
        protected ObjectWithFaultyToString() {
        }

        public String toString() {
            throw new RuntimeException("Crap");
        }
    }
}

