/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.text.StrLookup;

public class StrLookupTest
extends TestCase {
    public void testNoneLookup() {
        StrLookupTest.assertEquals(null, (String)StrLookup.noneLookup().lookup(null));
        StrLookupTest.assertEquals(null, (String)StrLookup.noneLookup().lookup(""));
        StrLookupTest.assertEquals(null, (String)StrLookup.noneLookup().lookup("any"));
    }

    public void testSystemProperiesLookup() {
        StrLookupTest.assertEquals((String)System.getProperty("os.name"), (String)StrLookup.systemPropertiesLookup().lookup("os.name"));
        StrLookupTest.assertEquals(null, (String)StrLookup.systemPropertiesLookup().lookup(""));
        StrLookupTest.assertEquals(null, (String)StrLookup.systemPropertiesLookup().lookup("other"));
        try {
            StrLookup.systemPropertiesLookup().lookup(null);
            StrLookupTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testMapLookup() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", "value");
        map.put("number", 2);
        StrLookupTest.assertEquals((String)"value", (String)StrLookup.mapLookup(map).lookup("key"));
        StrLookupTest.assertEquals((String)"2", (String)StrLookup.mapLookup(map).lookup("number"));
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup(null));
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup(""));
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup("other"));
    }

    public void testMapLookup_nullMap() {
        Map map = null;
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup(null));
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup(""));
        StrLookupTest.assertEquals(null, (String)StrLookup.mapLookup(map).lookup("any"));
    }
}

