/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrSubstitutor;

public class StrSubstitutorTest
extends TestCase {
    private Map<String, String> values;

    protected void setUp() throws Exception {
        super.setUp();
        this.values = new HashMap<String, String>();
        this.values.put("animal", "quick brown fox");
        this.values.put("target", "lazy dog");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.values = null;
    }

    public void testReplaceSimple() {
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    public void testReplaceSolo() {
        this.doTestReplace("quick brown fox", "${animal}", false);
    }

    public void testReplaceNoVariables() {
        this.doTestNoReplace("The balloon arrived.");
    }

    public void testReplaceNull() {
        this.doTestNoReplace(null);
    }

    public void testReplaceEmpty() {
        this.doTestNoReplace("");
    }

    public void testReplaceChangedMap() {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        this.values.put("target", "moon");
        StrSubstitutorTest.assertEquals((String)"The quick brown fox jumps over the moon.", (String)sub.replace("The ${animal} jumps over the ${target}."));
    }

    public void testReplaceUnknownKey() {
        this.doTestReplace("The ${person} jumps over the lazy dog.", "The ${person} jumps over the ${target}.", true);
    }

    public void testReplaceAdjacentAtStart() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        StrSubstitutorTest.assertEquals((String)"GBP12.50 charged", (String)sub.replace("${code}${amount} charged"));
    }

    public void testReplaceAdjacentAtEnd() {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        StrSubstitutorTest.assertEquals((String)"Amount is GBP12.50", (String)sub.replace("Amount is ${code}${amount}"));
    }

    public void testReplaceRecursive() {
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doTestReplace("The quick brown fox jumps over the lazy dog.", "The ${animal} jumps over the ${target}.", true);
    }

    public void testReplaceEscaping() {
        this.doTestReplace("The ${animal} jumps over the lazy dog.", "The $${animal} jumps over the ${target}.", true);
    }

    public void testReplaceSoloEscaping() {
        this.doTestReplace("${animal}", "$${animal}", false);
    }

    public void testReplaceComplexEscaping() {
        this.doTestReplace("The ${quick brown fox} jumps over the lazy dog.", "The $${${animal}} jumps over the ${target}.", true);
    }

    public void testReplaceNoPefixNoSuffix() {
        this.doTestReplace("The animal jumps over the lazy dog.", "The animal jumps over the ${target}.", true);
    }

    public void testReplaceIncompletePefix() {
        this.doTestReplace("The {animal} jumps over the lazy dog.", "The {animal} jumps over the ${target}.", true);
    }

    public void testReplacePrefixNoSuffix() {
        this.doTestReplace("The ${animal jumps over the ${target} lazy dog.", "The ${animal jumps over the ${target} ${target}.", true);
    }

    public void testReplaceNoPrefixSuffix() {
        this.doTestReplace("The animal} jumps over the lazy dog.", "The animal} jumps over the ${target}.", true);
    }

    public void testReplaceEmptyKeys() {
        this.doTestReplace("The ${} jumps over the lazy dog.", "The ${} jumps over the ${target}.", true);
    }

    public void testReplaceToIdentical() {
        this.values.put("animal", "$${${thing}}");
        this.values.put("thing", "animal");
        this.doTestReplace("The ${animal} jumps.", "The ${animal} jumps.", true);
    }

    public void testCyclicReplacement() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("animal", "${critter}");
        map.put("target", "${pet}");
        map.put("pet", "${petCharacteristic} dog");
        map.put("petCharacteristic", "lazy");
        map.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        map.put("critterSpeed", "quick");
        map.put("critterColor", "brown");
        map.put("critterType", "${animal}");
        StrSubstitutor sub = new StrSubstitutor(map);
        try {
            sub.replace("The ${animal} jumps over the ${target}.");
            StrSubstitutorTest.fail((String)"Cyclic replacement was not detected!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReplaceWeirdPattens() {
        this.doTestNoReplace("");
        this.doTestNoReplace("${}");
        this.doTestNoReplace("${ }");
        this.doTestNoReplace("${\t}");
        this.doTestNoReplace("${\n}");
        this.doTestNoReplace("${\b}");
        this.doTestNoReplace("${");
        this.doTestNoReplace("$}");
        this.doTestNoReplace("}");
        this.doTestNoReplace("${}$");
        this.doTestNoReplace("${${");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${$${}}");
        this.doTestNoReplace("${$$${}}");
        this.doTestNoReplace("${$$${$}}");
        this.doTestNoReplace("${${}}");
        this.doTestNoReplace("${${ }}");
    }

    public void testReplacePartialString_noReplace() {
        StrSubstitutor sub = new StrSubstitutor();
        StrSubstitutorTest.assertEquals((String)"${animal} jumps", (String)sub.replace("The ${animal} jumps over the ${target}.", 4, 15));
    }

    public void testReplaceInVariable() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        StrSubstitutorTest.assertEquals((String)"Wrong result (1)", (String)"The mouse jumps over the lazy dog.", (String)sub.replace("The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        StrSubstitutorTest.assertEquals((String)"Wrong result (2)", (String)"The fox jumps over the lazy dog.", (String)sub.replace("The ${animal.${species}} jumps over the ${target}."));
    }

    public void testReplaceInVariableDisabled() {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        StrSubstitutorTest.assertEquals((String)"Wrong result", (String)"The ${animal.${species}} jumps over the lazy dog.", (String)sub.replace("The ${animal.${species}} jumps over the ${target}."));
    }

    public void testReplaceInVariableRecursive() {
        this.values.put("animal.2", "brown fox");
        this.values.put("animal.1", "white mouse");
        this.values.put("color", "white");
        this.values.put("species.white", "1");
        this.values.put("species.brown", "2");
        StrSubstitutor sub = new StrSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        StrSubstitutorTest.assertEquals((String)"Wrong result", (String)"The white mouse jumps over the lazy dog.", (String)sub.replace("The ${animal.${species.${color}}} jumps over the ${target}."));
    }

    public void testResolveVariable() {
        final StrBuilder builder = new StrBuilder("Hi ${name}!");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map){

            protected String resolveVariable(String variableName, StrBuilder buf, int startPos, int endPos) {
                Assert.assertEquals((String)"name", (String)variableName);
                Assert.assertSame((Object)builder, (Object)buf);
                Assert.assertEquals((int)3, (int)startPos);
                Assert.assertEquals((int)10, (int)endPos);
                return "jakarta";
            }
        };
        sub.replaceIn(builder);
        StrSubstitutorTest.assertEquals((String)"Hi jakarta!", (String)builder.toString());
    }

    public void testConstructorNoArgs() {
        StrSubstitutor sub = new StrSubstitutor();
        StrSubstitutorTest.assertEquals((String)"Hi ${name}", (String)sub.replace("Hi ${name}"));
    }

    public void testConstructorMapPrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">");
        StrSubstitutorTest.assertEquals((String)"Hi < commons", (String)sub.replace("Hi $< <name>"));
    }

    public void testConstructorMapFull() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutor sub = new StrSubstitutor(map, "<", ">", '!');
        StrSubstitutorTest.assertEquals((String)"Hi < commons", (String)sub.replace("Hi !< <name>"));
    }

    public void testGetSetEscape() {
        StrSubstitutor sub = new StrSubstitutor();
        StrSubstitutorTest.assertEquals((char)'$', (char)sub.getEscapeChar());
        sub.setEscapeChar('<');
        StrSubstitutorTest.assertEquals((char)'<', (char)sub.getEscapeChar());
    }

    public void testGetSetPrefix() {
        StrSubstitutor sub = new StrSubstitutor();
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        sub.setVariablePrefix('<');
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.CharMatcher));
        sub.setVariablePrefix("<<");
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        try {
            sub.setVariablePrefix((String)null);
            StrSubstitutorTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariablePrefixMatcher() instanceof StrMatcher.StringMatcher));
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariablePrefixMatcher(matcher);
        StrSubstitutorTest.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
        try {
            sub.setVariablePrefixMatcher((StrMatcher)null);
            StrSubstitutorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StrSubstitutorTest.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
    }

    public void testGetSetSuffix() {
        StrSubstitutor sub = new StrSubstitutor();
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        sub.setVariableSuffix('<');
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.CharMatcher));
        sub.setVariableSuffix("<<");
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        try {
            sub.setVariableSuffix((String)null);
            StrSubstitutorTest.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)(sub.getVariableSuffixMatcher() instanceof StrMatcher.StringMatcher));
        StrMatcher matcher = StrMatcher.commaMatcher();
        sub.setVariableSuffixMatcher(matcher);
        StrSubstitutorTest.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
        try {
            sub.setVariableSuffixMatcher((StrMatcher)null);
            StrSubstitutorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StrSubstitutorTest.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
    }

    public void testStaticReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutorTest.assertEquals((String)"Hi commons!", (String)StrSubstitutor.replace((Object)"Hi ${name}!", map));
    }

    public void testStaticReplacePrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StrSubstitutorTest.assertEquals((String)"Hi commons!", (String)StrSubstitutor.replace((Object)"Hi <name>!", map, (String)"<", (String)">"));
    }

    public void testStaticReplaceSystemProperties() {
        StrBuilder buf = new StrBuilder();
        buf.append("Hi ").append(System.getProperty("user.name"));
        buf.append(", you are working with ");
        buf.append(System.getProperty("os.name"));
        buf.append(", your home directory is ");
        buf.append(System.getProperty("user.home")).append('.');
        StrSubstitutorTest.assertEquals((String)buf.toString(), (String)StrSubstitutor.replaceSystemProperties((Object)"Hi ${user.name}, you are working with ${os.name}, your home directory is ${user.home}."));
    }

    public void testSubstitutetDefaultProperties() {
        String org = "${doesnotwork}";
        System.setProperty("doesnotwork", "It work's!");
        Properties props = new Properties(System.getProperties());
        StrSubstitutorTest.assertEquals((String)"It work's!", (String)StrSubstitutor.replace((Object)org, (Properties)props));
    }

    private void doTestReplace(String expectedResult, String replaceTemplate, boolean substring) {
        String expectedShortResult = expectedResult.substring(1, expectedResult.length() - 1);
        StrSubstitutor sub = new StrSubstitutor(this.values);
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)sub.replace(replaceTemplate));
        if (substring) {
            StrSubstitutorTest.assertEquals((String)expectedShortResult, (String)sub.replace(replaceTemplate, 1, replaceTemplate.length() - 2));
        }
        char[] chars = replaceTemplate.toCharArray();
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)sub.replace(chars));
        if (substring) {
            StrSubstitutorTest.assertEquals((String)expectedShortResult, (String)sub.replace(chars, 1, chars.length - 2));
        }
        StringBuffer buf = new StringBuffer(replaceTemplate);
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)sub.replace(buf));
        if (substring) {
            StrSubstitutorTest.assertEquals((String)expectedShortResult, (String)sub.replace(buf, 1, buf.length() - 2));
        }
        StrBuilder bld = new StrBuilder(replaceTemplate);
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)sub.replace(bld));
        if (substring) {
            StrSubstitutorTest.assertEquals((String)expectedShortResult, (String)sub.replace(bld, 1, bld.length() - 2));
        }
        MutableObject obj = new MutableObject((Object)replaceTemplate);
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)sub.replace((Object)obj));
        buf = new StringBuffer(replaceTemplate);
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)sub.replaceIn(buf));
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)buf.toString());
        if (substring) {
            buf = new StringBuffer(replaceTemplate);
            StrSubstitutorTest.assertEquals((boolean)true, (boolean)sub.replaceIn(buf, 1, buf.length() - 2));
            StrSubstitutorTest.assertEquals((String)expectedResult, (String)buf.toString());
        }
        bld = new StrBuilder(replaceTemplate);
        StrSubstitutorTest.assertEquals((boolean)true, (boolean)sub.replaceIn(bld));
        StrSubstitutorTest.assertEquals((String)expectedResult, (String)bld.toString());
        if (substring) {
            bld = new StrBuilder(replaceTemplate);
            StrSubstitutorTest.assertEquals((boolean)true, (boolean)sub.replaceIn(bld, 1, bld.length() - 2));
            StrSubstitutorTest.assertEquals((String)expectedResult, (String)bld.toString());
        }
    }

    private void doTestNoReplace(String replaceTemplate) {
        StrSubstitutor sub = new StrSubstitutor(this.values);
        if (replaceTemplate == null) {
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((String)null));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((String)null, 0, 100));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((char[])null));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((char[])null, 0, 100));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((StringBuffer)null));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((StringBuffer)null, 0, 100));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((StrBuilder)null));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((StrBuilder)null, 0, 100));
            StrSubstitutorTest.assertEquals(null, (String)sub.replace((Object)null));
            StrSubstitutorTest.assertEquals((boolean)false, (boolean)sub.replaceIn((StringBuffer)null));
            StrSubstitutorTest.assertEquals((boolean)false, (boolean)sub.replaceIn((StringBuffer)null, 0, 100));
            StrSubstitutorTest.assertEquals((boolean)false, (boolean)sub.replaceIn((StrBuilder)null));
            StrSubstitutorTest.assertEquals((boolean)false, (boolean)sub.replaceIn((StrBuilder)null, 0, 100));
        } else {
            StrSubstitutorTest.assertEquals((String)replaceTemplate, (String)sub.replace(replaceTemplate));
            StrBuilder bld = new StrBuilder(replaceTemplate);
            StrSubstitutorTest.assertEquals((boolean)false, (boolean)sub.replaceIn(bld));
            StrSubstitutorTest.assertEquals((String)replaceTemplate, (String)bld.toString());
        }
    }
}

