/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import junit.framework.TestCase;
import org.apache.commons.lang3.text.translate.NumericEntityUnescaper;

public class NumericEntityUnescaperTest
extends TestCase {
    public void testSupplementaryUnescaping() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        String input = "&#68642;";
        String expected = "\ud803\udc22";
        String result = neu.translate((CharSequence)input);
        NumericEntityUnescaperTest.assertEquals((String)"Failed to unescape numeric entities supplementary characters", (String)expected, (String)result);
    }

    public void testOutOfBounds() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        NumericEntityUnescaperTest.assertEquals((String)"Failed to ignore when last character is &", (String)"Test &", (String)neu.translate((CharSequence)"Test &"));
        NumericEntityUnescaperTest.assertEquals((String)"Failed to ignore when last character is &", (String)"Test &#", (String)neu.translate((CharSequence)"Test &#"));
        NumericEntityUnescaperTest.assertEquals((String)"Failed to ignore when last character is &", (String)"Test &#x", (String)neu.translate((CharSequence)"Test &#x"));
        NumericEntityUnescaperTest.assertEquals((String)"Failed to ignore when last character is &", (String)"Test &#X", (String)neu.translate((CharSequence)"Test &#X"));
    }

    public void testUnfinishedEntity() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.semiColonOptional});
        String input = "Test &#x30 not test";
        String expected = "Test 0 not test";
        String result = neu.translate((CharSequence)input);
        NumericEntityUnescaperTest.assertEquals((String)"Failed to support unfinished entities (i.e. missing semi-colon)", (String)expected, (String)result);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        expected = input = "Test &#x30 not test";
        result = neu.translate((CharSequence)input);
        NumericEntityUnescaperTest.assertEquals((String)"Failed to ignore unfinished entities (i.e. missing semi-colon)", (String)expected, (String)result);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.errorIfNoSemiColon});
        input = "Test &#x30 not test";
        try {
            result = neu.translate((CharSequence)input);
            NumericEntityUnescaperTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }
}

