/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class FastDateFormatTest
extends TestCase {
    public FastDateFormatTest(String name) {
        super(name);
    }

    public void test_getInstance() {
        FastDateFormat format1 = FastDateFormat.getInstance();
        FastDateFormat format2 = FastDateFormat.getInstance();
        FastDateFormatTest.assertSame((Object)format1, (Object)format2);
        FastDateFormatTest.assertEquals((String)new SimpleDateFormat().toPattern(), (String)format1.getPattern());
    }

    public void test_getInstance_String() {
        FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
        FastDateFormat format2 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        FastDateFormat format3 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
        FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
        FastDateFormatTest.assertSame((Object)format2, (Object)format3);
        FastDateFormatTest.assertEquals((String)"MM/DD/yyyy", (String)format1.getPattern());
        FastDateFormatTest.assertEquals((Object)TimeZone.getDefault(), (Object)format1.getTimeZone());
        FastDateFormatTest.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getInstance_String_TimeZone() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"));
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format4 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format5 = FastDateFormat.getInstance((String)"MM-DD-yyyy", (TimeZone)TimeZone.getDefault());
            FastDateFormat format6 = FastDateFormat.getInstance((String)"MM-DD-yyyy");
            FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
            FastDateFormatTest.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
            FastDateFormatTest.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
            FastDateFormatTest.assertSame((Object)format3, (Object)format4);
            FastDateFormatTest.assertTrue((format3 != format5 ? 1 : 0) != 0);
            FastDateFormatTest.assertTrue((format4 != format6 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getInstance_String_Locale() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy");
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
            FastDateFormatTest.assertSame((Object)format1, (Object)format3);
            FastDateFormatTest.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_changeDefault_Locale_DateInstance() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getDateInstance((int)0, (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getDateInstance((int)0);
            Locale.setDefault(Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getDateInstance((int)0);
            FastDateFormatTest.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
            FastDateFormatTest.assertSame((Object)Locale.US, (Object)format2.getLocale());
            FastDateFormatTest.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
            FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
            FastDateFormatTest.assertTrue((format2 != format3 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_changeDefault_Locale_DateTimeInstance() {
        Locale realDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            FastDateFormat format1 = FastDateFormat.getDateTimeInstance((int)0, (int)0, (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
            Locale.setDefault(Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getDateTimeInstance((int)0, (int)0);
            FastDateFormatTest.assertSame((Object)Locale.GERMANY, (Object)format1.getLocale());
            FastDateFormatTest.assertSame((Object)Locale.US, (Object)format2.getLocale());
            FastDateFormatTest.assertSame((Object)Locale.GERMANY, (Object)format3.getLocale());
            FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
            FastDateFormatTest.assertTrue((format2 != format3 ? 1 : 0) != 0);
        }
        finally {
            Locale.setDefault(realDefaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getInstance_String_TimeZone_Locale() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            FastDateFormat format1 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Locale)Locale.GERMANY);
            FastDateFormat format2 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (Locale)Locale.GERMANY);
            FastDateFormat format3 = FastDateFormat.getInstance((String)"MM/DD/yyyy", (TimeZone)TimeZone.getDefault(), (Locale)Locale.GERMANY);
            FastDateFormatTest.assertTrue((format1 != format2 ? 1 : 0) != 0);
            FastDateFormatTest.assertEquals((Object)TimeZone.getTimeZone("Atlantic/Reykjavik"), (Object)format1.getTimeZone());
            FastDateFormatTest.assertEquals((Object)TimeZone.getDefault(), (Object)format2.getTimeZone());
            FastDateFormatTest.assertEquals((Object)TimeZone.getDefault(), (Object)format3.getTimeZone());
            FastDateFormatTest.assertEquals((Object)Locale.GERMANY, (Object)format1.getLocale());
            FastDateFormatTest.assertEquals((Object)Locale.GERMANY, (Object)format2.getLocale());
            FastDateFormatTest.assertEquals((Object)Locale.GERMANY, (Object)format3.getLocale());
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            GregorianCalendar cal1 = new GregorianCalendar(2003, 0, 10, 15, 33, 20);
            GregorianCalendar cal2 = new GregorianCalendar(2003, 6, 10, 9, 0, 0);
            Date date1 = cal1.getTime();
            Date date2 = cal2.getTime();
            long millis1 = date1.getTime();
            long millis2 = date2.getTime();
            FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            FastDateFormatTest.assertEquals((String)sdf.format(date1), (String)fdf.format(date1));
            FastDateFormatTest.assertEquals((String)"2003-01-10T15:33:20", (String)fdf.format(date1));
            FastDateFormatTest.assertEquals((String)"2003-01-10T15:33:20", (String)fdf.format((Calendar)cal1));
            FastDateFormatTest.assertEquals((String)"2003-01-10T15:33:20", (String)fdf.format(millis1));
            FastDateFormatTest.assertEquals((String)"2003-07-10T09:00:00", (String)fdf.format(date2));
            FastDateFormatTest.assertEquals((String)"2003-07-10T09:00:00", (String)fdf.format((Calendar)cal2));
            FastDateFormatTest.assertEquals((String)"2003-07-10T09:00:00", (String)fdf.format(millis2));
            fdf = FastDateFormat.getInstance((String)"Z");
            FastDateFormatTest.assertEquals((String)"-0500", (String)fdf.format(date1));
            FastDateFormatTest.assertEquals((String)"-0500", (String)fdf.format((Calendar)cal1));
            FastDateFormatTest.assertEquals((String)"-0500", (String)fdf.format(millis1));
            FastDateFormatTest.assertEquals((String)"-0400", (String)fdf.format(date2));
            FastDateFormatTest.assertEquals((String)"-0400", (String)fdf.format((Calendar)cal2));
            FastDateFormatTest.assertEquals((String)"-0400", (String)fdf.format(millis2));
            fdf = FastDateFormat.getInstance((String)"ZZ");
            FastDateFormatTest.assertEquals((String)"-05:00", (String)fdf.format(date1));
            FastDateFormatTest.assertEquals((String)"-05:00", (String)fdf.format((Calendar)cal1));
            FastDateFormatTest.assertEquals((String)"-05:00", (String)fdf.format(millis1));
            FastDateFormatTest.assertEquals((String)"-04:00", (String)fdf.format(date2));
            FastDateFormatTest.assertEquals((String)"-04:00", (String)fdf.format((Calendar)cal2));
            FastDateFormatTest.assertEquals((String)"-04:00", (String)fdf.format(millis2));
            String pattern = "GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z";
            fdf = FastDateFormat.getInstance((String)pattern);
            sdf = new SimpleDateFormat(pattern);
            FastDateFormatTest.assertEquals((String)sdf.format(date1).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (String)fdf.format(date1));
            FastDateFormatTest.assertEquals((String)sdf.format(date2).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (String)fdf.format(date2));
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    public void testShortDateStyleWithLocales() {
        Locale usLocale = Locale.US;
        Locale swedishLocale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 1, 3);
        FastDateFormat fdf = FastDateFormat.getDateInstance((int)3, (Locale)usLocale);
        FastDateFormatTest.assertEquals((String)"2/3/04", (String)fdf.format(cal));
        fdf = FastDateFormat.getDateInstance((int)3, (Locale)swedishLocale);
        FastDateFormatTest.assertEquals((String)"2004-02-03", (String)fdf.format(cal));
    }

    public void testLowYearPadding() {
        Calendar cal = Calendar.getInstance();
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy/MM/DD");
        cal.set(1, 0, 1);
        FastDateFormatTest.assertEquals((String)"0001/01/01", (String)format.format(cal));
        cal.set(10, 0, 1);
        FastDateFormatTest.assertEquals((String)"0010/01/01", (String)format.format(cal));
        cal.set(100, 0, 1);
        FastDateFormatTest.assertEquals((String)"0100/01/01", (String)format.format(cal));
        cal.set(999, 0, 1);
        FastDateFormatTest.assertEquals((String)"0999/01/01", (String)format.format(cal));
    }

    public void testMilleniumBug() {
        Calendar cal = Calendar.getInstance();
        FastDateFormat format = FastDateFormat.getInstance((String)"dd.MM.yyyy");
        cal.set(1000, 0, 1);
        FastDateFormatTest.assertEquals((String)"01.01.1000", (String)format.format(cal));
    }

    public void testSimpleDate() {
        Calendar cal = Calendar.getInstance();
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy/MM/dd");
        cal.set(2004, 11, 31);
        FastDateFormatTest.assertEquals((String)"2004/12/31", (String)format.format(cal));
        cal.set(999, 11, 31);
        FastDateFormatTest.assertEquals((String)"0999/12/31", (String)format.format(cal));
        cal.set(1, 2, 2);
        FastDateFormatTest.assertEquals((String)"0001/03/02", (String)format.format(cal));
    }

    public void testLang303() {
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy/MM/dd");
        String output = format.format(cal);
        format = (FastDateFormat)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)format));
        FastDateFormatTest.assertEquals((String)output, (String)format.format(cal));
    }

    public void testLang538() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TimeZone.getTimeZone("GMT"));
        FastDateFormatTest.assertEquals((String)"dateTime", (String)"2009-10-16T16:42:16.000Z", (String)format.format(cal.getTime()));
        FastDateFormatTest.assertEquals((String)"dateTime", (String)"2009-10-16T08:42:16.000Z", (String)format.format((Calendar)cal));
    }

    public void testLang645() {
        Locale locale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 0, 1, 12, 0, 0);
        Date d = cal.getTime();
        FastDateFormat fdf = FastDateFormat.getInstance((String)"EEEE', week 'ww", (Locale)locale);
        FastDateFormatTest.assertEquals((String)"fredag, week 53", (String)fdf.format(d));
    }
}

