/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharEncoding;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharEncodingTest {
    private void assertSupportedEncoding(String name) {
        Assert.assertTrue((String)("Encoding should be supported: " + name), (boolean)CharEncoding.isSupported((String)name));
    }

    @Test
    public void testConstructor() {
        new CharEncoding();
    }

    @Test
    public void testMustBeSupportedJava1_3_1() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-16");
            this.assertSupportedEncoding("UTF-16BE");
            this.assertSupportedEncoding("UTF-16LE");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.3 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF-8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"ASCII"));
    }

    @Test
    public void testNotSupported() {
        Assert.assertFalse((boolean)CharEncoding.isSupported(null));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)""));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)" "));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"\t\r\n"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"DOESNOTEXIST"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"this is not a valid encoding name"));
    }

    @Test
    public void testWorksOnJava1_1_8() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.1 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    @Test
    public void testWorksOnJava1_2_2() {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2)) {
            this.assertSupportedEncoding("ISO-8859-1");
            this.assertSupportedEncoding("US-ASCII");
            this.assertSupportedEncoding("UTF-8");
        } else {
            this.warn("Java 1.2 tests not run since the current version is " + SystemUtils.JAVA_SPECIFICATION_VERSION);
        }
    }

    void warn(String msg) {
        System.err.println(msg);
    }
}

