/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocaleUtilsTest {
    private static final Locale LOCALE_EN = new Locale("en", "");
    private static final Locale LOCALE_EN_US = new Locale("en", "US");
    private static final Locale LOCALE_EN_US_ZZZZ = new Locale("en", "US", "ZZZZ");
    private static final Locale LOCALE_FR = new Locale("fr", "");
    private static final Locale LOCALE_FR_CA = new Locale("fr", "CA");
    private static final Locale LOCALE_QQ = new Locale("qq", "");
    private static final Locale LOCALE_QQ_ZZ = new Locale("qq", "ZZ");

    @Before
    public void setUp() throws Exception {
        LocaleUtils.isAvailableLocale((Locale)Locale.getDefault());
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new LocaleUtils());
        Constructor<?>[] cons = LocaleUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(LocaleUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(LocaleUtils.class.getModifiers()));
    }

    private void assertValidToLocale(String language) {
        Locale locale = LocaleUtils.toLocale((String)language);
        Assert.assertNotNull((String)"valid locale", (Object)locale);
        Assert.assertEquals((Object)language, (Object)locale.getLanguage());
        Assert.assertTrue((locale.getCountry() == null || locale.getCountry().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
    }

    private void assertValidToLocale(String localeString, String language, String country) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        Assert.assertNotNull((String)"valid locale", (Object)locale);
        Assert.assertEquals((Object)language, (Object)locale.getLanguage());
        Assert.assertEquals((Object)country, (Object)locale.getCountry());
        Assert.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
    }

    private void assertValidToLocale(String localeString, String language, String country, String variant) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        Assert.assertNotNull((String)"valid locale", (Object)locale);
        Assert.assertEquals((Object)language, (Object)locale.getLanguage());
        Assert.assertEquals((Object)country, (Object)locale.getCountry());
        Assert.assertEquals((Object)variant, (Object)locale.getVariant());
    }

    @Test
    public void testToLocale_1Part() {
        Assert.assertEquals(null, (Object)LocaleUtils.toLocale((String)null));
        this.assertValidToLocale("us");
        this.assertValidToLocale("fr");
        this.assertValidToLocale("de");
        this.assertValidToLocale("zh");
        this.assertValidToLocale("qq");
        try {
            LocaleUtils.toLocale((String)"Us");
            Assert.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"US");
            Assert.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uS");
            Assert.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"u#");
            Assert.fail((String)"Should fail if not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"u");
            Assert.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uuu");
            Assert.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uu_U");
            Assert.fail((String)"Must be 2 chars if less than 5");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToLocale_2Part() {
        this.assertValidToLocale("us_EN", "us", "EN");
        this.assertValidToLocale("us_ZH", "us", "ZH");
        try {
            LocaleUtils.toLocale((String)"us-EN");
            Assert.fail((String)"Should fail as not underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_En");
            Assert.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_en");
            Assert.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_eN");
            Assert.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uS_EN");
            Assert.fail((String)"Should fail first part not lowercase");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"us_E3");
            Assert.fail((String)"Should fail second part not uppercase");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToLocale_3Part() {
        this.assertValidToLocale("us_EN_A", "us", "EN", "A");
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4)) {
            this.assertValidToLocale("us_EN_a", "us", "EN", "a");
            this.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFsafdFDsdfF");
        } else {
            this.assertValidToLocale("us_EN_a", "us", "EN", "A");
            this.assertValidToLocale("us_EN_SFsafdFDsdfF", "us", "EN", "SFSAFDFDSDFF");
        }
        try {
            LocaleUtils.toLocale((String)"us_EN-a");
            Assert.fail((String)"Should fail as not underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"uu_UU_");
            Assert.fail((String)"Must be 3, 5 or 7+ in length");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertLocaleLookupList(Locale locale, Locale defaultLocale, Locale[] expected) {
        List localeList = defaultLocale == null ? LocaleUtils.localeLookupList((Locale)locale) : LocaleUtils.localeLookupList((Locale)locale, (Locale)defaultLocale);
        Assert.assertEquals((long)expected.length, (long)localeList.size());
        Assert.assertEquals(Arrays.asList(expected), (Object)localeList);
        LocaleUtilsTest.assertUnmodifiableCollection(localeList);
    }

    @Test
    public void testLocaleLookupList_Locale() {
        this.assertLocaleLookupList(null, null, new Locale[0]);
        this.assertLocaleLookupList(LOCALE_QQ, null, new Locale[]{LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN, null, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, null, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
    }

    @Test
    public void testLocaleLookupList_LocaleLocale() {
        this.assertLocaleLookupList(LOCALE_QQ, LOCALE_QQ, new Locale[]{LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN, LOCALE_EN, new Locale[]{LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_EN_US, new Locale[]{LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN_US, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, null, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_EN_US_ZZZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ});
        this.assertLocaleLookupList(LOCALE_EN_US_ZZZZ, LOCALE_QQ_ZZ, new Locale[]{LOCALE_EN_US_ZZZZ, LOCALE_EN_US, LOCALE_EN, LOCALE_QQ_ZZ});
        this.assertLocaleLookupList(LOCALE_FR_CA, LOCALE_EN, new Locale[]{LOCALE_FR_CA, LOCALE_FR, LOCALE_EN});
    }

    @Test
    public void testAvailableLocaleList() {
        List list = LocaleUtils.availableLocaleList();
        List list2 = LocaleUtils.availableLocaleList();
        Assert.assertNotNull((Object)list);
        Assert.assertSame((Object)list, (Object)list2);
        LocaleUtilsTest.assertUnmodifiableCollection(list);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        Assert.assertEquals(jdkLocaleList, (Object)list);
    }

    @Test
    public void testAvailableLocaleSet() {
        Set set = LocaleUtils.availableLocaleSet();
        Set set2 = LocaleUtils.availableLocaleSet();
        Assert.assertNotNull((Object)set);
        Assert.assertSame((Object)set, (Object)set2);
        LocaleUtilsTest.assertUnmodifiableCollection(set);
        Locale[] jdkLocaleArray = Locale.getAvailableLocales();
        List<Locale> jdkLocaleList = Arrays.asList(jdkLocaleArray);
        HashSet<Locale> jdkLocaleSet = new HashSet<Locale>(jdkLocaleList);
        Assert.assertEquals(jdkLocaleSet, (Object)set);
    }

    @Test
    public void testIsAvailableLocale() {
        Set set = LocaleUtils.availableLocaleSet();
        Assert.assertEquals((Object)set.contains(LOCALE_EN), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN));
        Assert.assertEquals((Object)set.contains(LOCALE_EN_US), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US));
        Assert.assertEquals((Object)set.contains(LOCALE_EN_US_ZZZZ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_EN_US_ZZZZ));
        Assert.assertEquals((Object)set.contains(LOCALE_FR), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR));
        Assert.assertEquals((Object)set.contains(LOCALE_FR_CA), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_FR_CA));
        Assert.assertEquals((Object)set.contains(LOCALE_QQ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ));
        Assert.assertEquals((Object)set.contains(LOCALE_QQ_ZZ), (Object)LocaleUtils.isAvailableLocale((Locale)LOCALE_QQ_ZZ));
    }

    private void assertLanguageByCountry(String country, String[] languages) {
        List list = LocaleUtils.languagesByCountry((String)country);
        List list2 = LocaleUtils.languagesByCountry((String)country);
        Assert.assertNotNull((Object)list);
        Assert.assertSame((Object)list, (Object)list2);
        for (String language : languages) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                Assert.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
                Assert.assertEquals((Object)country, (Object)locale.getCountry());
                if (!language.equals(locale.getLanguage())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Cound not find language: " + language + " for country: " + country));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    @Test
    public void testLanguagesByCountry() {
        this.assertLanguageByCountry(null, new String[0]);
        this.assertLanguageByCountry("GB", new String[]{"en"});
        this.assertLanguageByCountry("ZZ", new String[0]);
        this.assertLanguageByCountry("CH", new String[]{"fr", "de", "it"});
    }

    private void assertCountriesByLanguage(String language, String[] countries) {
        List list = LocaleUtils.countriesByLanguage((String)language);
        List list2 = LocaleUtils.countriesByLanguage((String)language);
        Assert.assertNotNull((Object)list);
        Assert.assertSame((Object)list, (Object)list2);
        for (String countrie : countries) {
            Iterator iterator = list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                Assert.assertTrue((locale.getVariant() == null || locale.getVariant().isEmpty() ? 1 : 0) != 0);
                Assert.assertEquals((Object)language, (Object)locale.getLanguage());
                if (!countrie.equals(locale.getCountry())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Cound not find language: " + countrie + " for country: " + language));
        }
        LocaleUtilsTest.assertUnmodifiableCollection(list);
    }

    @Test
    public void testCountriesByLanguage() {
        this.assertCountriesByLanguage(null, new String[0]);
        this.assertCountriesByLanguage("de", new String[]{"DE", "CH", "AT", "LU"});
        this.assertCountriesByLanguage("zz", new String[0]);
        this.assertCountriesByLanguage("it", new String[]{"IT", "CH"});
    }

    private static void assertUnmodifiableCollection(Collection<?> coll) {
        try {
            coll.add(null);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testLang328() {
        this.assertValidToLocale("fr__P", "fr", "", "P");
        this.assertValidToLocale("fr__POSIX", "fr", "", "POSIX");
    }

    @Test
    public void testLang865() {
        this.assertValidToLocale("_GB", "", "GB", "");
        this.assertValidToLocale("_GB_P", "", "GB", "P");
        this.assertValidToLocale("_GB_POSIX", "", "GB", "POSIX");
        try {
            LocaleUtils.toLocale((String)"_G");
            Assert.fail((String)"Must be at least 3 chars if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_Gb");
            Assert.fail((String)"Must be uppercase if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_gB");
            Assert.fail((String)"Must be uppercase if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_1B");
            Assert.fail((String)"Must be letter if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_G1");
            Assert.fail((String)"Must be letter if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_GB_");
            Assert.fail((String)"Must be at least 5 chars if starts with underscore");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            LocaleUtils.toLocale((String)"_GBAP");
            Assert.fail((String)"Must have underscore after the country if starts with underscore and is at least 5 chars");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseAllLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        int failures = 0;
        for (Locale l : locales) {
            Locale loc;
            Locale locale = new Locale(l.getLanguage(), l.getCountry(), l.getVariant());
            if (!l.equals(locale)) continue;
            String str = l.toString();
            int suff = str.indexOf("_#");
            if (suff == -1) {
                suff = str.indexOf("#");
            }
            if (suff >= 0) {
                try {
                    LocaleUtils.toLocale((String)str);
                    System.out.println("Should not have parsed: " + str);
                    ++failures;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    str = str.substring(0, suff);
                }
            }
            if (l.equals(loc = LocaleUtils.toLocale((String)str))) continue;
            System.out.println("Failed to parse: " + str);
            ++failures;
        }
        if (failures > 0) {
            Assert.fail((String)("Failed " + failures + " test(s)"));
        }
    }
}

