/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableFloat;
import org.junit.Assert;
import org.junit.Test;

public class MutableFloatTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)new MutableFloat(1.0f).floatValue(), (float)1.0E-4f);
        Assert.assertEquals((float)2.0f, (float)new MutableFloat((Number)Float.valueOf(2.0f)).floatValue(), (float)1.0E-4f);
        Assert.assertEquals((float)3.0f, (float)new MutableFloat((Number)new MutableFloat(3.0f)).floatValue(), (float)1.0E-4f);
        Assert.assertEquals((float)2.0f, (float)new MutableFloat("2.0").floatValue(), (float)1.0E-4f);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorNull() {
        new MutableFloat((Number)null);
    }

    @Test
    public void testGetSet() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        Assert.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)new MutableFloat().getValue());
        mutNum.setValue(1.0f);
        Assert.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)mutNum.getValue());
        mutNum.setValue((Number)Float.valueOf(2.0f));
        Assert.assertEquals((float)2.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assert.assertEquals((Object)Float.valueOf(2.0f), (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableFloat(3.0f));
        Assert.assertEquals((float)3.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)mutNum.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testSetNull() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        mutNum.setValue(null);
    }

    @Test
    public void testNanInfinite() {
        MutableFloat mutNum = new MutableFloat(Float.NaN);
        Assert.assertTrue((boolean)mutNum.isNaN());
        mutNum = new MutableFloat(Float.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)mutNum.isInfinite());
        mutNum = new MutableFloat(Float.NEGATIVE_INFINITY);
        Assert.assertTrue((boolean)mutNum.isInfinite());
    }

    @Test
    public void testEquals() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumA.equals((Object)mutNumB));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumA));
        Assert.assertTrue((boolean)mutNumB.equals((Object)mutNumB));
        Assert.assertFalse((boolean)mutNumA.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumB.equals((Object)mutNumC));
        Assert.assertTrue((boolean)mutNumC.equals((Object)mutNumC));
        Assert.assertFalse((boolean)mutNumA.equals(null));
        Assert.assertFalse((boolean)mutNumA.equals((Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)mutNumA.equals((Object)"0"));
    }

    @Test
    public void testHashCode() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        Assert.assertTrue((mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((mutNumA.hashCode() == Float.valueOf(0.0f).hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        Assert.assertEquals((long)0L, (long)mutNum.compareTo(new MutableFloat(0.0f)));
        Assert.assertEquals((long)1L, (long)mutNum.compareTo(new MutableFloat(-1.0f)));
        Assert.assertEquals((long)-1L, (long)mutNum.compareTo(new MutableFloat(1.0f)));
    }

    @Test(expected=NullPointerException.class)
    public void testCompareToNull() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        mutNum.compareTo(null);
    }

    @Test
    public void testPrimitiveValues() {
        MutableFloat mutNum = new MutableFloat(1.7f);
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((double)1.7, (double)mutNum.doubleValue(), (double)1.0E-5);
        Assert.assertEquals((long)1L, (long)mutNum.byteValue());
        Assert.assertEquals((long)1L, (long)mutNum.shortValue());
        Assert.assertEquals((long)1L, (long)mutNum.intValue());
        Assert.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToFloat() {
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)new MutableFloat(0.0f).toFloat());
        Assert.assertEquals((Object)Float.valueOf(12.3f), (Object)new MutableFloat(12.3f).toFloat());
    }

    @Test
    public void testIncrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.increment();
        Assert.assertEquals((long)2L, (long)mutNum.intValue());
        Assert.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.decrement();
        Assert.assertEquals((long)0L, (long)mutNum.intValue());
        Assert.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add(1.1f);
        Assert.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    public void testAddValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add((Number)Float.valueOf(1.1f));
        Assert.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract(0.9f);
        Assert.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    public void testSubtractValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract((Number)Float.valueOf(0.9f));
        Assert.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"0.0", (Object)new MutableFloat(0.0f).toString());
        Assert.assertEquals((Object)"10.0", (Object)new MutableFloat(10.0f).toString());
        Assert.assertEquals((Object)"-123.0", (Object)new MutableFloat(-123.0f).toString());
    }
}

