/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.DatePrinter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FormatCache;
import org.junit.Assert;
import org.junit.Test;

public class FastDatePrinterTest {
    private static final String YYYY_MM_DD = "yyyy/MM/dd";
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");
    private static final Locale SWEDEN = new Locale("sv", "SE");

    DatePrinter getInstance(String format) {
        return this.getInstance(format, TimeZone.getDefault(), Locale.getDefault());
    }

    private DatePrinter getDateInstance(int dateStyle, Locale locale) {
        return this.getInstance(FormatCache.getPatternForStyle((Integer)dateStyle, null, (Locale)locale), TimeZone.getDefault(), Locale.getDefault());
    }

    private DatePrinter getInstance(String format, Locale locale) {
        return this.getInstance(format, TimeZone.getDefault(), locale);
    }

    private DatePrinter getInstance(String format, TimeZone timeZone) {
        return this.getInstance(format, timeZone, Locale.getDefault());
    }

    protected DatePrinter getInstance(String format, TimeZone timeZone, Locale locale) {
        return new FastDatePrinter(format, timeZone, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFormat() {
        Locale realDefaultLocale = Locale.getDefault();
        TimeZone realDefaultZone = TimeZone.getDefault();
        try {
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(NEW_YORK);
            GregorianCalendar cal1 = new GregorianCalendar(2003, 0, 10, 15, 33, 20);
            GregorianCalendar cal2 = new GregorianCalendar(2003, 6, 10, 9, 0, 0);
            Date date1 = cal1.getTime();
            Date date2 = cal2.getTime();
            long millis1 = date1.getTime();
            long millis2 = date2.getTime();
            DatePrinter fdf = this.getInstance("yyyy-MM-dd'T'HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Assert.assertEquals((Object)sdf.format(date1), (Object)fdf.format(date1));
            Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format(date1));
            Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format((Calendar)cal1));
            Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format(millis1));
            Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format(date2));
            Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format((Calendar)cal2));
            Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format(millis2));
            fdf = this.getInstance("Z");
            Assert.assertEquals((Object)"-0500", (Object)fdf.format(date1));
            Assert.assertEquals((Object)"-0500", (Object)fdf.format((Calendar)cal1));
            Assert.assertEquals((Object)"-0500", (Object)fdf.format(millis1));
            Assert.assertEquals((Object)"-0400", (Object)fdf.format(date2));
            Assert.assertEquals((Object)"-0400", (Object)fdf.format((Calendar)cal2));
            Assert.assertEquals((Object)"-0400", (Object)fdf.format(millis2));
            fdf = this.getInstance("ZZ");
            Assert.assertEquals((Object)"-05:00", (Object)fdf.format(date1));
            Assert.assertEquals((Object)"-05:00", (Object)fdf.format((Calendar)cal1));
            Assert.assertEquals((Object)"-05:00", (Object)fdf.format(millis1));
            Assert.assertEquals((Object)"-04:00", (Object)fdf.format(date2));
            Assert.assertEquals((Object)"-04:00", (Object)fdf.format((Calendar)cal2));
            Assert.assertEquals((Object)"-04:00", (Object)fdf.format(millis2));
            String pattern = "GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z";
            fdf = this.getInstance("GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z");
            sdf = new SimpleDateFormat("GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z");
            Assert.assertEquals((Object)sdf.format(date1).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (Object)fdf.format(date1));
            Assert.assertEquals((Object)sdf.format(date2).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (Object)fdf.format(date2));
        }
        finally {
            Locale.setDefault(realDefaultLocale);
            TimeZone.setDefault(realDefaultZone);
        }
    }

    @Test
    public void testShortDateStyleWithLocales() {
        Locale usLocale = Locale.US;
        Locale swedishLocale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 1, 3);
        DatePrinter fdf = this.getDateInstance(3, usLocale);
        Assert.assertEquals((Object)"2/3/04", (Object)fdf.format(cal));
        fdf = this.getDateInstance(3, swedishLocale);
        Assert.assertEquals((Object)"2004-02-03", (Object)fdf.format(cal));
    }

    @Test
    public void testLowYearPadding() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        cal.set(1, 0, 1);
        Assert.assertEquals((Object)"0001/01/01", (Object)format.format(cal));
        cal.set(10, 0, 1);
        Assert.assertEquals((Object)"0010/01/01", (Object)format.format(cal));
        cal.set(100, 0, 1);
        Assert.assertEquals((Object)"0100/01/01", (Object)format.format(cal));
        cal.set(999, 0, 1);
        Assert.assertEquals((Object)"0999/01/01", (Object)format.format(cal));
    }

    @Test
    public void testMilleniumBug() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance("dd.MM.yyyy");
        cal.set(1000, 0, 1);
        Assert.assertEquals((Object)"01.01.1000", (Object)format.format(cal));
    }

    @Test
    public void testSimpleDate() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        cal.set(2004, 11, 31);
        Assert.assertEquals((Object)"2004/12/31", (Object)format.format(cal));
        cal.set(999, 11, 31);
        Assert.assertEquals((Object)"0999/12/31", (Object)format.format(cal));
        cal.set(1, 2, 2);
        Assert.assertEquals((Object)"0001/03/02", (Object)format.format(cal));
    }

    @Test
    public void testLang303() {
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        String output = format.format(cal);
        format = (DatePrinter)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)format)));
        Assert.assertEquals((Object)output, (Object)format.format(cal));
    }

    @Test
    public void testLang538() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        DatePrinter format = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((String)"dateTime", (Object)"2009-10-16T16:42:16.000Z", (Object)format.format(cal.getTime()));
        Assert.assertEquals((String)"dateTime", (Object)"2009-10-16T08:42:16.000Z", (Object)format.format((Calendar)cal));
    }

    @Test
    public void testLang645() {
        Locale locale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 0, 1, 12, 0, 0);
        Date d = cal.getTime();
        DatePrinter fdf = this.getInstance("EEEE', week 'ww", locale);
        Assert.assertEquals((Object)"fredag, week 53", (Object)fdf.format(d));
    }

    @Test
    public void testEquals() {
        DatePrinter printer1 = this.getInstance(YYYY_MM_DD);
        DatePrinter printer2 = this.getInstance(YYYY_MM_DD);
        Assert.assertEquals((Object)printer1, (Object)printer2);
        Assert.assertEquals((long)printer1.hashCode(), (long)printer2.hashCode());
        Assert.assertFalse((boolean)printer1.equals(new Object()));
    }

    @Test
    public void testToStringContainsName() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD);
        Assert.assertTrue((boolean)printer.toString().startsWith("FastDate"));
    }

    @Test
    public void testPatternMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD);
        Assert.assertEquals((Object)YYYY_MM_DD, (Object)printer.getPattern());
    }

    @Test
    public void testLocaleMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD, SWEDEN);
        Assert.assertEquals((Object)SWEDEN, (Object)printer.getLocale());
    }

    @Test
    public void testTimeZoneMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD, NEW_YORK);
        Assert.assertEquals((Object)NEW_YORK, (Object)printer.getTimeZone());
    }

    @Test
    public void testCalendarTimezoneRespected() {
        String[] availableZones = TimeZone.getAvailableIDs();
        TimeZone currentZone = TimeZone.getDefault();
        TimeZone anotherZone = null;
        for (String zone : availableZones) {
            if (zone.equals(currentZone.getID())) continue;
            anotherZone = TimeZone.getTimeZone(zone);
        }
        Assert.assertNotNull((String)"Cannot find another timezone", anotherZone);
        String pattern = "h:mma z";
        Calendar cal = Calendar.getInstance(anotherZone);
        SimpleDateFormat sdf = new SimpleDateFormat("h:mma z");
        sdf.setTimeZone(anotherZone);
        String expectedValue = sdf.format(cal.getTime());
        String actualValue = FastDateFormat.getInstance((String)"h:mma z").format(cal);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }
}

