/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.CharSetUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharSetUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new CharSetUtils());
        Constructor<?>[] cons = CharSetUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(CharSetUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(CharSetUtils.class.getModifiers()));
    }

    @Test
    public void testSqueeze_StringString() {
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"helo", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"l-p"}));
        Assert.assertEquals((Object)"heloo", (Object)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"l"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"helloo", (String[])new String[]{"^l"}));
    }

    @Test
    public void testSqueeze_StringStringarray() {
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])null));
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])new String[0]));
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.squeeze(null, (String[])new String[]{"el"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])null));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[0]));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.squeeze((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])null));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[0]));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"helo", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"el"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.squeeze((String)"hello", (String[])new String[]{"e"}));
        Assert.assertEquals((Object)"fofof", (Object)CharSetUtils.squeeze((String)"fooffooff", (String[])new String[]{"of"}));
        Assert.assertEquals((Object)"fof", (Object)CharSetUtils.squeeze((String)"fooooff", (String[])new String[]{"fo"}));
    }

    @Test
    public void testContainsAny_StringString() {
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{null}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{""}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{null}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{""}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{"a-e"}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{null}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{""}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"l-p"}));
    }

    @Test
    public void testContainsAny_StringStringarray() {
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])null));
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[0]));
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{null}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny(null, (String[])new String[]{"a-e"}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])null));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[0]));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{null}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"", (String[])new String[]{"a-e"}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])null));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[0]));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{null}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"el"}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"x"}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"e-i"}));
        Assert.assertTrue((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{"a-z"}));
        Assert.assertFalse((boolean)CharSetUtils.containsAny((String)"hello", (String[])new String[]{""}));
    }

    @Test
    public void testCount_StringString() {
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])new String[]{null}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[]{null}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((long)1L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((long)3L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"l-p"}));
    }

    @Test
    public void testCount_StringStringarray() {
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])null));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])new String[0]));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])new String[]{null}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count(null, (String[])new String[]{"a-e"}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])null));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[0]));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[]{null}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])null));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[0]));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((long)1L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((long)3L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"el"}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"x"}));
        Assert.assertEquals((long)2L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"e-i"}));
        Assert.assertEquals((long)5L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{"a-z"}));
        Assert.assertEquals((long)0L, (long)CharSetUtils.count((String)"hello", (String[])new String[]{""}));
    }

    @Test
    public void testKeep_StringString() {
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"xyz"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"oleh"}));
        Assert.assertEquals((Object)"ell", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
    }

    @Test
    public void testKeep_StringStringarray() {
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])null));
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])new String[0]));
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.keep(null, (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])null));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[0]));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])null));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[0]));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"e", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"e", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"ell", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"el"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"elho"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"a-z"}));
        Assert.assertEquals((Object)"----", (Object)CharSetUtils.keep((String)"----", (String[])new String[]{"-"}));
        Assert.assertEquals((Object)"ll", (Object)CharSetUtils.keep((String)"hello", (String[])new String[]{"l"}));
    }

    @Test
    public void testDelete_StringString() {
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((Object)"hllo", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"he", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"l-p"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"z"}));
    }

    @Test
    public void testDelete_StringStringarray() {
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])null));
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])new String[0]));
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])new String[]{null}));
        Assert.assertEquals(null, (Object)CharSetUtils.delete(null, (String[])new String[]{"el"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])null));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[0]));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{null}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"", (String[])new String[]{"a-e"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])null));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[0]));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{null}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"xyz"}));
        Assert.assertEquals((Object)"ho", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"el"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"elho"}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((Object)"hello", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{""}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"a-z"}));
        Assert.assertEquals((Object)"", (Object)CharSetUtils.delete((String)"----", (String[])new String[]{"-"}));
        Assert.assertEquals((Object)"heo", (Object)CharSetUtils.delete((String)"hello", (String[])new String[]{"l"}));
    }
}

