/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.CharSequenceUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new CharSequenceUtils());
        Constructor<?>[] cons = CharSequenceUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(CharSequenceUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(CharSequenceUtils.class.getModifiers()));
    }

    @Test
    public void testSubSequence() {
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)-1));
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)0));
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)1));
        Assert.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)0));
        Assert.assertEquals((Object)"012", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)0));
        Assert.assertEquals((Object)"12", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)1));
        Assert.assertEquals((Object)"2", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)2));
        Assert.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)3));
        try {
            Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)-1));
            Assert.fail((String)("Expected " + IndexOutOfBoundsException.class.getName()));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)1));
            Assert.fail((String)("Expected " + IndexOutOfBoundsException.class.getName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

