/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsEqualsIndexOfTest {
    private static final String BAR = "bar";
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String CharUSuppCharHigh = "\udc00";
    private static final String CharUSuppCharLow = "\ud840";
    private static final String FOO = "foo";
    private static final String FOOBAR = "foobar";
    private static final String[] FOOBAR_SUB_ARRAY = new String[]{"ob", "ba"};

    @Test
    public void testContains_Char() {
        Assert.assertFalse((boolean)StringUtils.contains(null, (int)32));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", (int)32));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assert.assertFalse((boolean)StringUtils.contains(null, null));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)97));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)98));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (int)99));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (int)122));
    }

    @Test
    public void testContains_String() {
        Assert.assertFalse((boolean)StringUtils.contains(null, null));
        Assert.assertFalse((boolean)StringUtils.contains(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.contains(null, (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", null));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"b"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"c"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)"abc", (CharSequence)"z"));
    }

    @Test
    public void testContains_StringWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\ud840a", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc01\udc00a", (CharSequence)"a"));
    }

    @Test
    public void testContains_StringWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertFalse((boolean)StringUtils.contains((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testContainsAny_StringCharArray() {
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (char[])new char[]{'a', 'b'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[0]));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testContainsAny_StringCharArrayWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"abc\udc00xyz", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsAny_StringCharArrayWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"a\ud840\udc00\ud840\udc01", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00a\ud840\udc01", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01a", (char[])"a".toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsAny_StringString() {
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsAny(null, (CharSequence)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"", (CharSequence)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testContainsAny_StringWithBadSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharHigh, (CharSequence)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharUSuppCharLow, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharUSuppCharLow));
    }

    @Test
    public void testContainsAny_StringWithSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20000, (CharSequence)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsAny((CharSequence)CharU20001, (CharSequence)CharU20000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsIgnoreCase_LocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr"), Locale.getDefault()};
        String[][] tdata = new String[][]{{"i", "I"}, {"I", "i"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        String[][] fdata = new String[][]{{"\u00df", "SS"}};
        try {
            for (Locale locale : locales) {
                int j;
                Locale.setDefault(locale);
                for (j = 0; j < tdata.length; ++j) {
                    Assert.assertTrue((String)(Locale.getDefault() + ": " + j + " " + tdata[j][0] + " " + tdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)tdata[j][0], (CharSequence)tdata[j][1]));
                }
                for (j = 0; j < fdata.length; ++j) {
                    Assert.assertFalse((String)(Locale.getDefault() + ": " + j + " " + fdata[j][0] + " " + fdata[j][1]), (boolean)StringUtils.containsIgnoreCase((CharSequence)fdata[j][0], (CharSequence)fdata[j][1]));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    @Test
    public void testContainsIgnoreCase_StringString() {
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase(null, (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", null));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", null));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"a"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"A"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"abc", (CharSequence)"A"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"abc"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"abc"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"", (CharSequence)"ABC"));
        Assert.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)"a", (CharSequence)"ABC"));
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)"xabcz", (CharSequence)"ABC"));
    }

    @Test
    public void testContainsNone_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'.'};
        char[] chars3 = new char[]{'c', 'd'};
        char[] emptyChars = new char[]{};
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (char[])null));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])null));
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (char[])chars3));
    }

    @Test
    public void testContainsNone_CharArrayWithBadSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20001.indexOf(CharUSuppCharHigh));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharHigh.toCharArray()));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharUSuppCharLow.toCharArray()));
    }

    @Test
    public void testContainsNone_CharArrayWithSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (char[])CharU20000.toCharArray()));
    }

    @Test
    public void testContainsNone_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab.";
        String chars1 = "b";
        String chars2 = ".";
        String chars3 = "cd";
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (String)null));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)null));
        Assert.assertTrue((boolean)StringUtils.containsNone(null, (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"a", (String)"cd"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"b", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"b", (String)"cd"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"."));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)"ab.", (String)"cd"));
    }

    @Test
    public void testContainsNone_StringWithBadSupplementaryChars() {
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharHigh, (String)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharUSuppCharLow.indexOf(CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharUSuppCharLow, (String)CharU20001));
        Assert.assertEquals((long)-1L, (long)CharU20001.indexOf(CharUSuppCharHigh));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharHigh));
        Assert.assertEquals((long)0L, (long)CharU20001.indexOf(CharUSuppCharLow));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharUSuppCharLow));
    }

    @Test
    public void testContainsNone_StringWithSupplementaryChars() {
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assert.assertFalse((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20000));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001));
        Assert.assertEquals((long)0L, (long)CharU20000.indexOf(CharU20001.charAt(0)));
        Assert.assertEquals((long)-1L, (long)CharU20000.indexOf(CharU20001.charAt(1)));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20000, (String)CharU20001));
        Assert.assertTrue((boolean)StringUtils.containsNone((CharSequence)CharU20001, (String)CharU20000));
    }

    @Test
    public void testContainsOnly_CharArray() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        char[] chars1 = new char[]{'b'};
        char[] chars2 = new char[]{'a'};
        char[] chars3 = new char[]{'a', 'b'};
        char[] emptyChars = new char[]{};
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (char[])null));
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (char[])emptyChars));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])emptyChars));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars1));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (char[])chars3));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (char[])chars3));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars1));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars2));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (char[])chars3));
    }

    @Test
    public void testContainsOnly_String() {
        String str1 = "a";
        String str2 = "b";
        String str3 = "ab";
        String chars1 = "b";
        String chars2 = "a";
        String chars3 = "ab";
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (String)null));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"", (String)null));
        Assert.assertFalse((boolean)StringUtils.containsOnly(null, (String)""));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)""));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"b"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"a", (String)"ab"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"b", (String)"ab"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"b"));
        Assert.assertFalse((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"a"));
        Assert.assertTrue((boolean)StringUtils.containsOnly((CharSequence)"ab", (String)"ab"));
    }

    @Test
    public void testContainsWhitespace() {
        Assert.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)""));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" "));
        Assert.assertFalse((boolean)StringUtils.containsWhitespace((CharSequence)"a"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a "));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)" a"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"a\t"));
        Assert.assertTrue((boolean)StringUtils.containsWhitespace((CharSequence)"\n"));
    }

    @Test
    public void testCustomCharSequence() {
        Assert.assertThat((Object)new CustomCharSequence(FOO), (Matcher)IsNot.not((Object)FOO));
        Assert.assertThat((Object)FOO, (Matcher)IsNot.not((Object)new CustomCharSequence(FOO)));
        Assert.assertEquals((Object)new CustomCharSequence(FOO), (Object)new CustomCharSequence(FOO));
    }

    @Test
    public void testEquals() {
        String fooCs = FOO;
        String barCs = BAR;
        String foobarCs = FOOBAR;
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)fooCs));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new StringBuilder(FOO)));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new CustomCharSequence(FOO)));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)new CustomCharSequence(FOO), (CharSequence)fooCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)barCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)fooCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)foobarCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)foobarCs, (CharSequence)fooCs));
    }

    @Test
    public void testEqualsOnStrings() {
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)BAR));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)FOO));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOOBAR));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOOBAR, (CharSequence)FOO));
    }

    @Test
    public void testEqualsIgnoreCase() {
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase(null, null));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)BAR));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, null));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase(null, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)"abcd", (CharSequence)"abcd "));
    }

    @Test
    public void testIndexOf_char() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testIndexOf_charInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)0));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)3));
    }

    @Test
    public void testIndexOf_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b"));
    }

    @Test
    public void testIndexOf_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)5));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testIndexOfAny_StringCharArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAny_StringCharArrayWithSupplementaryChars() {
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAny_StringString() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"za"));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"by"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"ab", (String)"z"));
    }

    @Test
    public void testIndexOfAny_StringStringArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testIndexOfAny_StringStringWithSupplementaryChars() {
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20000));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20001));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArrayWithSupplementaryChars() {
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAnyBut_StringString() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testIndexOfAnyBut_StringStringWithSupplementaryChars() {
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testIndexOfIgnoreCase_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"", null));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
    }

    @Test
    public void testIndexOfIgnoreCase_StringInt() {
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)-1));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)1));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)3));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)4));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)5));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)5));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB", (int)1));
    }

    @Test
    public void testLastIndexOf_char() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testLastIndexOf_charInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)-1));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)2));
    }

    @Test
    public void testLastIndexOf_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)8L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"ab"));
    }

    @Test
    public void testLastIndexOf_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)8));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)3));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testLastIndexOfAny_StringStringArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assert.assertEquals((long)6L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testLastIndexOfIgnoreCase_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)8L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB"));
    }

    @Test
    public void testLastIndexOfIgnoreCase_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)8));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
    }

    @Test
    public void testLastOrdinalIndexOf() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastOrdinalIndexOf(null, (CharSequence)"*", (int)42));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"*", null, (int)42));
        Assert.assertEquals((long)0L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"", (CharSequence)"", (int)42));
        Assert.assertEquals((long)7L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)6L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)5L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assert.assertEquals((long)8L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assert.assertEquals((long)8L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
    }

    @Test
    public void testOrdinalIndexOf() {
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)2));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)2));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)5L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)3));
        Assert.assertEquals((long)3L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)4));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)5));
        Assert.assertEquals((long)5L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)6));
        Assert.assertEquals((long)6L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)7));
        Assert.assertEquals((long)7L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)8));
        Assert.assertEquals((long)8L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)10));
    }

    private static class CustomCharSequence
    implements CharSequence {
        private final CharSequence seq;

        public CustomCharSequence(CharSequence seq) {
            this.seq = seq;
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CustomCharSequence(this.seq.subSequence(start, end));
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CustomCharSequence)) {
                return false;
            }
            CustomCharSequence other = (CustomCharSequence)obj;
            return this.seq.equals(other.seq);
        }

        public int hashCode() {
            return this.seq.hashCode();
        }

        @Override
        public String toString() {
            return this.seq.toString();
        }
    }
}

