/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.commons.lang3.ClassNotFoundSerialization;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializationUtilsTest {
    static final String CLASS_NOT_FOUND_MESSAGE = "ClassNotFoundSerialization.readObject fake exception";
    protected static final String SERIALIZE_IO_EXCEPTION_MESSAGE = "Anonymous OutputStream I/O exception";
    private String iString;
    private Integer iInteger;
    private HashMap<Object, Object> iMap;

    @Before
    public void setUp() {
        this.iString = "foo";
        this.iInteger = 7;
        this.iMap = new HashMap();
        this.iMap.put("FOO", this.iString);
        this.iMap.put("BAR", this.iInteger);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new SerializationUtils());
        Constructor<?>[] cons = SerializationUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(SerializationUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(SerializationUtils.class.getModifiers()));
    }

    @Test
    public void testException() {
        Exception ex = new Exception();
        SerializationException serEx = new SerializationException();
        Assert.assertSame(null, (Object)serEx.getMessage());
        Assert.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException("Message");
        Assert.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assert.assertSame(null, (Object)serEx.getCause());
        serEx = new SerializationException((Throwable)ex);
        Assert.assertEquals((Object)"java.lang.Exception", (Object)serEx.getMessage());
        Assert.assertSame((Object)ex, (Object)serEx.getCause());
        serEx = new SerializationException("Message", (Throwable)ex);
        Assert.assertSame((Object)"Message", (Object)serEx.getMessage());
        Assert.assertSame((Object)ex, (Object)serEx.getCause());
    }

    @Test
    public void testSerializeStream() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assert.assertEquals((long)testBytes.length, (long)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            Assert.assertEquals((long)realBytes[i], (long)testBytes[i]);
        }
    }

    @Test
    public void testSerializeStreamUnserializable() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        }
        catch (SerializationException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSerializeStreamNullObj() throws Exception {
        ByteArrayOutputStream streamTest = new ByteArrayOutputStream();
        SerializationUtils.serialize(null, (OutputStream)streamTest);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] testBytes = streamTest.toByteArray();
        byte[] realBytes = streamReal.toByteArray();
        Assert.assertEquals((long)testBytes.length, (long)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            Assert.assertEquals((long)realBytes[i], (long)testBytes[i]);
        }
    }

    @Test
    public void testSerializeStreamObjNull() throws Exception {
        try {
            SerializationUtils.serialize(this.iMap, null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSerializeStreamNullNull() throws Exception {
        try {
            SerializationUtils.serialize(null, null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSerializeIOException() throws Exception {
        OutputStream streamTest = new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
                throw new IOException(SerializationUtilsTest.SERIALIZE_IO_EXCEPTION_MESSAGE);
            }
        };
        try {
            SerializationUtils.serialize(this.iMap, (OutputStream)streamTest);
        }
        catch (SerializationException e) {
            Assert.assertEquals((Object)"java.io.IOException: Anonymous OutputStream I/O exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testDeserializeStream() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assert.assertNotNull((Object)test);
        Assert.assertTrue((boolean)(test instanceof HashMap));
        Assert.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        Assert.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assert.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assert.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        Assert.assertEquals(this.iMap, (Object)testMap);
    }

    @Test(expected=ClassCastException.class)
    public void testDeserializeClassCastException() {
        String value = "Hello";
        byte[] serialized = SerializationUtils.serialize((Serializable)((Object)"Hello"));
        Assert.assertEquals((Object)"Hello", (Object)SerializationUtils.deserialize((byte[])serialized));
        Integer i = (Integer)SerializationUtils.deserialize((byte[])serialized);
    }

    @Test
    public void testDeserializeStreamOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        Object test = SerializationUtils.deserialize((InputStream)inTest);
        Assert.assertNull((Object)test);
    }

    @Test
    public void testDeserializeStreamNull() throws Exception {
        try {
            SerializationUtils.deserialize((InputStream)null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testDeserializeStreamBadStream() throws Exception {
        try {
            SerializationUtils.deserialize((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (SerializationException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testDeserializeStreamClassNotFound() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(new ClassNotFoundSerialization());
        oos.flush();
        oos.close();
        ByteArrayInputStream inTest = new ByteArrayInputStream(streamReal.toByteArray());
        try {
            Object test = SerializationUtils.deserialize((InputStream)inTest);
        }
        catch (SerializationException se) {
            Assert.assertEquals((Object)"java.lang.ClassNotFoundException: ClassNotFoundSerialization.readObject fake exception", (Object)se.getMessage());
        }
    }

    @Test
    public void testSerializeBytes() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(this.iMap);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        Assert.assertEquals((long)testBytes.length, (long)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            Assert.assertEquals((long)realBytes[i], (long)testBytes[i]);
        }
    }

    @Test
    public void testSerializeBytesUnserializable() throws Exception {
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.serialize(this.iMap);
        }
        catch (SerializationException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testSerializeBytesNull() throws Exception {
        byte[] testBytes = SerializationUtils.serialize(null);
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        byte[] realBytes = streamReal.toByteArray();
        Assert.assertEquals((long)testBytes.length, (long)realBytes.length);
        for (int i = 0; i < realBytes.length; ++i) {
            Assert.assertEquals((long)realBytes[i], (long)testBytes[i]);
        }
    }

    @Test
    public void testDeserializeBytes() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(this.iMap);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assert.assertNotNull((Object)test);
        Assert.assertTrue((boolean)(test instanceof HashMap));
        Assert.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        Assert.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assert.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assert.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        Assert.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    public void testDeserializeBytesOfNull() throws Exception {
        ByteArrayOutputStream streamReal = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(streamReal);
        oos.writeObject(null);
        oos.flush();
        oos.close();
        Object test = SerializationUtils.deserialize((byte[])streamReal.toByteArray());
        Assert.assertNull((Object)test);
    }

    @Test
    public void testDeserializeBytesNull() throws Exception {
        try {
            SerializationUtils.deserialize((byte[])null);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testDeserializeBytesBadStream() throws Exception {
        try {
            SerializationUtils.deserialize((byte[])new byte[0]);
        }
        catch (SerializationException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testClone() throws Exception {
        Serializable test = SerializationUtils.clone(this.iMap);
        Assert.assertNotNull((Object)test);
        Assert.assertTrue((boolean)(test instanceof HashMap));
        Assert.assertTrue((test != this.iMap ? 1 : 0) != 0);
        HashMap testMap = (HashMap)test;
        Assert.assertEquals((Object)this.iString, testMap.get("FOO"));
        Assert.assertTrue((this.iString != testMap.get("FOO") ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.iInteger, testMap.get("BAR"));
        Assert.assertTrue((this.iInteger != testMap.get("BAR") ? 1 : 0) != 0);
        Assert.assertEquals(this.iMap, (Object)testMap);
    }

    @Test
    public void testCloneNull() throws Exception {
        Serializable test = SerializationUtils.clone(null);
        Assert.assertNull((Object)test);
    }

    @Test
    public void testCloneUnserializable() throws Exception {
        try {
            this.iMap.put(new Object(), new Object());
            SerializationUtils.clone(this.iMap);
        }
        catch (SerializationException ex) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPrimitiveTypeClassSerialization() {
        Class[] primitiveTypes;
        for (Class primitiveType : primitiveTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE}) {
            Class clone = (Class)SerializationUtils.clone((Serializable)primitiveType);
            Assert.assertEquals((Object)primitiveType, (Object)clone);
        }
    }
}

