/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.junit.Assert;
import org.junit.Test;

public class ValidateTest {
    @Test
    public void testIsTrue1() {
        Validate.isTrue((boolean)true);
        try {
            Validate.isTrue((boolean)false);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated expression is false", (Object)ex.getMessage());
        }
    }

    @Test
    public void testIsTrue2() {
        Validate.isTrue((boolean)true, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
    }

    @Test
    public void testIsTrue3() {
        Validate.isTrue((boolean)true, (String)"MSG", (long)6L);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (long)6L);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
    }

    @Test
    public void testIsTrue4() {
        Validate.isTrue((boolean)true, (String)"MSG", (long)7L);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (long)7L);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
    }

    @Test
    public void testIsTrue5() {
        Validate.isTrue((boolean)true, (String)"MSG", (double)7.4);
        try {
            Validate.isTrue((boolean)false, (String)"MSG", (double)7.4);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNotNull1() {
        Validate.notNull((Object)new Object());
        try {
            Validate.notNull(null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notNull((Object)"Hi");
        Assert.assertSame((Object)"Hi", (Object)testStr);
    }

    @Test
    public void testNotNull2() {
        Validate.notNull((Object)new Object(), (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notNull(null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notNull((Object)"Hi", (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)"Hi", (Object)testStr);
    }

    @Test
    public void testNotEmptyArray1() {
        Validate.notEmpty((Object[])new Object[]{null});
        try {
            Validate.notEmpty((Object[])null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated array is empty", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty((Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated array is empty", (Object)ex.getMessage());
        }
        Object[] array = new String[]{"hi"};
        String[] test = (String[])Validate.notEmpty((Object[])array);
        Assert.assertSame((Object)array, (Object)test);
    }

    @Test
    public void testNotEmptyArray2() {
        Validate.notEmpty((Object[])new Object[]{null}, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notEmpty((Object[])null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty((Object[])new Object[0], (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        Object[] array = new String[]{"hi"};
        String[] test = (String[])Validate.notEmpty((Object[])array, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)array, (Object)test);
    }

    @Test
    public void testNotEmptyCollection1() {
        ArrayList<Integer> coll = new ArrayList<Integer>();
        try {
            Validate.notEmpty((Collection)null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated collection is empty", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty(coll);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated collection is empty", (Object)ex.getMessage());
        }
        coll.add(8);
        Validate.notEmpty(coll);
        Collection test = Validate.notEmpty(coll);
        Assert.assertSame(coll, (Object)test);
    }

    @Test
    public void testNotEmptyCollection2() {
        ArrayList<Integer> coll = new ArrayList<Integer>();
        try {
            Validate.notEmpty((Collection)null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty(coll, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        coll.add(8);
        Validate.notEmpty(coll, (String)"MSG", (Object[])new Object[0]);
        Collection test = Validate.notEmpty(coll, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame(coll, (Object)test);
    }

    @Test
    public void testNotEmptyMap1() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Validate.notEmpty((Map)null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated map is empty", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty(map);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated map is empty", (Object)ex.getMessage());
        }
        map.put("ll", 8);
        Validate.notEmpty(map);
        Map test = Validate.notEmpty(map);
        Assert.assertSame(map, (Object)test);
    }

    @Test
    public void testNotEmptyMap2() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            Validate.notEmpty((Map)null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty(map, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        map.put("ll", 8);
        Validate.notEmpty(map, (String)"MSG", (Object[])new Object[0]);
        Map test = Validate.notEmpty(map, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame(map, (Object)test);
    }

    @Test
    public void testNotEmptyString1() {
        Validate.notEmpty((CharSequence)"hjl");
        try {
            Validate.notEmpty((CharSequence)null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated character sequence is empty", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty((CharSequence)"");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated character sequence is empty", (Object)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notEmpty((CharSequence)"Hi");
        Assert.assertSame((Object)"Hi", (Object)testStr);
    }

    @Test
    public void testNotEmptyString2() {
        Validate.notEmpty((CharSequence)"a", (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.notEmpty((CharSequence)null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        try {
            Validate.notEmpty((CharSequence)"", (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        String str = "Hi";
        String testStr = (String)Validate.notEmpty((CharSequence)"Hi", (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)"Hi", (Object)testStr);
    }

    @Test
    public void testNotBlankNullStringShouldThrow() {
        CharSequence string = null;
        try {
            Validate.notBlank(string);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"The validated character sequence is blank", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankMsgNullStringShouldThrow() {
        CharSequence string = null;
        try {
            Validate.notBlank(string, (String)"Message", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"Message", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankEmptyStringShouldThrow() {
        String string = "";
        try {
            Validate.notBlank((CharSequence)"");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The validated character sequence is blank", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankBlankStringWithWhitespacesShouldThrow() {
        String string = "   ";
        try {
            Validate.notBlank((CharSequence)"   ");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The validated character sequence is blank", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankBlankStringWithNewlinesShouldThrow() {
        String string = " \n \t \r \n ";
        try {
            Validate.notBlank((CharSequence)" \n \t \r \n ");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The validated character sequence is blank", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankMsgBlankStringShouldThrow() {
        String string = " \n \t \r \n ";
        try {
            Validate.notBlank((CharSequence)" \n \t \r \n ", (String)"Message", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Message", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankMsgBlankStringWithWhitespacesShouldThrow() {
        String string = "   ";
        try {
            Validate.notBlank((CharSequence)"   ", (String)"Message", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Message", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankMsgEmptyStringShouldThrow() {
        String string = "";
        try {
            Validate.notBlank((CharSequence)"", (String)"Message", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Message", (Object)e.getMessage());
        }
    }

    @Test
    public void testNotBlankNotBlankStringShouldNotThrow() {
        String string = "abc";
        Validate.notBlank((CharSequence)"abc");
    }

    @Test
    public void testNotBlankNotBlankStringWithWhitespacesShouldNotThrow() {
        String string = "  abc   ";
        Validate.notBlank((CharSequence)"  abc   ");
    }

    @Test
    public void testNotBlankNotBlankStringWithNewlinesShouldNotThrow() {
        String string = " \n \t abc \r \n ";
        Validate.notBlank((CharSequence)" \n \t abc \r \n ");
    }

    @Test
    public void testNotBlankMsgNotBlankStringShouldNotThrow() {
        String string = "abc";
        Validate.notBlank((CharSequence)"abc", (String)"Message", (Object[])new Object[0]);
    }

    @Test
    public void testNotBlankMsgNotBlankStringWithWhitespacesShouldNotThrow() {
        String string = "  abc   ";
        Validate.notBlank((CharSequence)"  abc   ", (String)"Message", (Object[])new Object[0]);
    }

    @Test
    public void testNotBlankMsgNotBlankStringWithNewlinesShouldNotThrow() {
        String string = " \n \t abc \r \n ";
        Validate.notBlank((CharSequence)" \n \t abc \r \n ", (String)"Message", (Object[])new Object[0]);
    }

    @Test
    public void testNotBlankReturnValues1() {
        String str = "Hi";
        String test = (String)Validate.notBlank((CharSequence)"Hi");
        Assert.assertSame((Object)"Hi", (Object)test);
    }

    @Test
    public void testNotBlankReturnValues2() {
        String str = "Hi";
        String test = (String)Validate.notBlank((CharSequence)"Hi", (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)"Hi", (Object)test);
    }

    @Test
    public void testNoNullElementsArray1() {
        Object[] array = new String[]{"a", "b"};
        Validate.noNullElements((Object[])array);
        try {
            Validate.noNullElements((Object[])null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
        }
        array[1] = null;
        try {
            Validate.noNullElements((Object[])array);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated array contains null element at index: 1", (Object)ex.getMessage());
        }
        array = new String[]{"a", "b"};
        String[] test = (String[])Validate.noNullElements((Object[])array);
        Assert.assertSame((Object)array, (Object)test);
    }

    @Test
    public void testNoNullElementsArray2() {
        Object[] array = new String[]{"a", "b"};
        Validate.noNullElements((Object[])array, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.noNullElements((Object[])null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
        }
        array[1] = null;
        try {
            Validate.noNullElements((Object[])array, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        array = new String[]{"a", "b"};
        String[] test = (String[])Validate.noNullElements((Object[])array, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)array, (Object)test);
    }

    @Test
    public void testNoNullElementsCollection1() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("a");
        coll.add("b");
        Validate.noNullElements(coll);
        try {
            Validate.noNullElements((Iterable)null);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
        }
        coll.set(1, null);
        try {
            Validate.noNullElements(coll);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"The validated collection contains null element at index: 1", (Object)ex.getMessage());
        }
        coll.set(1, "b");
        List test = (List)Validate.noNullElements(coll);
        Assert.assertSame(coll, (Object)test);
    }

    @Test
    public void testNoNullElementsCollection2() {
        ArrayList<String> coll = new ArrayList<String>();
        coll.add("a");
        coll.add("b");
        Validate.noNullElements(coll, (String)"MSG", (Object[])new Object[0]);
        try {
            Validate.noNullElements((Iterable)null, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting NullPointerException");
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"The validated object is null", (Object)ex.getMessage());
        }
        coll.set(1, null);
        try {
            Validate.noNullElements(coll, (String)"MSG", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"MSG", (Object)ex.getMessage());
        }
        coll.set(1, "b");
        List test = (List)Validate.noNullElements(coll, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame(coll, (Object)test);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new Validate());
        Constructor<?>[] cons = Validate.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(Validate.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(Validate.class.getModifiers()));
    }

    @Test
    public void testValidIndex_withMessage_array() {
        Object[] array = new Object[2];
        Validate.validIndex((Object[])array, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex((Object[])array, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex((Object[])array, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex((Object[])array, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        Object[] strArray = new String[]{"Hi"};
        String[] test = (String[])Validate.noNullElements((Object[])strArray, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)strArray, (Object)test);
    }

    @Test
    public void testValidIndex_array() {
        Object[] array = new Object[2];
        Validate.validIndex((Object[])array, (int)0);
        Validate.validIndex((Object[])array, (int)1);
        try {
            Validate.validIndex((Object[])array, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated array index is invalid: -1", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex((Object[])array, (int)2);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated array index is invalid: 2", (Object)ex.getMessage());
        }
        Object[] strArray = new String[]{"Hi"};
        String[] test = (String[])Validate.noNullElements((Object[])strArray);
        Assert.assertSame((Object)strArray, (Object)test);
    }

    @Test
    public void testValidIndex_withMessage_collection() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Validate.validIndex(coll, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex(coll, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex(coll, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex(coll, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        List<String> strColl = Arrays.asList("Hi");
        List test = (List)Validate.validIndex(strColl, (int)0, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame(strColl, (Object)test);
    }

    @Test
    public void testValidIndex_collection() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Validate.validIndex(coll, (int)0);
        Validate.validIndex(coll, (int)1);
        try {
            Validate.validIndex(coll, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated collection index is invalid: -1", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex(coll, (int)2);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated collection index is invalid: 2", (Object)ex.getMessage());
        }
        List<String> strColl = Arrays.asList("Hi");
        List test = (List)Validate.validIndex(strColl, (int)0);
        Assert.assertSame(strColl, (Object)test);
    }

    @Test
    public void testValidIndex_withMessage_charSequence() {
        String str = "Hi";
        Validate.validIndex((CharSequence)str, (int)0, (String)"Broken: ", (Object[])new Object[0]);
        Validate.validIndex((CharSequence)str, (int)1, (String)"Broken: ", (Object[])new Object[0]);
        try {
            Validate.validIndex((CharSequence)str, (int)-1, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex((CharSequence)str, (int)2, (String)"Broken: ", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"Broken: ", (Object)ex.getMessage());
        }
        String input = "Hi";
        String test = (String)Validate.validIndex((CharSequence)"Hi", (int)0, (String)"Message", (Object[])new Object[0]);
        Assert.assertSame((Object)"Hi", (Object)test);
    }

    @Test
    public void testValidIndex_charSequence() {
        String str = "Hi";
        Validate.validIndex((CharSequence)str, (int)0);
        Validate.validIndex((CharSequence)str, (int)1);
        try {
            Validate.validIndex((CharSequence)str, (int)-1);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated character sequence index is invalid: -1", (Object)ex.getMessage());
        }
        try {
            Validate.validIndex((CharSequence)str, (int)2);
            Assert.fail((String)"Expecting IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertEquals((Object)"The validated character sequence index is invalid: 2", (Object)ex.getMessage());
        }
        String input = "Hi";
        String test = (String)Validate.validIndex((CharSequence)"Hi", (int)0);
        Assert.assertSame((Object)"Hi", (Object)test);
    }

    @Test
    public void testMatchesPattern() {
        String str = "hi";
        Validate.matchesPattern((CharSequence)str, (String)"[a-z]*");
        try {
            Validate.matchesPattern((CharSequence)str, (String)"[0-9]*");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The string hi does not match the pattern [0-9]*", (Object)e.getMessage());
        }
    }

    @Test
    public void testMatchesPattern_withMessage() {
        String str = "hi";
        Validate.matchesPattern((CharSequence)str, (String)"[a-z]*", (String)"Does not match", (Object[])new Object[0]);
        try {
            Validate.matchesPattern((CharSequence)str, (String)"[0-9]*", (String)"Does not match", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Does not match", (Object)e.getMessage());
        }
    }

    @Test
    public void testInclusiveBetween() {
        Validate.inclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"));
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1));
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(2));
        try {
            Validate.inclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6));
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The value 6 is not in the specified inclusive range of 0 to 5", (Object)e.getMessage());
        }
    }

    @Test
    public void testInclusiveBetween_withMessage() {
        Validate.inclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"), (String)"Error", (Object[])new Object[0]);
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1), (String)"Error", (Object[])new Object[0]);
        Validate.inclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(2), (String)"Error", (Object[])new Object[0]);
        try {
            Validate.inclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6), (String)"Error", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Error", (Object)e.getMessage());
        }
    }

    @Test
    public void testExclusiveBetween() {
        Validate.exclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"));
        Validate.exclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1));
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6));
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The value 6 is not in the specified exclusive range of 0 to 5", (Object)e.getMessage());
        }
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(5));
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The value 5 is not in the specified exclusive range of 0 to 5", (Object)e.getMessage());
        }
    }

    @Test
    public void testExclusiveBetween_withMessage() {
        Validate.exclusiveBetween((Object)"a", (Object)"c", (Comparable)((Object)"b"), (String)"Error", (Object[])new Object[0]);
        Validate.exclusiveBetween((Object)0, (Object)2, (Comparable)Integer.valueOf(1), (String)"Error", (Object[])new Object[0]);
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(6), (String)"Error", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Error", (Object)e.getMessage());
        }
        try {
            Validate.exclusiveBetween((Object)0, (Object)5, (Comparable)Integer.valueOf(5), (String)"Error", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Error", (Object)e.getMessage());
        }
    }

    @Test
    public void testIsInstanceOf() {
        Validate.isInstanceOf(String.class, (Object)"hi");
        Validate.isInstanceOf(Integer.class, (Object)1);
    }

    @Test
    public void testIsInstanceOfExceptionMessage() {
        try {
            Validate.isInstanceOf(List.class, (Object)"hi");
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Expected type: java.util.List, actual: java.lang.String", (Object)e.getMessage());
        }
    }

    @Test
    public void testIsInstanceOf_withMessage() {
        Validate.isInstanceOf(String.class, (Object)"hi", (String)"Error", (Object[])new Object[0]);
        Validate.isInstanceOf(Integer.class, (Object)1, (String)"Error", (Object[])new Object[0]);
        try {
            Validate.isInstanceOf(List.class, (Object)"hi", (String)"Error", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Error", (Object)e.getMessage());
        }
    }

    @Test
    public void testIsAssignable() {
        Validate.isAssignableFrom(CharSequence.class, String.class);
        Validate.isAssignableFrom(AbstractList.class, ArrayList.class);
    }

    @Test
    public void testIsAssignableExceptionMessage() {
        try {
            Validate.isAssignableFrom(List.class, String.class);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Cannot assign a java.lang.String to a java.util.List", (Object)e.getMessage());
        }
    }

    @Test
    public void testIsAssignable_withMessage() {
        Validate.isAssignableFrom(CharSequence.class, String.class, (String)"Error", (Object[])new Object[0]);
        Validate.isAssignableFrom(AbstractList.class, ArrayList.class, (String)"Error", (Object[])new Object[0]);
        try {
            Validate.isAssignableFrom(List.class, String.class, (String)"Error", (Object[])new Object[0]);
            Assert.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Error", (Object)e.getMessage());
        }
    }
}

