/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import org.apache.commons.lang3.text.StrMatcher;
import org.junit.Assert;
import org.junit.Test;

public class StrMatcherTest {
    private static final char[] BUFFER1 = "0,1\t2 3\n\r\f\u0000'\"".toCharArray();
    private static final char[] BUFFER2 = "abcdef".toCharArray();

    @Test
    public void testCommaMatcher() {
        StrMatcher matcher = StrMatcher.commaMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.commaMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 0));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 1));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 2));
    }

    @Test
    public void testTabMatcher() {
        StrMatcher matcher = StrMatcher.tabMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.tabMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 2));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 4));
    }

    @Test
    public void testSpaceMatcher() {
        StrMatcher matcher = StrMatcher.spaceMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.spaceMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 4));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 5));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 6));
    }

    @Test
    public void testSplitMatcher() {
        StrMatcher matcher = StrMatcher.splitMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.splitMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 2));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 4));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 5));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 6));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 7));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 8));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 9));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 10));
    }

    @Test
    public void testTrimMatcher() {
        StrMatcher matcher = StrMatcher.trimMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.trimMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 2));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 4));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 5));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 6));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 7));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 8));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 9));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 10));
    }

    @Test
    public void testSingleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.singleQuoteMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.singleQuoteMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 10));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 11));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testDoubleQuoteMatcher() {
        StrMatcher matcher = StrMatcher.doubleQuoteMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.doubleQuoteMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 11));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testQuoteMatcher() {
        StrMatcher matcher = StrMatcher.quoteMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.quoteMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 10));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 11));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testNoneMatcher() {
        StrMatcher matcher = StrMatcher.noneMatcher();
        Assert.assertSame((Object)matcher, (Object)StrMatcher.noneMatcher());
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 0));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 1));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 2));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 4));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 5));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 6));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 7));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 8));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 9));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 10));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 11));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER1, 12));
    }

    @Test
    public void testCharMatcher_char() {
        StrMatcher matcher = StrMatcher.charMatcher((char)'c');
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 0));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 1));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 2));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 4));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 5));
    }

    @Test
    public void testCharSetMatcher_String() {
        StrMatcher matcher = StrMatcher.charSetMatcher((String)"ace");
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 0));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 1));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 2));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 3));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 4));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 5));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)""));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((String)null));
        Assert.assertTrue((boolean)(StrMatcher.charSetMatcher((String)"a") instanceof StrMatcher.CharMatcher));
    }

    @Test
    public void testCharSetMatcher_charArray() {
        StrMatcher matcher = StrMatcher.charSetMatcher((char[])"ace".toCharArray());
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 0));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 1));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 2));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 3));
        Assert.assertEquals((long)1L, (long)matcher.isMatch(BUFFER2, 4));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 5));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])new char[0]));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.charSetMatcher((char[])null));
        Assert.assertTrue((boolean)(StrMatcher.charSetMatcher((char[])"a".toCharArray()) instanceof StrMatcher.CharMatcher));
    }

    @Test
    public void testStringMatcher_String() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 0));
        Assert.assertEquals((long)2L, (long)matcher.isMatch(BUFFER2, 1));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 2));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 4));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 5));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher((String)""));
        Assert.assertSame((Object)StrMatcher.noneMatcher(), (Object)StrMatcher.stringMatcher((String)null));
    }

    @Test
    public void testMatcherIndices() {
        StrMatcher matcher = StrMatcher.stringMatcher((String)"bc");
        Assert.assertEquals((long)2L, (long)matcher.isMatch(BUFFER2, 1, 1, BUFFER2.length));
        Assert.assertEquals((long)2L, (long)matcher.isMatch(BUFFER2, 1, 0, 3));
        Assert.assertEquals((long)0L, (long)matcher.isMatch(BUFFER2, 1, 0, 2));
    }
}

