/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.text.WordUtils;
import org.junit.Assert;
import org.junit.Test;

public class WordUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new WordUtils());
        Constructor<?>[] cons = WordUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(WordUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(WordUtils.class.getModifiers()));
    }

    @Test
    public void testWrap_StringInt() {
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1));
        String systemNewLine = System.getProperty("line.separator");
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here to jump to the jakarta website - http://jakarta.apache.org";
        expected = "Click here to jump" + systemNewLine + "to the jakarta" + systemNewLine + "website -" + systemNewLine + "http://jakarta.apache.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
        input = "Click here, http://jakarta.apache.org, to jump to the jakarta website";
        expected = "Click here," + systemNewLine + "http://jakarta.apache.org," + systemNewLine + "to jump to the" + systemNewLine + "jakarta website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20));
    }

    @Test
    public void testWrap_StringIntStringBoolean() {
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, null, (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)20, null, (boolean)false));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1, null, (boolean)true));
        Assert.assertEquals(null, (Object)WordUtils.wrap(null, (int)-1, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)true));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)20, null, (boolean)true));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)false));
        Assert.assertEquals((Object)"", (Object)WordUtils.wrap((String)"", (int)-1, null, (boolean)true));
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of<br />text that is going<br />to be wrapped after<br />20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)true));
        input = "Here is one line";
        expected = "Here\nis one\nline";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)6, (String)"\n", (boolean)false));
        expected = "Here\nis\none\nline";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)-1, (String)"\n", (boolean)false));
        String systemNewLine = System.getProperty("line.separator");
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, null, (boolean)true));
        input = " Here:  is  one  line  of  text  that  is  going  to  be  wrapped  after  20  columns.";
        expected = "Here:  is  one  line\nof  text  that  is \ngoing  to  be \nwrapped  after  20 \ncolumns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is\tone line of text that is going to be wrapped after 20 columns.";
        expected = "Here is\tone line of\ntext that is going\nto be wrapped after\n20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of\ttext that is going to be wrapped after 20 columns.";
        expected = "Here is one line\nof\ttext that is\ngoing to be wrapped\nafter 20 columns.";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here to jump to the jakarta website - http://jakarta.apache.org";
        expected = "Click here to jump\nto the jakarta\nwebsite -\nhttp://jakarta.apache.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here to jump\nto the jakarta\nwebsite -\nhttp://jakarta.apach\ne.org";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here, http://jakarta.apache.org, to jump to the jakarta website";
        expected = "Click here,\nhttp://jakarta.apache.org,\nto jump to the\njakarta website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here,\nhttp://jakarta.apach\ne.org, to jump to\nthe jakarta website";
        Assert.assertEquals((Object)expected, (Object)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
    }

    @Test
    public void testCapitalize_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalize(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalize((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"i am here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalize((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I Am HERE 123", (Object)WordUtils.capitalize((String)"i am HERE 123"));
        Assert.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.capitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalize(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalize((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"I", (char[])chars));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalize((String)"i", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalize((String)"i-am here+123", (char[])chars));
        Assert.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalize((String)"I Am+Here-123", (char[])chars));
        Assert.assertEquals((Object)"I+Am-HERE 123", (Object)WordUtils.capitalize((String)"i+am-HERE 123", (char[])chars));
        Assert.assertEquals((Object)"I-AM HERE+123", (Object)WordUtils.capitalize((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"I aM.Fine", (Object)WordUtils.capitalize((String)"i aM.fine", (char[])chars));
        Assert.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalize((String)"i am.fine", null));
    }

    @Test
    public void testCapitalizeFully_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalizeFully(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"i am HERE 123"));
        Assert.assertEquals((Object)"I Am Here 123", (Object)WordUtils.capitalizeFully((String)"I AM HERE 123"));
    }

    @Test
    public void testCapitalizeFullyWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.capitalizeFully(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.capitalizeFully((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.capitalizeFully((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"I", (char[])chars));
        Assert.assertEquals((Object)"I", (Object)WordUtils.capitalizeFully((String)"i", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"i-am here+123", (char[])chars));
        Assert.assertEquals((Object)"I Am+Here-123", (Object)WordUtils.capitalizeFully((String)"I Am+Here-123", (char[])chars));
        Assert.assertEquals((Object)"I+Am-Here 123", (Object)WordUtils.capitalizeFully((String)"i+am-HERE 123", (char[])chars));
        Assert.assertEquals((Object)"I-Am Here+123", (Object)WordUtils.capitalizeFully((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"I am.Fine", (Object)WordUtils.capitalizeFully((String)"i aM.fine", (char[])chars));
        Assert.assertEquals((Object)"I Am.fine", (Object)WordUtils.capitalizeFully((String)"i am.fine", null));
    }

    @Test
    public void testUncapitalize_String() {
        Assert.assertEquals(null, (Object)WordUtils.uncapitalize(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  "));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I"));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"i am here 123"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.uncapitalize((String)"I Am Here 123"));
        Assert.assertEquals((Object)"i am hERE 123", (Object)WordUtils.uncapitalize((String)"i am HERE 123"));
        Assert.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.uncapitalize((String)"I AM HERE 123"));
    }

    @Test
    public void testUncapitalizeWithDelimiters_String() {
        Assert.assertEquals(null, (Object)WordUtils.uncapitalize(null, null));
        Assert.assertEquals((Object)"", (Object)WordUtils.uncapitalize((String)"", (char[])new char[0]));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.uncapitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"I", (char[])chars));
        Assert.assertEquals((Object)"i", (Object)WordUtils.uncapitalize((String)"i", (char[])chars));
        Assert.assertEquals((Object)"i am-here+123", (Object)WordUtils.uncapitalize((String)"i am-here+123", (char[])chars));
        Assert.assertEquals((Object)"i+am here-123", (Object)WordUtils.uncapitalize((String)"I+Am Here-123", (char[])chars));
        Assert.assertEquals((Object)"i-am+hERE 123", (Object)WordUtils.uncapitalize((String)"i-am+HERE 123", (char[])chars));
        Assert.assertEquals((Object)"i aM-hERE+123", (Object)WordUtils.uncapitalize((String)"I AM-HERE+123", (char[])chars));
        chars = new char[]{'.'};
        Assert.assertEquals((Object)"i AM.fINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", (char[])chars));
        Assert.assertEquals((Object)"i aM.FINE", (Object)WordUtils.uncapitalize((String)"I AM.FINE", null));
    }

    @Test
    public void testInitials_String() {
        Assert.assertEquals(null, (Object)WordUtils.initials(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)""));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  "));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I"));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i"));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee"));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee"));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee"));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123"));
    }

    @Test
    public void testInitials_String_charArray() {
        char[] array = null;
        Assert.assertEquals(null, (Object)WordUtils.initials(null, array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", array));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", array));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", array));
        array = new char[]{};
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " ".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJ", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"BJ.L", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KO", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .'".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"I", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"S", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)"BJL", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"KOM", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"iah1", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
        array = "SIJo1".toCharArray();
        Assert.assertEquals(null, (Object)WordUtils.initials(null, (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"", (char[])array));
        Assert.assertEquals((Object)" ", (Object)WordUtils.initials((String)"  ", (char[])array));
        Assert.assertEquals((Object)"", (Object)WordUtils.initials((String)"I", (char[])array));
        Assert.assertEquals((Object)"i", (Object)WordUtils.initials((String)"i", (char[])array));
        Assert.assertEquals((Object)"C", (Object)WordUtils.initials((String)"SJC", (char[])array));
        Assert.assertEquals((Object)"Bh", (Object)WordUtils.initials((String)"Ben John Lee", (char[])array));
        Assert.assertEquals((Object)"B.", (Object)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        Assert.assertEquals((Object)" h", (Object)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        Assert.assertEquals((Object)"K", (Object)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        Assert.assertEquals((Object)"i2", (Object)WordUtils.initials((String)"i am here 123", (char[])array));
    }

    @Test
    public void testSwapCase_String() {
        Assert.assertEquals(null, (Object)WordUtils.swapCase(null));
        Assert.assertEquals((Object)"", (Object)WordUtils.swapCase((String)""));
        Assert.assertEquals((Object)"  ", (Object)WordUtils.swapCase((String)"  "));
        Assert.assertEquals((Object)"i", (Object)WordUtils.swapCase((String)"I"));
        Assert.assertEquals((Object)"I", (Object)WordUtils.swapCase((String)"i"));
        Assert.assertEquals((Object)"I AM HERE 123", (Object)WordUtils.swapCase((String)"i am here 123"));
        Assert.assertEquals((Object)"i aM hERE 123", (Object)WordUtils.swapCase((String)"I Am Here 123"));
        Assert.assertEquals((Object)"I AM here 123", (Object)WordUtils.swapCase((String)"i am HERE 123"));
        Assert.assertEquals((Object)"i am here 123", (Object)WordUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        Assert.assertEquals((Object)"tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9", (Object)WordUtils.swapCase((String)"This String contains a TitleCase character: \u01c8"));
    }
}

