/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DateUtilsFragmentTest {
    private static final int months = 7;
    private static final int days = 23;
    private static final int hours = 19;
    private static final int minutes = 53;
    private static final int seconds = 47;
    private static final int millis = 991;
    private Date aDate;
    private Calendar aCalendar;

    @Before
    public void setUp() {
        this.aCalendar = Calendar.getInstance();
        this.aCalendar.set(2005, 7, 23, 19, 53, 47);
        this.aCalendar.set(14, 991);
        this.aDate = this.aCalendar.getTime();
    }

    @Test
    public void testNullDate() {
        try {
            DateUtils.getFragmentInMilliseconds((Date)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Date)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Date)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Date)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Date)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullCalendar() {
        try {
            DateUtils.getFragmentInMilliseconds((Calendar)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Calendar)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Calendar)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Calendar)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Calendar)null, (int)14);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFragmentWithDate() {
        try {
            DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Date)this.aDate, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Date)this.aDate, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Date)this.aDate, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Date)this.aDate, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFragmentWithCalendar() {
        try {
            DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMillisecondFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)14));
    }

    @Test
    public void testMillisecondFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)14));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)14));
    }

    @Test
    public void testSecondFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)13));
    }

    @Test
    public void testSecondFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)13));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)13));
    }

    @Test
    public void testMinuteFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)12));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)12));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)12));
    }

    @Test
    public void testMinuteFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)12));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)12));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)12));
    }

    @Test
    public void testHourOfDayFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)11));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)11));
    }

    @Test
    public void testHourOfDayFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)11));
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)11));
    }

    @Test
    public void testDayOfYearFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)6));
    }

    @Test
    public void testDayOfYearFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)6));
    }

    @Test
    public void testDateFragmentInLargerUnitWithDate() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)5));
    }

    @Test
    public void testDateFragmentInLargerUnitWithCalendar() {
        Assert.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)5));
    }

    @Test
    public void testMillisecondsOfSecondWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)13);
        Assert.assertEquals((long)991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfSecondWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)13);
        Assert.assertEquals((long)991L, (long)testResult);
        Assert.assertEquals((long)this.aCalendar.get(14), (long)testResult);
    }

    @Test
    public void testMillisecondsOfMinuteWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)12);
        Assert.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMinuteWithCalender() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)12);
        Assert.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    public void testSecondsofMinuteWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)12);
        Assert.assertEquals((long)47L, (long)testResult);
    }

    @Test
    public void testSecondsofMinuteWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)12);
        Assert.assertEquals((long)47L, (long)testResult);
        Assert.assertEquals((long)this.aCalendar.get(13), (long)testResult);
    }

    @Test
    public void testMillisecondsOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)11);
        Assert.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)11);
        Assert.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    public void testSecondsofHourWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)11);
        Assert.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    public void testSecondsofHourWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)11);
        Assert.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    public void testMinutesOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)11);
        Assert.assertEquals((long)53L, (long)testResult);
    }

    @Test
    public void testMinutesOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)11);
        Assert.assertEquals((long)53L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)5);
        long expectedValue = 71627991L;
        Assert.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)6);
        Assert.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    public void testMillisecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627991L;
        Assert.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)6);
        Assert.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    public void testSecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)5);
        long expectedValue = 71627L;
        Assert.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)6);
        Assert.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    public void testSecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627L;
        Assert.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)6);
        Assert.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    public void testMinutesOfDayWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)5);
        long expectedValue = 1193L;
        Assert.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)6);
        Assert.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    public void testMinutesOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)5);
        long expectedValue = 1193L;
        Assert.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)6);
        Assert.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    public void testHoursOfDayWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)5);
        long expectedValue = 19L;
        Assert.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)6);
        Assert.assertEquals((long)19L, (long)testResult);
    }

    @Test
    public void testHoursOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)5);
        long expectedValue = 19L;
        Assert.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)6);
        Assert.assertEquals((long)19L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)2);
        Assert.assertEquals((long)2058827991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)2);
        Assert.assertEquals((long)2058827991L, (long)testResult);
    }

    @Test
    public void testSecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)2);
        Assert.assertEquals((long)2058827L, (long)testResult);
    }

    @Test
    public void testSecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)2);
        Assert.assertEquals((long)2058827L, (long)testResult);
    }

    @Test
    public void testMinutesOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)2);
        Assert.assertEquals((long)34313L, (long)testResult);
    }

    @Test
    public void testMinutesOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)2);
        Assert.assertEquals((long)34313L, (long)testResult);
    }

    @Test
    public void testHoursOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)2);
        Assert.assertEquals((long)571L, (long)testResult);
    }

    @Test
    public void testHoursOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)2);
        Assert.assertEquals((long)571L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assert.assertEquals((long)(71627991L + (long)cal.get(6) * 86400000L), (long)testResult);
    }

    @Test
    public void testMillisecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)1);
        Assert.assertEquals((long)(71627991L + (long)this.aCalendar.get(6) * 86400000L), (long)testResult);
    }

    @Test
    public void testSecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assert.assertEquals((long)(47L + (71580000L + (long)cal.get(6) * 86400000L) / 1000L), (long)testResult);
    }

    @Test
    public void testSecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)1);
        Assert.assertEquals((long)(47L + (71580000L + (long)this.aCalendar.get(6) * 86400000L) / 1000L), (long)testResult);
    }

    @Test
    public void testMinutesOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assert.assertEquals((long)(53L + (68400000L + (long)cal.get(6) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    public void testMinutesOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)1);
        Assert.assertEquals((long)(53L + (68400000L + (long)this.aCalendar.get(6) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    public void testHoursOfYearWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assert.assertEquals((long)(19L + (long)cal.get(6) * 86400000L / 3600000L), (long)testResult);
    }

    @Test
    public void testHoursOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)1);
        Assert.assertEquals((long)(19L + (long)this.aCalendar.get(6) * 86400000L / 3600000L), (long)testResult);
    }
}

