/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FormatCache;
import org.junit.Assert;
import org.junit.Test;

public class FastDateParserTest {
    private static final String SHORT_FORMAT_NOERA = "y/M/d/h/a/m/E/Z";
    private static final String LONG_FORMAT_NOERA = "yyyy/MMMM/dddd/hhhh/mmmm/aaaa/EEEE/ZZZZ";
    private static final String SHORT_FORMAT = "G/y/M/d/h/a/m/E/Z";
    private static final String LONG_FORMAT = "GGGG/yyyy/MMMM/dddd/hhhh/mmmm/aaaa/EEEE/ZZZZ";
    private static final String yMdHmsSZ = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
    private static final String DMY_DOT = "dd.MM.yyyy";
    private static final String YMD_SLASH = "yyyy/MM/dd";
    private static final String MDY_DASH = "MM-DD-yyyy";
    private static final String MDY_SLASH = "MM/DD/yyyy";
    private static final TimeZone REYKJAVIK = TimeZone.getTimeZone("Atlantic/Reykjavik");
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Locale SWEDEN = new Locale("sv", "SE");

    DateParser getInstance(String format) {
        return this.getInstance(format, TimeZone.getDefault(), Locale.getDefault());
    }

    private DateParser getDateInstance(int dateStyle, Locale locale) {
        return this.getInstance(FormatCache.getPatternForStyle((Integer)dateStyle, null, (Locale)locale), TimeZone.getDefault(), Locale.getDefault());
    }

    private DateParser getInstance(String format, Locale locale) {
        return this.getInstance(format, TimeZone.getDefault(), locale);
    }

    private DateParser getInstance(String format, TimeZone timeZone) {
        return this.getInstance(format, timeZone, Locale.getDefault());
    }

    protected DateParser getInstance(String format, TimeZone timeZone, Locale locale) {
        return new FastDateParser(format, timeZone, locale);
    }

    @Test
    public void test_Equality_Hash() {
        DateParser[] parsers = new DateParser[]{this.getInstance(yMdHmsSZ, NEW_YORK, Locale.US), this.getInstance(DMY_DOT, NEW_YORK, Locale.US), this.getInstance(YMD_SLASH, NEW_YORK, Locale.US), this.getInstance(MDY_DASH, NEW_YORK, Locale.US), this.getInstance(MDY_SLASH, NEW_YORK, Locale.US), this.getInstance(MDY_SLASH, REYKJAVIK, Locale.US), this.getInstance(MDY_SLASH, REYKJAVIK, SWEDEN)};
        HashMap<DateParser, Integer> map = new HashMap<DateParser, Integer>();
        int i = 0;
        for (DateParser parser : parsers) {
            map.put(parser, i++);
        }
        i = 0;
        for (DateParser parser : parsers) {
            Assert.assertEquals((long)i++, (long)((Integer)map.get(parser)).intValue());
        }
    }

    @Test
    public void testParseZone() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 6, 10, 16, 33, 20);
        DateParser fdf = this.getInstance(yMdHmsSZ, NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 -0500"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 GMT-05:00"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 Eastern Daylight Time"));
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 EDT"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT-3"));
        cal.set(2003, 1, 10, 9, 0, 0);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T09:00:00.000 -0300"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT+5"));
        cal.set(2003, 1, 10, 15, 5, 6);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T15:05:06.000 +0500"));
    }

    @Test
    public void testParseLongShort() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        cal.setTimeZone(NEW_YORK);
        DateParser fdf = this.getInstance("yyyy GGGG MMMM dddd aaaa EEEE HHHH mmmm ssss SSSS ZZZZ", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003 AD February 0010 PM Monday 0015 0033 0020 0989 GMT-05:00"));
        cal.set(0, 0);
        Date parse = fdf.parse("2003 BC February 0010 PM Saturday 0015 0033 0020 0989 GMT-05:00");
        Assert.assertEquals((Object)cal.getTime(), (Object)parse);
        fdf = this.getInstance("y G M d a E H m s S Z", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 BC 2 10 PM Sat 15 33 20 989 -0500"));
        cal.set(0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 AD 2 10 PM Saturday 15 33 20 989 -0500"));
    }

    @Test
    public void testAmPm() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        DateParser h = this.getInstance("yyyy-MM-dd hh a mm:ss", NEW_YORK, Locale.US);
        DateParser K = this.getInstance("yyyy-MM-dd KK a mm:ss", NEW_YORK, Locale.US);
        DateParser k = this.getInstance("yyyy-MM-dd kk:mm:ss", NEW_YORK, Locale.US);
        DateParser H = this.getInstance("yyyy-MM-dd HH:mm:ss", NEW_YORK, Locale.US);
        cal.set(2010, 7, 1, 0, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 00:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 00:33:20"));
        cal.set(2010, 7, 1, 3, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 AM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 03:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 03:33:20"));
        cal.set(2010, 7, 1, 15, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 15:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 15:33:20"));
        cal.set(2010, 7, 1, 12, 33, 20);
        Assert.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 PM 33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 12:33:20"));
        Assert.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 12:33:20"));
    }

    @Test
    public void testParses() throws Exception {
        for (Locale locale : Locale.getAvailableLocales()) {
            for (TimeZone tz : new TimeZone[]{NEW_YORK, GMT}) {
                Calendar cal = Calendar.getInstance(tz);
                for (int year : new int[]{2003, 1940, 1868, 1867, 0, -1940}) {
                    if (year < 1868 && locale.equals(FastDateParser.JAPANESE_IMPERIAL)) continue;
                    cal.clear();
                    if (year < 0) {
                        cal.set(-year, 1, 10);
                        cal.set(0, 0);
                    } else {
                        cal.set(year, 1, 10);
                    }
                    Date in = cal.getTime();
                    for (String format : new String[]{LONG_FORMAT, SHORT_FORMAT}) {
                        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
                        if (format.equals(SHORT_FORMAT) && year < 1930) {
                            sdf.set2DigitYearStart(cal.getTime());
                        }
                        String fmt = sdf.format(in);
                        try {
                            Date out = sdf.parse(fmt);
                            Assert.assertEquals((String)(locale.toString() + " " + year + " " + format + " " + tz.getID()), (Object)in, (Object)out);
                        }
                        catch (ParseException pe) {
                            System.out.println(fmt + " " + locale.toString() + " " + year + " " + format + " " + tz.getID());
                            throw pe;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testLocales_Long_AD() throws Exception {
        this.testLocales(LONG_FORMAT, false);
    }

    @Test
    public void testLocales_Long_BC() throws Exception {
        this.testLocales(LONG_FORMAT, true);
    }

    @Test
    public void testLocales_Short_AD() throws Exception {
        this.testLocales(SHORT_FORMAT, false);
    }

    @Test
    public void testLocales_Short_BC() throws Exception {
        this.testLocales(SHORT_FORMAT, true);
    }

    @Test
    public void testLocales_LongNoEra_AD() throws Exception {
        this.testLocales(LONG_FORMAT_NOERA, false);
    }

    @Test
    public void testLocales_LongNoEra_BC() throws Exception {
        this.testLocales(LONG_FORMAT_NOERA, true);
    }

    @Test
    public void testLocales_ShortNoEra_AD() throws Exception {
        this.testLocales(SHORT_FORMAT_NOERA, false);
    }

    @Test
    public void testLocales_ShortNoEra_BC() throws Exception {
        this.testLocales(SHORT_FORMAT_NOERA, true);
    }

    private void testLocales(String format, boolean eraBC) throws Exception {
        Calendar cal = Calendar.getInstance(GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        if (eraBC) {
            cal.set(0, 0);
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            if (eraBC && locale.equals(FastDateParser.JAPANESE_IMPERIAL)) continue;
            SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
            DateParser fdf = this.getInstance(format, locale);
            try {
                this.checkParse(locale, cal, sdf, fdf);
            }
            catch (ParseException ex) {
                Assert.fail((String)("Locale " + locale + " failed with " + format + " era " + (eraBC ? "BC" : "AD") + "\n" + this.trimMessage(ex.toString())));
            }
        }
    }

    private String trimMessage(String msg) {
        if (msg.length() < 100) {
            return msg;
        }
        int gmt = msg.indexOf("(GMT");
        if (gmt > 0) {
            return msg.substring(0, gmt + 4) + "...)";
        }
        return msg.substring(0, 100) + "...";
    }

    private void checkParse(Locale locale, Calendar cal, SimpleDateFormat sdf, DateParser fdf) throws ParseException {
        String formattedDate = sdf.format(cal.getTime());
        Date expectedTime = sdf.parse(formattedDate);
        Date actualTime = fdf.parse(formattedDate);
        Assert.assertEquals((String)(locale.toString() + " " + formattedDate + "\n"), (Object)expectedTime, (Object)actualTime);
    }

    @Test
    public void testParseNumerics() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance("yyyyMMddHHmmssSSS", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("20030210153320989"));
    }

    @Test
    public void testQuotes() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance("''yyyyMMdd'A''B'HHmmssSSS''", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("'20030210A'B153320989'"));
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        this.testSdfAndFdp("q", "", true);
        this.testSdfAndFdp("Q", "", true);
        this.testSdfAndFdp("$", "$", false);
        this.testSdfAndFdp("?.d", "?.12", false);
        this.testSdfAndFdp("''yyyyMMdd'A''B'HHmmssSSS''", "'20030210A'B153320989'", false);
        this.testSdfAndFdp("''''yyyyMMdd'A''B'HHmmssSSS''", "''20030210A'B153320989'", false);
        this.testSdfAndFdp("'$\\Ed'", "$\\Ed", false);
    }

    @Test
    public void testLANG_832() throws Exception {
        this.testSdfAndFdp("'d'd", "d3", false);
        this.testSdfAndFdp("'d'd'", "d3", true);
    }

    @Test
    public void testLANG_831() throws Exception {
        this.testSdfAndFdp("M E", "3  Tue", true);
    }

    private void testSdfAndFdp(String format, String date, boolean shouldFail) throws Exception {
        Exception s;
        Exception f;
        Date dsdf;
        Date dfdp;
        block7: {
            block6: {
                boolean debug = false;
                dfdp = null;
                dsdf = null;
                f = null;
                s = null;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
                    sdf.setTimeZone(NEW_YORK);
                    dsdf = sdf.parse(date);
                    if (shouldFail) {
                        Assert.fail((String)("Expected SDF failure, but got " + dsdf + " for [" + format + "," + date + "]"));
                    }
                }
                catch (Exception e) {
                    s = e;
                    if (shouldFail) break block6;
                    throw e;
                }
            }
            try {
                DateParser fdp = this.getInstance(format, NEW_YORK, Locale.US);
                dfdp = fdp.parse(date);
                if (shouldFail) {
                    Assert.fail((String)("Expected FDF failure, but got " + dfdp + " for [" + format + "," + date + "] using " + ((FastDateParser)fdp).getParsePattern()));
                }
            }
            catch (Exception e) {
                f = e;
                if (shouldFail) break block7;
                throw e;
            }
        }
        Assert.assertTrue((String)"Should both or neither throw Exceptions", (f == null == (s == null) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Parsed dates should be equal", (Object)dsdf, (Object)dfdp);
    }

    @Test
    public void testDayOf() throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10);
        DateParser fdf = this.getInstance("W w F D y", NEW_YORK, Locale.US);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("3 7 2 41 03"));
    }

    @Test
    public void testShortDateStyleWithLocales() throws ParseException {
        DateParser fdf = this.getDateInstance(3, Locale.US);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2004, 1, 3);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2/3/04"));
        fdf = this.getDateInstance(3, SWEDEN);
        Assert.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2004-02-03"));
    }

    @Test
    public void testLowYearPadding() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0001/01/01"));
        cal.set(10, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0010/01/01"));
        cal.set(100, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0100/01/01"));
        cal.set(999, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("0999/01/01"));
    }

    @Test
    public void testMilleniumBug() throws ParseException {
        DateParser parser = this.getInstance(DMY_DOT);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1000, 0, 1);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("01.01.1000"));
    }

    @Test
    public void testLang303() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        Date date = parser.parse("2004/11/31");
        parser = (DateParser)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)parser)));
        Assert.assertEquals((Object)date, (Object)parser.parse("2004/11/31"));
    }

    @Test
    public void testLang538() throws ParseException {
        DateParser parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", GMT);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        Assert.assertEquals((Object)cal.getTime(), (Object)parser.parse("2009-10-16T16:42:16.000Z"));
    }

    @Test
    public void testEquals() {
        DateParser parser1 = this.getInstance(YMD_SLASH);
        DateParser parser2 = this.getInstance(YMD_SLASH);
        Assert.assertEquals((Object)parser1, (Object)parser2);
        Assert.assertEquals((long)parser1.hashCode(), (long)parser2.hashCode());
        Assert.assertFalse((boolean)parser1.equals(new Object()));
    }

    @Test
    public void testToStringContainsName() {
        DateParser parser = this.getInstance(YMD_SLASH);
        Assert.assertTrue((boolean)parser.toString().startsWith("FastDate"));
    }

    @Test
    public void testPatternMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ);
        Assert.assertEquals((Object)yMdHmsSZ, (Object)parser.getPattern());
    }

    @Test
    public void testLocaleMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, SWEDEN);
        Assert.assertEquals((Object)SWEDEN, (Object)parser.getLocale());
    }

    @Test
    public void testTimeZoneMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, REYKJAVIK);
        Assert.assertEquals((Object)REYKJAVIK, (Object)parser.getTimeZone());
    }
}

