/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.BitField;
import org.junit.Assert;
import org.junit.Test;

public class BitFieldTest {
    private static final BitField bf_multi = new BitField(16256);
    private static final BitField bf_single = new BitField(16384);
    private static final BitField bf_zero = new BitField(0);

    @Test
    public void testGetValue() {
        Assert.assertEquals((long)bf_multi.getValue(-1), (long)127L);
        Assert.assertEquals((long)bf_multi.getValue(0), (long)0L);
        Assert.assertEquals((long)bf_single.getValue(-1), (long)1L);
        Assert.assertEquals((long)bf_single.getValue(0), (long)0L);
        Assert.assertEquals((long)bf_zero.getValue(-1), (long)0L);
        Assert.assertEquals((long)bf_zero.getValue(0), (long)0L);
    }

    @Test
    public void testGetShortValue() {
        Assert.assertEquals((long)bf_multi.getShortValue((short)-1), (long)127L);
        Assert.assertEquals((long)bf_multi.getShortValue((short)0), (long)0L);
        Assert.assertEquals((long)bf_single.getShortValue((short)-1), (long)1L);
        Assert.assertEquals((long)bf_single.getShortValue((short)0), (long)0L);
        Assert.assertEquals((long)bf_zero.getShortValue((short)-1), (long)0L);
        Assert.assertEquals((long)bf_zero.getShortValue((short)0), (long)0L);
    }

    @Test
    public void testGetRawValue() {
        Assert.assertEquals((long)bf_multi.getRawValue(-1), (long)16256L);
        Assert.assertEquals((long)bf_multi.getRawValue(0), (long)0L);
        Assert.assertEquals((long)bf_single.getRawValue(-1), (long)16384L);
        Assert.assertEquals((long)bf_single.getRawValue(0), (long)0L);
        Assert.assertEquals((long)bf_zero.getRawValue(-1), (long)0L);
        Assert.assertEquals((long)bf_zero.getRawValue(0), (long)0L);
    }

    @Test
    public void testGetShortRawValue() {
        Assert.assertEquals((long)bf_multi.getShortRawValue((short)-1), (long)16256L);
        Assert.assertEquals((long)bf_multi.getShortRawValue((short)0), (long)0L);
        Assert.assertEquals((long)bf_single.getShortRawValue((short)-1), (long)16384L);
        Assert.assertEquals((long)bf_single.getShortRawValue((short)0), (long)0L);
        Assert.assertEquals((long)bf_zero.getShortRawValue((short)-1), (long)0L);
        Assert.assertEquals((long)bf_zero.getShortRawValue((short)0), (long)0L);
    }

    @Test
    public void testIsSet() {
        int j;
        Assert.assertTrue((!bf_multi.isSet(0) ? 1 : 0) != 0);
        Assert.assertTrue((!bf_zero.isSet(0) ? 1 : 0) != 0);
        for (j = 128; j <= 16256; j += 128) {
            Assert.assertTrue((boolean)bf_multi.isSet(j));
        }
        for (j = 128; j <= 16256; j += 128) {
            Assert.assertTrue((!bf_zero.isSet(j) ? 1 : 0) != 0);
        }
        Assert.assertTrue((!bf_single.isSet(0) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bf_single.isSet(16384));
    }

    @Test
    public void testIsAllSet() {
        for (int j = 0; j < 16256; j += 128) {
            Assert.assertTrue((!bf_multi.isAllSet(j) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)bf_zero.isAllSet(j));
        }
        Assert.assertTrue((boolean)bf_multi.isAllSet(16256));
        Assert.assertTrue((!bf_single.isAllSet(0) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bf_single.isAllSet(16384));
    }

    @Test
    public void testSetValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            Assert.assertEquals((long)bf_multi.getValue(bf_multi.setValue(0, j)), (long)j);
            Assert.assertEquals((long)bf_multi.setValue(0, j), (long)(j << 7));
        }
        for (j = 0; j < 128; ++j) {
            Assert.assertEquals((long)bf_zero.getValue(bf_zero.setValue(0, j)), (long)0L);
            Assert.assertEquals((long)bf_zero.setValue(0, j), (long)0L);
        }
        Assert.assertEquals((long)bf_multi.setValue(16256, 128), (long)0L);
        for (j = 0; j < 2; ++j) {
            Assert.assertEquals((long)bf_single.getValue(bf_single.setValue(0, j)), (long)j);
            Assert.assertEquals((long)bf_single.setValue(0, j), (long)(j << 14));
        }
        Assert.assertEquals((long)bf_single.setValue(16384, 2), (long)0L);
    }

    @Test
    public void testSetShortValue() {
        int j;
        for (j = 0; j < 128; ++j) {
            Assert.assertEquals((long)bf_multi.getShortValue(bf_multi.setShortValue((short)0, (short)j)), (long)((short)j));
            Assert.assertEquals((long)bf_multi.setShortValue((short)0, (short)j), (long)((short)(j << 7)));
        }
        for (j = 0; j < 128; ++j) {
            Assert.assertEquals((long)bf_zero.getShortValue(bf_zero.setShortValue((short)0, (short)j)), (long)0L);
            Assert.assertEquals((long)bf_zero.setShortValue((short)0, (short)j), (long)0L);
        }
        Assert.assertEquals((long)bf_multi.setShortValue((short)16256, (short)128), (long)0L);
        for (j = 0; j < 2; ++j) {
            Assert.assertEquals((long)bf_single.getShortValue(bf_single.setShortValue((short)0, (short)j)), (long)((short)j));
            Assert.assertEquals((long)bf_single.setShortValue((short)0, (short)j), (long)((short)(j << 14)));
        }
        Assert.assertEquals((long)bf_single.setShortValue((short)16384, (short)2), (long)0L);
    }

    @Test
    public void testByte() {
        Assert.assertEquals((long)0L, (long)new BitField(0).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)1L, (long)new BitField(1).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)2L, (long)new BitField(2).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)4L, (long)new BitField(4).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)8L, (long)new BitField(8).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)16L, (long)new BitField(16).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)32L, (long)new BitField(32).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)64L, (long)new BitField(64).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)-128L, (long)new BitField(128).setByteBoolean((byte)0, true));
        Assert.assertEquals((long)1L, (long)new BitField(0).setByteBoolean((byte)1, false));
        Assert.assertEquals((long)0L, (long)new BitField(1).setByteBoolean((byte)1, false));
        Assert.assertEquals((long)0L, (long)new BitField(2).setByteBoolean((byte)2, false));
        Assert.assertEquals((long)0L, (long)new BitField(4).setByteBoolean((byte)4, false));
        Assert.assertEquals((long)0L, (long)new BitField(8).setByteBoolean((byte)8, false));
        Assert.assertEquals((long)0L, (long)new BitField(16).setByteBoolean((byte)16, false));
        Assert.assertEquals((long)0L, (long)new BitField(32).setByteBoolean((byte)32, false));
        Assert.assertEquals((long)0L, (long)new BitField(64).setByteBoolean((byte)64, false));
        Assert.assertEquals((long)0L, (long)new BitField(128).setByteBoolean((byte)-128, false));
        Assert.assertEquals((long)-2L, (long)new BitField(1).setByteBoolean((byte)-1, false));
        byte clearedBit = new BitField(64).setByteBoolean((byte)-63, false);
        Assert.assertFalse((boolean)new BitField(64).isSet((int)clearedBit));
    }

    @Test
    public void testClear() {
        Assert.assertEquals((long)bf_multi.clear(-1), (long)-16257L);
        Assert.assertEquals((long)bf_single.clear(-1), (long)-16385L);
        Assert.assertEquals((long)bf_zero.clear(-1), (long)-1L);
    }

    @Test
    public void testClearShort() {
        Assert.assertEquals((long)bf_multi.clearShort((short)-1), (long)-16257L);
        Assert.assertEquals((long)bf_single.clearShort((short)-1), (long)-16385L);
        Assert.assertEquals((long)bf_zero.clearShort((short)-1), (long)-1L);
    }

    @Test
    public void testSet() {
        Assert.assertEquals((long)bf_multi.set(0), (long)16256L);
        Assert.assertEquals((long)bf_single.set(0), (long)16384L);
        Assert.assertEquals((long)bf_zero.set(0), (long)0L);
    }

    @Test
    public void testSetShort() {
        Assert.assertEquals((long)bf_multi.setShort((short)0), (long)16256L);
        Assert.assertEquals((long)bf_single.setShort((short)0), (long)16384L);
        Assert.assertEquals((long)bf_zero.setShort((short)0), (long)0L);
    }

    @Test
    public void testSetBoolean() {
        Assert.assertEquals((long)bf_multi.set(0), (long)bf_multi.setBoolean(0, true));
        Assert.assertEquals((long)bf_single.set(0), (long)bf_single.setBoolean(0, true));
        Assert.assertEquals((long)bf_zero.set(0), (long)bf_zero.setBoolean(0, true));
        Assert.assertEquals((long)bf_multi.clear(-1), (long)bf_multi.setBoolean(-1, false));
        Assert.assertEquals((long)bf_single.clear(-1), (long)bf_single.setBoolean(-1, false));
        Assert.assertEquals((long)bf_zero.clear(-1), (long)bf_zero.setBoolean(-1, false));
    }

    @Test
    public void testSetShortBoolean() {
        Assert.assertEquals((long)bf_multi.setShort((short)0), (long)bf_multi.setShortBoolean((short)0, true));
        Assert.assertEquals((long)bf_single.setShort((short)0), (long)bf_single.setShortBoolean((short)0, true));
        Assert.assertEquals((long)bf_zero.setShort((short)0), (long)bf_zero.setShortBoolean((short)0, true));
        Assert.assertEquals((long)bf_multi.clearShort((short)-1), (long)bf_multi.setShortBoolean((short)-1, false));
        Assert.assertEquals((long)bf_single.clearShort((short)-1), (long)bf_single.setShortBoolean((short)-1, false));
        Assert.assertEquals((long)bf_zero.clearShort((short)-1), (long)bf_zero.setShortBoolean((short)-1, false));
    }
}

