/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.HashCodeExclude;
import org.junit.Assert;
import org.junit.Test;

public class HashCodeBuilderTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructorExZero() {
        new HashCodeBuilder(0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorExEvenFirst() {
        new HashCodeBuilder(2, 3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorExEvenSecond() {
        new HashCodeBuilder(3, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorExEvenNegative() {
        new HashCodeBuilder(-2, -2);
    }

    @Test
    public void testReflectionHashCode() {
        Assert.assertEquals((long)629L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestObject(0), (String[])new String[0]));
        Assert.assertEquals((long)124085L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestObject(123456), (String[])new String[0]));
    }

    @Test
    public void testReflectionHierarchyHashCode() {
        Assert.assertEquals((long)23273L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (String[])new String[0]));
        Assert.assertEquals((long)861101L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(0, 0, 0), (boolean)true));
        Assert.assertEquals((long)438659L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (String[])new String[0]));
        Assert.assertEquals((long)11785967L, (long)HashCodeBuilder.reflectionHashCode((Object)new TestSubObject(123456, 7890, 0), (boolean)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionHierarchyHashCodeEx1() {
        HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestSubObject(0, 0, 0), (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionHierarchyHashCodeEx2() {
        HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestSubObject(0, 0, 0), (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionHashCodeEx1() {
        HashCodeBuilder.reflectionHashCode((int)0, (int)0, (Object)new TestObject(0), (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionHashCodeEx2() {
        HashCodeBuilder.reflectionHashCode((int)2, (int)2, (Object)new TestObject(0), (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReflectionHashCodeEx3() {
        HashCodeBuilder.reflectionHashCode((int)13, (int)19, null, (boolean)true);
    }

    @Test
    public void testSuper() {
        Object obj = new Object();
        Assert.assertEquals((long)(1408 + obj.hashCode()), (long)new HashCodeBuilder(17, 37).appendSuper(new HashCodeBuilder(19, 41).append(obj).toHashCode()).toHashCode());
    }

    @Test
    public void testObject() {
        Object obj = null;
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj = new Object();
        Assert.assertEquals((long)(629 + obj.hashCode()), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testObjectBuild() {
        Object obj = null;
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(obj).build().intValue());
        obj = new Object();
        Assert.assertEquals((long)(629 + obj.hashCode()), (long)new HashCodeBuilder(17, 37).append(obj).build().intValue());
    }

    @Test
    public void testLong() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(0L).toHashCode());
        Assert.assertEquals((long)123457418L, (long)new HashCodeBuilder(17, 37).append(123456789L).toHashCode());
    }

    @Test
    public void testInt() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(0).toHashCode());
        Assert.assertEquals((long)124085L, (long)new HashCodeBuilder(17, 37).append(123456).toHashCode());
    }

    @Test
    public void testShort() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((short)0).toHashCode());
        Assert.assertEquals((long)12974L, (long)new HashCodeBuilder(17, 37).append((short)12345).toHashCode());
    }

    @Test
    public void testChar() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append('\u0000').toHashCode());
        Assert.assertEquals((long)1863L, (long)new HashCodeBuilder(17, 37).append('\u04d2').toHashCode());
    }

    @Test
    public void testByte() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((byte)0).toHashCode());
        Assert.assertEquals((long)752L, (long)new HashCodeBuilder(17, 37).append((byte)123).toHashCode());
    }

    @Test
    public void testDouble() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(0.0).toHashCode());
        double d = 1234567.89;
        long l = Double.doubleToLongBits(1234567.89);
        Assert.assertEquals((long)(629 + (int)(l ^ l >> 32)), (long)new HashCodeBuilder(17, 37).append(1234567.89).toHashCode());
    }

    @Test
    public void testFloat() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(0.0f).toHashCode());
        float f = 1234.89f;
        int i = Float.floatToIntBits(1234.89f);
        Assert.assertEquals((long)(629 + i), (long)new HashCodeBuilder(17, 37).append(1234.89f).toHashCode());
    }

    @Test
    public void testBoolean() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append(true).toHashCode());
        Assert.assertEquals((long)630L, (long)new HashCodeBuilder(17, 37).append(false).toHashCode());
    }

    @Test
    public void testObjectArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((Object[])null).toHashCode());
        Object[] obj = new Object[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = new Object();
        Assert.assertEquals((long)((629 + obj[0].hashCode()) * 37), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = new Object();
        Assert.assertEquals((long)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testObjectArrayAsObject() {
        Object[] obj = new Object[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = new Object();
        Assert.assertEquals((long)((629 + obj[0].hashCode()) * 37), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = new Object();
        Assert.assertEquals((long)((629 + obj[0].hashCode()) * 37 + obj[1].hashCode()), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testLongArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((long[])null).toHashCode());
        long[] obj = new long[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testLongArrayAsObject() {
        long[] obj = new long[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5L;
        int h1 = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6L;
        int h2 = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testIntArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((int[])null).toHashCode());
        int[] obj = new int[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testIntArrayAsObject() {
        int[] obj = new int[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testShortArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((short[])null).toHashCode());
        short[] obj = new short[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testShortArrayAsObject() {
        short[] obj = new short[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testCharArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((char[])null).toHashCode());
        char[] obj = new char[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testCharArrayAsObject() {
        char[] obj = new char[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testByteArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((byte[])null).toHashCode());
        byte[] obj = new byte[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testByteArrayAsObject() {
        byte[] obj = new byte[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5;
        Assert.assertEquals((long)23458L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6;
        Assert.assertEquals((long)23464L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testDoubleArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((double[])null).toHashCode());
        double[] obj = new double[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        Assert.assertEquals((long)((629 + h1) * 37), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        Assert.assertEquals((long)((629 + h1) * 37 + h2), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testDoubleArrayAsObject() {
        double[] obj = new double[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4;
        long l1 = Double.doubleToLongBits(5.4);
        int h1 = (int)(l1 ^ l1 >> 32);
        Assert.assertEquals((long)((629 + h1) * 37), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3;
        long l2 = Double.doubleToLongBits(6.3);
        int h2 = (int)(l2 ^ l2 >> 32);
        Assert.assertEquals((long)((629 + h1) * 37 + h2), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testFloatArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((float[])null).toHashCode());
        float[] obj = new float[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        Assert.assertEquals((long)((629 + h1) * 37), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        Assert.assertEquals((long)((629 + h1) * 37 + h2), (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testFloatArrayAsObject() {
        float[] obj = new float[2];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = 5.4f;
        int h1 = Float.floatToIntBits(5.4f);
        Assert.assertEquals((long)((629 + h1) * 37), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = 6.3f;
        int h2 = Float.floatToIntBits(6.3f);
        Assert.assertEquals((long)((629 + h1) * 37 + h2), (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testBooleanArray() {
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((boolean[])null).toHashCode());
        boolean[] obj = new boolean[2];
        Assert.assertEquals((long)23311L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[0] = true;
        Assert.assertEquals((long)23274L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
        obj[1] = false;
        Assert.assertEquals((long)23274L, (long)new HashCodeBuilder(17, 37).append(obj).toHashCode());
    }

    @Test
    public void testBooleanArrayAsObject() {
        boolean[] obj = new boolean[2];
        Assert.assertEquals((long)23311L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[0] = true;
        Assert.assertEquals((long)23274L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
        obj[1] = false;
        Assert.assertEquals((long)23274L, (long)new HashCodeBuilder(17, 37).append((Object)obj).toHashCode());
    }

    @Test
    public void testBooleanMultiArray() {
        boolean[][] obj = new boolean[2][];
        Assert.assertEquals((long)23273L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[0];
        Assert.assertEquals((long)629L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[1];
        Assert.assertEquals((long)23310L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0] = new boolean[2];
        Assert.assertEquals((long)862507L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[0][0] = true;
        Assert.assertEquals((long)861138L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
        obj[1] = new boolean[1];
        Assert.assertEquals((long)861139L, (long)new HashCodeBuilder(17, 37).append((Object[])obj).toHashCode());
    }

    @Test
    public void testReflectionHashCodeExcludeFields() throws Exception {
        TestObjectWithMultipleFields x = new TestObjectWithMultipleFields(1, 2, 3);
        Assert.assertEquals((long)862547L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        Assert.assertEquals((long)862547L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])null));
        Assert.assertEquals((long)862547L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[0]));
        Assert.assertEquals((long)862547L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"xxx"}));
        Assert.assertEquals((long)23313L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two"}));
        Assert.assertEquals((long)23312L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"three"}));
        Assert.assertEquals((long)630L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"two", "three"}));
        Assert.assertEquals((long)17L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three"}));
        Assert.assertEquals((long)17L, (long)HashCodeBuilder.reflectionHashCode((Object)x, (String[])new String[]{"one", "two", "three", "xxx"}));
    }

    @Test
    public void testReflectionObjectCycle() {
        ReflectionTestCycleB b;
        ReflectionTestCycleA a = new ReflectionTestCycleA();
        a.b = b = new ReflectionTestCycleB();
        b.a = a;
        a.hashCode();
        Assert.assertNull((Object)HashCodeBuilder.getRegistry());
        b.hashCode();
        Assert.assertNull((Object)HashCodeBuilder.getRegistry());
    }

    @Test
    public void testToHashCodeEqualsHashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(17, 37).append(new Object()).append('a');
        Assert.assertEquals((String)"hashCode() is no longer returning the same value as toHashCode() - see LANG-520", (long)hcb.toHashCode(), (long)hcb.hashCode());
    }

    @Test
    public void testToHashCodeExclude() {
        TestObjectHashCodeExclude one = new TestObjectHashCodeExclude(1, 2);
        TestObjectHashCodeExclude2 two = new TestObjectHashCodeExclude2(1, 2);
        Assert.assertEquals((long)631L, (long)HashCodeBuilder.reflectionHashCode((Object)one, (String[])new String[0]));
        Assert.assertEquals((long)17L, (long)HashCodeBuilder.reflectionHashCode((Object)two, (String[])new String[0]));
    }

    static class TestObjectHashCodeExclude2 {
        @HashCodeExclude
        private int a;
        @HashCodeExclude
        private int b;

        public TestObjectHashCodeExclude2(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObjectHashCodeExclude {
        @HashCodeExclude
        private int a;
        private int b;

        public TestObjectHashCodeExclude(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    static class TestObjectWithMultipleFields {
        private int one = 0;
        private int two = 0;
        private int three = 0;

        public TestObjectWithMultipleFields(int one, int two, int three) {
            this.one = one;
            this.two = two;
            this.three = three;
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;
        private transient int t;

        public TestSubObject() {
            super(0);
        }

        public TestSubObject(int a, int b, int t) {
            super(a);
            this.b = b;
            this.t = t;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestSubObject)) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }

        @Override
        public int hashCode() {
            return this.b * 17 + super.hashCode();
        }
    }

    static class TestObject {
        private int a;

        public TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestObject)) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public int hashCode() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }
    }

    static class ReflectionTestCycleB {
        ReflectionTestCycleA a;

        ReflectionTestCycleB() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }

    static class ReflectionTestCycleA {
        ReflectionTestCycleB b;

        ReflectionTestCycleA() {
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

