/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.ThresholdCircuitBreaker;
import org.junit.Assert;
import org.junit.Test;

public class ThresholdCircuitBreakerTest {
    private static final long threshold = 10L;
    private static final long zeroThreshold = 0L;

    @Test
    public void testThreshold() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        Assert.assertFalse((String)"Circuit opened before reaching the threshold", (boolean)circuit.incrementAndCheckState(Long.valueOf(1L)));
    }

    @Test
    public void testThresholdCircuitBreakingException() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        Assert.assertTrue((String)"The circuit was spposed to be open after increment above the threshold", (boolean)circuit.incrementAndCheckState(Long.valueOf(2L)));
    }

    @Test
    public void testThresholdEqualsZero() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(0L);
        Assert.assertTrue((String)"When the threshold is zero, the circuit is supposed to be always open", (boolean)circuit.incrementAndCheckState(Long.valueOf(0L)));
    }

    @Test
    public void testClosingThresholdCircuitBreaker() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        circuit.incrementAndCheckState(Long.valueOf(9L));
        circuit.close();
        Assert.assertFalse((String)"Internal counter was not reset back to zero", (boolean)circuit.incrementAndCheckState(Long.valueOf(9L)));
    }

    @Test
    public void testGettingThreshold() {
        ThresholdCircuitBreaker circuit = new ThresholdCircuitBreaker(10L);
        Assert.assertEquals((String)"Wrong value of threshold", (Object)10L, (Object)circuit.getThreshold());
    }
}

