/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Test;

public class SystemUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new SystemUtils());
        Constructor<?>[] cons = SystemUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(SystemUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(SystemUtils.class.getModifiers()));
    }

    @Test
    public void testGetHostName() {
        String hostName = SystemUtils.getHostName();
        String expected = SystemUtils.IS_OS_WINDOWS ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        Assert.assertEquals((Object)expected, (Object)hostName);
    }

    @Test
    public void testGetJavaHome() {
        File dir = SystemUtils.getJavaHome();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetJavaIoTmpDir() {
        File dir = SystemUtils.getJavaIoTmpDir();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetUserDir() {
        File dir = SystemUtils.getUserDir();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testGetUserHome() {
        File dir = SystemUtils.getUserHome();
        Assert.assertNotNull((Object)dir);
        Assert.assertTrue((boolean)dir.exists());
    }

    @Test
    public void testIS_JAVA() {
        String javaVersion = SystemUtils.JAVA_VERSION;
        if (javaVersion == null) {
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_9);
        } else if (javaVersion.startsWith("1.7")) {
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assert.assertTrue((boolean)SystemUtils.IS_JAVA_1_7);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_9);
        } else if (javaVersion.startsWith("1.8")) {
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assert.assertTrue((boolean)SystemUtils.IS_JAVA_1_8);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_9);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_9);
        } else if (javaVersion.startsWith("9")) {
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_1);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_2);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_3);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_4);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_5);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_6);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_7);
            Assert.assertFalse((boolean)SystemUtils.IS_JAVA_1_8);
            Assert.assertTrue((boolean)SystemUtils.IS_JAVA_1_9);
            Assert.assertTrue((boolean)SystemUtils.IS_JAVA_9);
        } else {
            System.out.println("Can't test IS_JAVA value: " + javaVersion);
        }
    }

    @Test
    public void testIS_OS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_SOLARIS);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_LINUX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_MAC_OSX);
        } else if (osName.startsWith("Windows")) {
            Assert.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Solaris")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_SOLARIS);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_LINUX);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("Mac OS X")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_MAC_OSX);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("OS/2")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_OS2);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("SunOS")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_SUN_OS);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else if (osName.startsWith("FreeBSD")) {
            Assert.assertTrue((boolean)SystemUtils.IS_OS_FREE_BSD);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_UNIX);
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        } else {
            System.out.println("Can't test IS_OS value: " + osName);
        }
    }

    @Test
    public void testIS_zOS() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assert.assertFalse((boolean)SystemUtils.IS_OS_ZOS);
        } else if (osName.contains("z/OS")) {
            Assert.assertFalse((boolean)SystemUtils.IS_OS_WINDOWS);
            Assert.assertTrue((boolean)SystemUtils.IS_OS_ZOS);
        }
    }

    @Test
    public void testJavaVersionMatches() {
        String javaVersion = null;
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch(javaVersion, (String)"9"));
        javaVersion = "";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.0";
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.1";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.2";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.3.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.3.1";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.1";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.4.2";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.5.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.6.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.7.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "1.8.0";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
        javaVersion = "9";
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.0"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.1"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.2"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.3"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.4"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.5"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.6"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.7"));
        Assert.assertFalse((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"1.8"));
        Assert.assertTrue((boolean)SystemUtils.isJavaVersionMatch((String)javaVersion, (String)"9"));
    }

    @Test
    public void testIsJavaVersionAtLeat() throws Exception {
        if (SystemUtils.IS_JAVA_1_7) {
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assert.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assert.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        } else if (SystemUtils.IS_JAVA_1_8) {
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assert.assertFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        } else if (SystemUtils.IS_JAVA_9) {
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_1));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_2));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_3));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_4));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8));
            Assert.assertTrue((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        }
    }

    @Test
    public void testOSMatchesName() {
        String osName = null;
        Assert.assertFalse((boolean)SystemUtils.isOSNameMatch(osName, (String)"Windows"));
        osName = "";
        Assert.assertFalse((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows 95";
        Assert.assertTrue((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "Windows NT";
        Assert.assertTrue((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
        osName = "OS/2";
        Assert.assertFalse((boolean)SystemUtils.isOSNameMatch((String)osName, (String)"Windows"));
    }

    @Test
    public void testOSMatchesNameAndVersion() {
        String osName = null;
        String osVersion = null;
        Assert.assertFalse((boolean)SystemUtils.isOSMatch(osName, osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "";
        osVersion = "";
        Assert.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.0";
        Assert.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 95";
        osVersion = "4.1";
        Assert.assertTrue((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows 98";
        osVersion = "4.1";
        Assert.assertTrue((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "Windows NT";
        osVersion = "4.0";
        Assert.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
        osName = "OS/2";
        osVersion = "4.0";
        Assert.assertFalse((boolean)SystemUtils.isOSMatch((String)osName, (String)osVersion, (String)"Windows 9", (String)"4.1"));
    }

    @Test
    public void testOsVersionMatches() throws Exception {
        String osVersion = null;
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch(osVersion, (String)"10.1"));
        osVersion = "";
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        osVersion = "10";
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1";
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.1.1";
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10";
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
        osVersion = "10.10.1";
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1"));
        Assert.assertFalse((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.1.1"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10"));
        Assert.assertTrue((boolean)SystemUtils.isOSVersionMatch((String)osVersion, (String)"10.10.1"));
    }

    @Test
    public void testJavaAwtHeadless() {
        String expectedStringValue = System.getProperty("java.awt.headless");
        String expectedStringValueWithDefault = System.getProperty("java.awt.headless", "false");
        Assert.assertNotNull((Object)expectedStringValueWithDefault);
        boolean expectedValue = Boolean.valueOf(expectedStringValue);
        if (expectedStringValue != null) {
            Assert.assertEquals((Object)expectedStringValue, (Object)SystemUtils.JAVA_AWT_HEADLESS);
        }
        Assert.assertEquals((Object)expectedValue, (Object)SystemUtils.isJavaAwtHeadless());
        Assert.assertEquals((Object)expectedStringValueWithDefault, (Object)("" + SystemUtils.isJavaAwtHeadless()));
    }
}

