/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionToStringBuilderExcludeNullValuesTest {
    private static final String INTEGER_FIELD_NAME = "testIntegerField";
    private static final String STRING_FIELD_NAME = "testStringField";
    private final TestFixture BOTH_NON_NULL = new TestFixture(0, "str");
    private final TestFixture FIRST_NULL = new TestFixture(null, "str");
    private final TestFixture SECOND_NULL = new TestFixture(0, null);
    private final TestFixture BOTH_NULL = new TestFixture(null, null);

    @Test
    public void test_NonExclude() {
        String toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NON_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.FIRST_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.SECOND_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NULL, null, (boolean)false, (boolean)false, (boolean)false, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_excludeNull() {
        String toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NON_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.FIRST_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.SECOND_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        toString = ReflectionToStringBuilder.toString((Object)this.BOTH_NULL, null, (boolean)false, (boolean)false, (boolean)true, null);
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOption() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NON_NULL, null, null, null, false, false, true);
        Assert.assertTrue((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.FIRST_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.SECOND_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOptionNormal() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, false);
        Assert.assertFalse((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        ReflectionToStringBuilder oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL);
        toString = oldBuilder.toString();
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false);
        toString = oldBuilder.toString();
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
        oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null);
        toString = oldBuilder.toString();
        Assert.assertTrue((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertTrue((boolean)toString.contains(INTEGER_FIELD_NAME));
    }

    @Test
    public void test_ConstructorOption_ExcludeNull() {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, false);
        builder.setExcludeNullValues(true);
        Assert.assertTrue((boolean)builder.isExcludeNullValues());
        String toString = builder.toString();
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        builder = new ReflectionToStringBuilder((Object)this.BOTH_NULL, null, null, null, false, false, true);
        toString = builder.toString();
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
        ReflectionToStringBuilder oldBuilder = new ReflectionToStringBuilder((Object)this.BOTH_NULL);
        oldBuilder.setExcludeNullValues(true);
        Assert.assertTrue((boolean)oldBuilder.isExcludeNullValues());
        toString = oldBuilder.toString();
        Assert.assertFalse((boolean)toString.contains(STRING_FIELD_NAME));
        Assert.assertFalse((boolean)toString.contains(INTEGER_FIELD_NAME));
    }

    static class TestFixture {
        private Integer testIntegerField;
        private String testStringField;

        TestFixture(Integer a, String b) {
            this.testIntegerField = a;
            this.testStringField = b;
        }
    }
}

