/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.junit.Test;

public class ToStringStyleConcurrencyTest {
    private static final List<Integer> LIST = new ArrayList<Integer>(100000);
    private static final int LIST_SIZE = 100000;
    private static final int REPEAT = 100;

    @Test
    public void testLinkedList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new LinkedList()));
    }

    @Test
    public void testArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new ArrayList()));
    }

    @Test
    public void testCopyOnWriteArrayList() throws InterruptedException, ExecutionException {
        this.testConcurrency(new CollectionHolder<List<Integer>>(new CopyOnWriteArrayList()));
    }

    private void testConcurrency(final CollectionHolder<List<Integer>> holder) throws InterruptedException, ExecutionException {
        List list = (List)holder.collection;
        list.addAll(LIST);
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        Callable<Integer> consumer = new Callable<Integer>(){

            @Override
            public Integer call() {
                for (int i = 0; i < 100; ++i) {
                    new ToStringBuilder((Object)holder).append(holder.collection);
                }
                return 100;
            }
        };
        ArrayList<1> tasks = new ArrayList<1>();
        tasks.add(consumer);
        tasks.add(consumer);
        List futures = threadPool.invokeAll(tasks);
        for (Future future : futures) {
            future.get();
        }
        threadPool.shutdown();
        threadPool.awaitTermination(1L, TimeUnit.SECONDS);
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            LIST.add(i);
        }
    }

    static class CollectionHolder<T extends Collection<?>> {
        T collection;

        CollectionHolder(T collection) {
            this.collection = collection;
        }
    }
}

