/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.CircuitBreakingException;
import org.apache.commons.lang3.exception.AbstractExceptionTest;
import org.junit.Assert;
import org.junit.Test;

public class CircuitBreakingExceptionTest
extends AbstractExceptionTest {
    @Test(expected=CircuitBreakingException.class)
    public void testThrowingInformativeException() throws Exception {
        throw new CircuitBreakingException("Exception message", (Throwable)this.generateCause());
    }

    @Test(expected=CircuitBreakingException.class)
    public void testThrowingExceptionWithMessage() throws Exception {
        throw new CircuitBreakingException("Exception message");
    }

    @Test(expected=CircuitBreakingException.class)
    public void testThrowingExceptionWithCause() throws Exception {
        throw new CircuitBreakingException((Throwable)this.generateCause());
    }

    @Test(expected=CircuitBreakingException.class)
    public void testThrowingEmptyException() throws Exception {
        throw new CircuitBreakingException();
    }

    @Test
    public void testWithCauseAndMessage() throws Exception {
        CircuitBreakingException exception = new CircuitBreakingException("Exception message", (Throwable)this.generateCause());
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((String)"Wrong exception message", (Object)"Exception message", (Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((String)"Wrong cause message", (Object)"Cause message", (Object)cause.getMessage());
    }

    @Test
    public void testWithoutCause() throws Exception {
        CircuitBreakingException exception = new CircuitBreakingException("Exception message");
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((String)"Wrong exception message", (Object)"Exception message", (Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNull((Object)cause);
    }

    @Test
    public void testWithoutMessage() throws Exception {
        CircuitBreakingException exception = new CircuitBreakingException((Throwable)this.generateCause());
        Assert.assertNotNull((Object)exception);
        Assert.assertNotNull((Object)exception.getMessage());
        Throwable cause = exception.getCause();
        Assert.assertNotNull((Object)cause);
        Assert.assertEquals((String)"Wrong cause message", (Object)"Cause message", (Object)cause.getMessage());
    }
}

