/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new ArrayUtils());
        Constructor<?>[] cons = ArrayUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(ArrayUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(ArrayUtils.class.getModifiers()));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"{}", (Object)ArrayUtils.toString(null));
        Assert.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0]));
        Assert.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0]));
        Assert.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}));
        Assert.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}));
        Assert.assertEquals((Object)"<empty>", (Object)ArrayUtils.toString(null, (String)"<empty>"));
        Assert.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0], (String)"<empty>"));
        Assert.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0], (String)"<empty>"));
        Assert.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}, (String)"<empty>"));
        Assert.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}, (String)"<empty>"));
    }

    @Test
    public void testHashCode() {
        long[][] array1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] array2 = new long[][]{{2L, 5L}, {4L, 6L}};
        Assert.assertTrue((ArrayUtils.hashCode((Object)array1) == ArrayUtils.hashCode((Object)array1) ? 1 : 0) != 0);
        Assert.assertFalse((ArrayUtils.hashCode((Object)array1) == ArrayUtils.hashCode((Object)array2) ? 1 : 0) != 0);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assert.assertTrue((ArrayUtils.hashCode((Object)array3) == ArrayUtils.hashCode((Object)array3) ? 1 : 0) != 0);
        Assert.assertTrue((ArrayUtils.hashCode((Object)array3) == ArrayUtils.hashCode((Object)array4) ? 1 : 0) != 0);
        Object[] arrayA = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Object[] arrayB = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Assert.assertTrue((ArrayUtils.hashCode((Object)arrayB) == ArrayUtils.hashCode((Object)arrayA) ? 1 : 0) != 0);
    }

    private void assertIsEquals(Object array1, Object array2, Object array3) {
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)array1, (Object)array1));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)array2, (Object)array2));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array3));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array3, (Object)array1));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assert.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
    }

    @Test
    public void testIsEquals() {
        long[][] larray1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] larray2 = new long[][]{{2L, 5L}, {4L, 6L}};
        long[] larray3 = new long[]{2L, 5L};
        this.assertIsEquals(larray1, larray2, larray3);
        int[][] iarray1 = new int[][]{{2, 5}, {4, 5}};
        int[][] iarray2 = new int[][]{{2, 5}, {4, 6}};
        int[] iarray3 = new int[]{2, 5};
        this.assertIsEquals(iarray1, iarray2, iarray3);
        short[][] sarray1 = new short[][]{{2, 5}, {4, 5}};
        short[][] sarray2 = new short[][]{{2, 5}, {4, 6}};
        short[] sarray3 = new short[]{2, 5};
        this.assertIsEquals(sarray1, sarray2, sarray3);
        float[][] farray1 = new float[][]{{2.0f, 5.0f}, {4.0f, 5.0f}};
        float[][] farray2 = new float[][]{{2.0f, 5.0f}, {4.0f, 6.0f}};
        float[] farray3 = new float[]{2.0f, 5.0f};
        this.assertIsEquals(farray1, farray2, farray3);
        double[][] darray1 = new double[][]{{2.0, 5.0}, {4.0, 5.0}};
        double[][] darray2 = new double[][]{{2.0, 5.0}, {4.0, 6.0}};
        double[] darray3 = new double[]{2.0, 5.0};
        this.assertIsEquals(darray1, darray2, darray3);
        byte[][] byteArray1 = new byte[][]{{2, 5}, {4, 5}};
        byte[][] byteArray2 = new byte[][]{{2, 5}, {4, 6}};
        byte[] byteArray3 = new byte[]{2, 5};
        this.assertIsEquals(byteArray1, byteArray2, byteArray3);
        char[][] charArray1 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0005'}};
        char[][] charArray2 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0006'}};
        char[] charArray3 = new char[]{'\u0002', '\u0005'};
        this.assertIsEquals(charArray1, charArray2, charArray3);
        boolean[][] barray1 = new boolean[][]{{true, false}, {true, true}};
        boolean[][] barray2 = new boolean[][]{{true, false}, {true, false}};
        boolean[] barray3 = new boolean[]{false, true};
        this.assertIsEquals(barray1, barray2, barray3);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array4));
        Assert.assertTrue((boolean)ArrayUtils.isEquals(null, null));
        Assert.assertFalse((boolean)ArrayUtils.isEquals(null, (Object)array4));
    }

    @Test
    public void testArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)"foo", (Object)array[0]);
        Assert.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    public void testArrayCreationWithGeneralReturnType() {
        Object[] obj = ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assert.assertTrue((boolean)(obj instanceof String[]));
    }

    @Test
    public void testArrayCreationWithDifferentTypes() {
        Number[] array = (Number[])ArrayUtils.toArray((Object[])new Number[]{42, Math.PI});
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)42, (Object)array[0]);
        Assert.assertEquals((Object)Math.PI, (Object)array[1]);
    }

    @Test
    public void testIndirectArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType("foo", "bar");
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertEquals((Object)"foo", (Object)array[0]);
        Assert.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    public void testEmptyArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[0]);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testIndirectEmptyArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType(new String[0]);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @SafeVarargs
    private static <T> T[] toArrayPropagatingType(T ... items) {
        return ArrayUtils.toArray((Object[])items);
    }

    @Test
    public void testToMap() {
        Map map = ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"hello", "world"}});
        Assert.assertEquals((Object)"bar", map.get("foo"));
        Assert.assertEquals((Object)"world", map.get("hello"));
        Assert.assertEquals(null, (Object)ArrayUtils.toMap(null));
        try {
            ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"short"}});
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, "illegal type"});
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, null});
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        map = ArrayUtils.toMap((Object[])new Object[]{new Map.Entry<Object, Object>(){

            @Override
            public Object getKey() {
                return "foo";
            }

            @Override
            public Object getValue() {
                return "bar";
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }
        }});
        Assert.assertEquals((Object)"bar", map.get("foo"));
    }

    @Test
    public void testClone() {
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.clone((Object[])null));
        Object[] original1 = new Object[]{};
        Object[] cloned1 = ArrayUtils.clone((Object[])original1);
        Assert.assertTrue((boolean)Arrays.equals(original1, cloned1));
        Assert.assertTrue((original1 != cloned1 ? 1 : 0) != 0);
        StringBuilder builder = new StringBuilder("pick");
        original1 = new Object[]{builder, "a", new String[]{"stick"}};
        cloned1 = ArrayUtils.clone((Object[])original1);
        Assert.assertTrue((boolean)Arrays.equals(original1, cloned1));
        Assert.assertTrue((original1 != cloned1 ? 1 : 0) != 0);
        Assert.assertSame((Object)original1[0], (Object)cloned1[0]);
        Assert.assertSame((Object)original1[1], (Object)cloned1[1]);
        Assert.assertSame((Object)original1[2], (Object)cloned1[2]);
    }

    @Test
    public void testCloneBoolean() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((boolean[])null));
        boolean[] original = new boolean[]{true, false};
        boolean[] cloned = ArrayUtils.clone((boolean[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneLong() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((long[])null));
        long[] original = new long[]{0L, 1L};
        long[] cloned = ArrayUtils.clone((long[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneInt() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((int[])null));
        int[] original = new int[]{5, 8};
        int[] cloned = ArrayUtils.clone((int[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneShort() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((short[])null));
        short[] original = new short[]{1, 4};
        short[] cloned = ArrayUtils.clone((short[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneChar() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((char[])null));
        char[] original = new char[]{'a', '4'};
        char[] cloned = ArrayUtils.clone((char[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneByte() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((byte[])null));
        byte[] original = new byte[]{1, 6};
        byte[] cloned = ArrayUtils.clone((byte[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneDouble() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((double[])null));
        double[] original = new double[]{2.4, 5.7};
        double[] cloned = ArrayUtils.clone((double[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testCloneFloat() {
        Assert.assertEquals(null, (Object)ArrayUtils.clone((float[])null));
        float[] original = new float[]{2.6f, 6.4f};
        float[] cloned = ArrayUtils.clone((float[])original);
        Assert.assertTrue((boolean)Arrays.equals(original, cloned));
        Assert.assertTrue((original != cloned ? 1 : 0) != 0);
    }

    @Test
    public void testNullToEmptyGenericNull() {
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty(null, TestClass[].class);
        Assert.assertTrue((output != null ? 1 : 0) != 0);
        Assert.assertTrue((output.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullToEmptyGenericEmpty() {
        Object[] input = new TestClass[]{};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assert.assertSame((Object)input, (Object)output);
    }

    @Test
    public void testNullToEmptyGeneric() {
        Object[] input = new TestClass[]{new TestClass(), new TestClass()};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assert.assertSame((Object)input, (Object)output);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullToEmptyGenericNullType() {
        Object[] input = new TestClass[]{};
        ArrayUtils.nullToEmpty((Object[])input, null);
    }

    @Test
    public void testNullToEmptyBooleanNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.nullToEmpty((boolean[])null));
    }

    @Test
    public void testNullToEmptyBooleanEmptyArray() throws Exception {
        boolean[] empty = new boolean[]{};
        boolean[] result = ArrayUtils.nullToEmpty((boolean[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyBoolean() {
        boolean[] original = new boolean[]{true, false};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((boolean[])original));
    }

    @Test
    public void testNullToEmptyLongNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.nullToEmpty((long[])null));
    }

    @Test
    public void testNullToEmptyLongEmptyArray() throws Exception {
        long[] empty = new long[]{};
        long[] result = ArrayUtils.nullToEmpty((long[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyLong() {
        long[] original = new long[]{1L, 2L};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((long[])original));
    }

    @Test
    public void testNullToEmptyIntNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.nullToEmpty((int[])null));
    }

    @Test
    public void testNullToEmptyIntEmptyArray() throws Exception {
        int[] empty = new int[]{};
        int[] result = ArrayUtils.nullToEmpty((int[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyInt() {
        int[] original = new int[]{1, 2};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((int[])original));
    }

    @Test
    public void testNullToEmptyShortNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.nullToEmpty((short[])null));
    }

    @Test
    public void testNullToEmptyShortEmptyArray() throws Exception {
        short[] empty = new short[]{};
        short[] result = ArrayUtils.nullToEmpty((short[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyShort() {
        short[] original = new short[]{1, 2};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((short[])original));
    }

    @Test
    public void testNullToEmptyCharNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.nullToEmpty((char[])null));
    }

    @Test
    public void testNullToEmptyCharEmptyArray() throws Exception {
        char[] empty = new char[]{};
        char[] result = ArrayUtils.nullToEmpty((char[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyChar() {
        char[] original = new char[]{'a', 'b'};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((char[])original));
    }

    @Test
    public void testNullToEmptyByteNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.nullToEmpty((byte[])null));
    }

    @Test
    public void testNullToEmptyByteEmptyArray() throws Exception {
        byte[] empty = new byte[]{};
        byte[] result = ArrayUtils.nullToEmpty((byte[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyByte() {
        byte[] original = new byte[]{15, 14};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((byte[])original));
    }

    @Test
    public void testNullToEmptyDoubleNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.nullToEmpty((double[])null));
    }

    @Test
    public void testNullToEmptyDoubleEmptyArray() throws Exception {
        double[] empty = new double[]{};
        double[] result = ArrayUtils.nullToEmpty((double[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyDouble() {
        double[] original = new double[]{1.0, 2.0};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((double[])original));
    }

    @Test
    public void testNullToEmptyFloatNull() throws Exception {
        Assert.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.nullToEmpty((float[])null));
    }

    @Test
    public void testNullToEmptyFloatEmptyArray() throws Exception {
        float[] empty = new float[]{};
        float[] result = ArrayUtils.nullToEmpty((float[])empty);
        Assert.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyFloat() {
        float[] original = new float[]{2.6f, 3.8f};
        Assert.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((float[])original));
    }

    @Test
    public void testNullToEmptyObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Object[])null));
    }

    @Test
    public void testNullToEmptyObjectEmptyArray() throws Exception {
        Object[] empty = new Object[]{};
        Object[] result = ArrayUtils.nullToEmpty((Object[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyObject() {
        Object[] original = new Object[]{Boolean.TRUE, Boolean.FALSE};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Object[])original));
    }

    @Test
    public void testNullToEmptyClassNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ArrayUtils.nullToEmpty((Class[])null));
    }

    @Test
    public void testNullToEmptyClassEmptyArray() throws Exception {
        Class[] empty = new Class[]{};
        Object[] result = ArrayUtils.nullToEmpty((Class[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyClass() {
        Object[] original = new Class[]{Object.class, String.class};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Class[])original));
    }

    @Test
    public void testNullToEmptyStringNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.nullToEmpty((String[])null));
    }

    @Test
    public void testNullToEmptyStringEmptyArray() throws Exception {
        String[] empty = new String[]{};
        Object[] result = ArrayUtils.nullToEmpty((String[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyString() {
        Object[] original = new String[]{"abc", "def"};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((String[])original));
    }

    @Test
    public void testNullToEmptyBooleanObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Boolean[])null));
    }

    @Test
    public void testNullToEmptyBooleanObjectEmptyArray() throws Exception {
        Boolean[] empty = new Boolean[]{};
        Object[] result = ArrayUtils.nullToEmpty((Boolean[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyBooleanObject() {
        Object[] original = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Boolean[])original));
    }

    @Test
    public void testNullToEmptyLongObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Long[])null));
    }

    @Test
    public void testNullToEmptyLongObjectEmptyArray() throws Exception {
        Long[] empty = new Long[]{};
        Object[] result = ArrayUtils.nullToEmpty((Long[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyLongObject() {
        Object[] original = new Long[]{1L, 2L};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Long[])original));
    }

    @Test
    public void testNullToEmptyIntObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Integer[])null));
    }

    @Test
    public void testNullToEmptyIntObjectEmptyArray() throws Exception {
        Integer[] empty = new Integer[]{};
        Object[] result = ArrayUtils.nullToEmpty((Integer[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyIntObject() {
        Object[] original = new Integer[]{1, 2};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Integer[])original));
    }

    @Test
    public void testNullToEmptyShortObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Short[])null));
    }

    @Test
    public void testNullToEmptyShortObjectEmptyArray() throws Exception {
        Short[] empty = new Short[]{};
        Object[] result = ArrayUtils.nullToEmpty((Short[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyShortObject() {
        Object[] original = new Short[]{(short)1, (short)2};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Short[])original));
    }

    @Test
    public void testNUllToEmptyCharObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Character[])null));
    }

    @Test
    public void testNullToEmptyCharObjectEmptyArray() throws Exception {
        Character[] empty = new Character[]{};
        Object[] result = ArrayUtils.nullToEmpty((Character[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyCharObject() {
        Object[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Character[])original));
    }

    @Test
    public void testNullToEmptyByteObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Byte[])null));
    }

    @Test
    public void testNullToEmptyByteObjectEmptyArray() throws Exception {
        Byte[] empty = new Byte[]{};
        Object[] result = ArrayUtils.nullToEmpty((Byte[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyByteObject() {
        Object[] original = new Byte[]{(byte)15, (byte)14};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Byte[])original));
    }

    @Test
    public void testNullToEmptyDoubleObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Double[])null));
    }

    @Test
    public void testNullToEmptyDoubleObjectEmptyArray() throws Exception {
        Double[] empty = new Double[]{};
        Object[] result = ArrayUtils.nullToEmpty((Double[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyDoubleObject() {
        Object[] original = new Double[]{1.0, 2.0};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Double[])original));
    }

    @Test
    public void testNullToEmptyFloatObjectNull() throws Exception {
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Float[])null));
    }

    @Test
    public void testNullToEmptyFloatObjectEmptyArray() throws Exception {
        Float[] empty = new Float[]{};
        Object[] result = ArrayUtils.nullToEmpty((Float[])empty);
        Assert.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])result);
        Assert.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyFloatObject() {
        Object[] original = new Float[]{Float.valueOf(2.6f), Float.valueOf(3.8f)};
        Assert.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Float[])original));
    }

    @Test
    public void testSubarrayObject() {
        Object[] nullArray = null;
        Object[] objectArray = new Object[]{"a", "b", "c", "d", "e", "f"};
        Assert.assertEquals((String)"0 start, mid end", (Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)4)));
        Assert.assertEquals((String)"0 start, length end", (Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)objectArray.length)));
        Assert.assertEquals((String)"mid start, mid end", (Object)"bcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)4)));
        Assert.assertEquals((String)"mid start, length end", (Object)"bcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)objectArray.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (int)1, (int)2)));
        Assert.assertEquals((String)"start > end", (Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)4, (int)2)));
        Assert.assertEquals((String)"start == end", (Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)3, (int)3)));
        Assert.assertEquals((String)"start undershoot, normal end", (Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)33, (int)4)));
        Assert.assertEquals((String)"normal start, end overshoot", (Object)"cdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)2, (int)33)));
        Assert.assertEquals((String)"start undershoot, end overshoot", (Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)12)));
        Object[] dateArray = new java.util.Date[]{new Date(new java.util.Date().getTime()), new java.util.Date(), new java.util.Date(), new java.util.Date(), new java.util.Date()};
        Assert.assertSame((String)"Object type", Object.class, ArrayUtils.subarray((Object[])objectArray, (int)2, (int)4).getClass().getComponentType());
        Assert.assertSame((String)"java.util.Date type", java.util.Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType());
        Assert.assertNotSame((String)"java.sql.Date type", Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType());
        try {
            Date[] dummy = (Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)3);
            Assert.fail((String)"Invalid downcast");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testSubarrayLong() {
        long[] nullArray = null;
        long[] array = new long[]{999910L, 999911L, 999912L, 999913L, 999914L, 999915L};
        long[] leftSubarray = new long[]{999910L, 999911L, 999912L, 999913L};
        long[] midSubarray = new long[]{999911L, 999912L, 999913L, 999914L};
        long[] rightSubarray = new long[]{999912L, 999913L, 999914L, 999915L};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((long[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)8733, (int)4));
        Assert.assertSame((String)"long type", Long.TYPE, ArrayUtils.subarray((long[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayInt() {
        int[] nullArray = null;
        int[] array = new int[]{10, 11, 12, 13, 14, 15};
        int[] leftSubarray = new int[]{10, 11, 12, 13};
        int[] midSubarray = new int[]{11, 12, 13, 14};
        int[] rightSubarray = new int[]{12, 13, 14, 15};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((int[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)8733, (int)4));
        Assert.assertSame((String)"int type", Integer.TYPE, ArrayUtils.subarray((int[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayShort() {
        short[] nullArray = null;
        short[] array = new short[]{10, 11, 12, 13, 14, 15};
        short[] leftSubarray = new short[]{10, 11, 12, 13};
        short[] midSubarray = new short[]{11, 12, 13, 14};
        short[] rightSubarray = new short[]{12, 13, 14, 15};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((short[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)8733, (int)4));
        Assert.assertSame((String)"short type", Short.TYPE, ArrayUtils.subarray((short[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrChar() {
        char[] nullArray = null;
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] leftSubarray = new char[]{'a', 'b', 'c', 'd'};
        char[] midSubarray = new char[]{'b', 'c', 'd', 'e'};
        char[] rightSubarray = new char[]{'c', 'd', 'e', 'f'};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((char[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)8733, (int)4));
        Assert.assertSame((String)"char type", Character.TYPE, ArrayUtils.subarray((char[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayByte() {
        byte[] nullArray = null;
        byte[] array = new byte[]{10, 11, 12, 13, 14, 15};
        byte[] leftSubarray = new byte[]{10, 11, 12, 13};
        byte[] midSubarray = new byte[]{11, 12, 13, 14};
        byte[] rightSubarray = new byte[]{12, 13, 14, 15};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)8733, (int)4));
        Assert.assertSame((String)"byte type", Byte.TYPE, ArrayUtils.subarray((byte[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayDouble() {
        double[] nullArray = null;
        double[] array = new double[]{10.123, 11.234, 12.345, 13.456, 14.567, 15.678};
        double[] leftSubarray = new double[]{10.123, 11.234, 12.345, 13.456};
        double[] midSubarray = new double[]{11.234, 12.345, 13.456, 14.567};
        double[] rightSubarray = new double[]{12.345, 13.456, 14.567, 15.678};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((double[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)8733, (int)4));
        Assert.assertSame((String)"double type", Double.TYPE, ArrayUtils.subarray((double[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayFloat() {
        float[] nullArray = null;
        float[] array = new float[]{10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        float[] leftSubarray = new float[]{10.0f, 11.0f, 12.0f, 13.0f};
        float[] midSubarray = new float[]{11.0f, 12.0f, 13.0f, 14.0f};
        float[] rightSubarray = new float[]{12.0f, 13.0f, 14.0f, 15.0f};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((float[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)8733, (int)4));
        Assert.assertSame((String)"float type", Float.TYPE, ArrayUtils.subarray((float[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSubarrayBoolean() {
        boolean[] nullArray = null;
        boolean[] array = new boolean[]{true, true, false, true, false, true};
        boolean[] leftSubarray = new boolean[]{true, true, false, true};
        boolean[] midSubarray = new boolean[]{true, false, true, false};
        boolean[] rightSubarray = new boolean[]{false, true, false, true};
        Assert.assertTrue((String)"0 start, mid end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)4)));
        Assert.assertTrue((String)"0 start, length end", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)array.length)));
        Assert.assertTrue((String)"mid start, mid end", (boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)1, (int)5)));
        Assert.assertTrue((String)"mid start, length end", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)array.length)));
        Assert.assertNull((String)"null input", (Object)ArrayUtils.subarray(nullArray, (int)0, (int)3));
        Assert.assertEquals((String)"empty array", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2));
        Assert.assertEquals((String)"start > end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)2));
        Assert.assertEquals((String)"start == end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3));
        Assert.assertTrue((String)"start undershoot, normal end", (boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)4)));
        Assert.assertEquals((String)"start overshoot, any end", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)33, (int)4));
        Assert.assertTrue((String)"normal start, end overshoot", (boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)33)));
        Assert.assertTrue((String)"start undershoot, end overshoot", (boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)12)));
        Assert.assertSame((String)"empty array, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2));
        Assert.assertSame((String)"start > end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)1));
        Assert.assertSame((String)"start == end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3));
        Assert.assertSame((String)"start overshoot, any end, object test", (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)8733, (int)4));
        Assert.assertSame((String)"boolean type", Boolean.TYPE, ArrayUtils.subarray((boolean[])array, (int)2, (int)4).getClass().getComponentType());
    }

    @Test
    public void testSameLength() {
        Object[] nullArray = null;
        Object[] emptyArray = new Object[]{};
        Object[] oneArray = new Object[]{"pick"};
        Object[] twoArray = new Object[]{"pick", "stick"};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (Object[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])twoArray));
    }

    @Test
    public void testSameLengthBoolean() {
        boolean[] nullArray = null;
        boolean[] emptyArray = new boolean[]{};
        boolean[] oneArray = new boolean[]{true};
        boolean[] twoArray = new boolean[]{true, false};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])twoArray));
    }

    @Test
    public void testSameLengthLong() {
        long[] nullArray = null;
        long[] emptyArray = new long[]{};
        long[] oneArray = new long[]{0L};
        long[] twoArray = new long[]{0L, 76L};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (long[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])twoArray));
    }

    @Test
    public void testSameLengthInt() {
        int[] nullArray = null;
        int[] emptyArray = new int[]{};
        int[] oneArray = new int[]{4};
        int[] twoArray = new int[]{5, 7};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (int[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])twoArray));
    }

    @Test
    public void testSameLengthShort() {
        short[] nullArray = null;
        short[] emptyArray = new short[]{};
        short[] oneArray = new short[]{4};
        short[] twoArray = new short[]{6, 8};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (short[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])twoArray));
    }

    @Test
    public void testSameLengthChar() {
        char[] nullArray = null;
        char[] emptyArray = new char[]{};
        char[] oneArray = new char[]{'f'};
        char[] twoArray = new char[]{'d', 't'};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (char[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])twoArray));
    }

    @Test
    public void testSameLengthByte() {
        byte[] nullArray = null;
        byte[] emptyArray = new byte[]{};
        byte[] oneArray = new byte[]{3};
        byte[] twoArray = new byte[]{4, 6};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (byte[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])twoArray));
    }

    @Test
    public void testSameLengthDouble() {
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        double[] oneArray = new double[]{1.3};
        double[] twoArray = new double[]{4.5, 6.3};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (double[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])twoArray));
    }

    @Test
    public void testSameLengthFloat() {
        float[] nullArray = null;
        float[] emptyArray = new float[]{};
        float[] oneArray = new float[]{2.5f};
        float[] twoArray = new float[]{6.4f, 5.8f};
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (float[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])twoArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, nullArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])oneArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])twoArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, nullArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])oneArray));
        Assert.assertTrue((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])twoArray));
    }

    @Test
    public void testSameType() {
        try {
            ArrayUtils.isSameType(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ArrayUtils.isSameType(null, (Object)new Object[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ArrayUtils.isSameType((Object)new Object[0], null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)ArrayUtils.isSameType((Object)new Object[0], (Object)new Object[0]));
        Assert.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new Object[0]));
        Assert.assertTrue((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0][0]));
        Assert.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new String[0][0]));
        Assert.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0]));
    }

    @Test
    public void testReverse() {
        StringBuffer str1 = new StringBuffer("pick");
        String str2 = "a";
        String[] str3 = new String[]{"stick"};
        String str4 = "up";
        Object[] array = new Object[]{str1, "a", str3};
        ArrayUtils.reverse((Object[])array);
        Assert.assertEquals((Object)array[0], (Object)str3);
        Assert.assertEquals((Object)array[1], (Object)"a");
        Assert.assertEquals((Object)array[2], (Object)str1);
        array = new Object[]{str1, "a", str3, "up"};
        ArrayUtils.reverse((Object[])array);
        Assert.assertEquals((Object)array[0], (Object)"up");
        Assert.assertEquals((Object)array[1], (Object)str3);
        Assert.assertEquals((Object)array[2], (Object)"a");
        Assert.assertEquals((Object)array[3], (Object)str1);
        array = null;
        ArrayUtils.reverse((Object[])array);
        Assert.assertArrayEquals(null, (Object[])array);
    }

    @Test
    public void testReverseLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array);
        Assert.assertEquals((long)array[0], (long)3L);
        Assert.assertEquals((long)array[1], (long)2L);
        Assert.assertEquals((long)array[2], (long)1L);
        array = null;
        ArrayUtils.reverse((long[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array);
        Assert.assertEquals((long)array[0], (long)3L);
        Assert.assertEquals((long)array[1], (long)2L);
        Assert.assertEquals((long)array[2], (long)1L);
        array = null;
        ArrayUtils.reverse((int[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array);
        Assert.assertEquals((long)array[0], (long)3L);
        Assert.assertEquals((long)array[1], (long)2L);
        Assert.assertEquals((long)array[2], (long)1L);
        array = null;
        ArrayUtils.reverse((short[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseChar() {
        char[] array = new char[]{'a', 'f', 'C'};
        ArrayUtils.reverse((char[])array);
        Assert.assertEquals((long)array[0], (long)67L);
        Assert.assertEquals((long)array[1], (long)102L);
        Assert.assertEquals((long)array[2], (long)97L);
        array = null;
        ArrayUtils.reverse((char[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseByte() {
        byte[] array = new byte[]{2, 3, 4};
        ArrayUtils.reverse((byte[])array);
        Assert.assertEquals((long)array[0], (long)4L);
        Assert.assertEquals((long)array[1], (long)3L);
        Assert.assertEquals((long)array[2], (long)2L);
        array = null;
        ArrayUtils.reverse((byte[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseDouble() {
        double[] array = new double[]{0.3, 0.4, 0.5};
        ArrayUtils.reverse((double[])array);
        Assert.assertEquals((double)array[0], (double)0.5, (double)0.0);
        Assert.assertEquals((double)array[1], (double)0.4, (double)0.0);
        Assert.assertEquals((double)array[2], (double)0.3, (double)0.0);
        array = null;
        ArrayUtils.reverse((double[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseFloat() {
        float[] array = new float[]{0.3f, 0.4f, 0.5f};
        ArrayUtils.reverse((float[])array);
        Assert.assertEquals((float)array[0], (float)0.5f, (float)0.0f);
        Assert.assertEquals((float)array[1], (float)0.4f, (float)0.0f);
        Assert.assertEquals((float)array[2], (float)0.3f, (float)0.0f);
        array = null;
        ArrayUtils.reverse((float[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseBoolean() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseBooleanRange() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)2);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)3);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertTrue((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseByteRange() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)2);
        Assert.assertEquals((long)2L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseCharRange() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)2);
        Assert.assertEquals((long)2L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseDoubleRange() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)2);
        Assert.assertEquals((double)2.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)3);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        array = null;
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseFloatRange() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)2);
        Assert.assertEquals((float)2.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)3);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        array = null;
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseIntRange() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)2);
        Assert.assertEquals((long)2L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseLongRange() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)2);
        Assert.assertEquals((long)2L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseShortRange() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)2);
        Assert.assertEquals((long)2L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object)array);
    }

    @Test
    public void testReverseObjectRange() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)2);
        Assert.assertEquals((Object)"2", (Object)array[0]);
        Assert.assertEquals((Object)"1", (Object)array[1]);
        Assert.assertEquals((Object)"3", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)(array.length + 1000));
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        array = null;
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assert.assertEquals(null, (Object[])array);
    }

    @Test
    public void testSwapChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assert.assertArrayEquals((char[])new char[]{'\u0003', '\u0002', '\u0001'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)0);
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)1, (int)0);
        Assert.assertArrayEquals((char[])new char[]{'\u0002', '\u0001', '\u0003'}, (char[])array);
    }

    @Test
    public void testSwapCharRange() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)3);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapByte() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    public void testSwapNullByteArray() {
        byte[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyByteArray() {
        byte[] array = new byte[]{};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapByteRange() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)3);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
    }

    @Test
    public void testSwapNullFloatArray() {
        float[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyFloatArray() {
        float[] array = new float[]{};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapFloatRange() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[3], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)3);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
    }

    @Test
    public void testSwapDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
    }

    @Test
    public void testSwapNullDoubleArray() {
        double[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyDoubleArray() {
        double[] array = new double[]{};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapDoubleRange() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[3], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)3);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
    }

    @Test
    public void testSwapInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    public void testSwapNullIntArray() {
        int[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyIntArray() {
        int[] array = new int[]{};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapIntRange() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)3, (int)0);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapIntExchangedOffsets() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)1, (int)2);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)1, (int)0, (int)2);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
    }

    @Test
    public void testSwapShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    public void testSwapNullShortArray() {
        short[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyShortArray() {
        short[] array = new short[]{};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapShortRange() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)3, (int)0);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapNullCharArray() {
        char[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyCharArray() {
        char[] array = new char[]{};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    public void testSwapNullLongArray() {
        long[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyLongArray() {
        long[] array = new long[]{};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapLongRange() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)3);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)2, (int)2);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)-1, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapBoolean() {
        boolean[] array = new boolean[]{true, false, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
    }

    @Test
    public void testSwapNullBooleanArray() {
        boolean[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyBooleanArray() {
        boolean[] array = new boolean[]{};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapBooleanRange() {
        boolean[] array = new boolean[]{false, false, true, true};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        Assert.assertFalse((boolean)array[3]);
        array = new boolean[]{false, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)3);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)2, (int)2);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)-1, (int)2);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)-1, (int)2);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
    }

    @Test
    public void testSwapObject() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
    }

    @Test
    public void testSwapNullObjectArray() {
        Object[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assert.assertNull(array);
    }

    @Test
    public void testSwapEmptyObjectArray() {
        Object[] array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
    }

    @Test
    public void testSwapObjectRange() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"4", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        Assert.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)-1, (int)2, (int)3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"4", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        Assert.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)-3, (int)2, (int)3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"4", (Object)array[1]);
        Assert.assertEquals((Object)"5", (Object)array[2]);
        Assert.assertEquals((Object)"2", (Object)array[3]);
        Assert.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)2, (int)-2, (int)3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"4", (Object)array[1]);
        Assert.assertEquals((Object)"5", (Object)array[2]);
        Assert.assertEquals((Object)"2", (Object)array[3]);
        Assert.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assert.assertEquals((long)0L, (long)array.length);
        array = null;
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assert.assertNull((Object)array);
    }

    @Test
    public void testShiftDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1);
        Assert.assertEquals((double)4.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[3], (double)0.0);
        ArrayUtils.shift((double[])array, (int)-1);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[3], (double)0.0);
        ArrayUtils.shift((double[])array, (int)5);
        Assert.assertEquals((double)4.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[3], (double)0.0);
        ArrayUtils.shift((double[])array, (int)-3);
        Assert.assertEquals((double)3.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)1.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[3], (double)0.0);
    }

    @Test
    public void testShiftRangeDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        ArrayUtils.shift((double[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[3], (double)0.0);
        Assert.assertEquals((double)5.0, (double)array[4], (double)0.0);
        ArrayUtils.shift((double[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[3], (double)0.0);
        Assert.assertEquals((double)5.0, (double)array[4], (double)0.0);
    }

    @Test
    public void testShiftRangeNoElemDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[3], (double)0.0);
    }

    @Test
    public void testShiftRangeNullDouble() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftNullDouble() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)4);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[3], (double)0.0);
        ArrayUtils.shift((double[])array, (int)-4);
        Assert.assertEquals((double)1.0, (double)array[0], (double)0.0);
        Assert.assertEquals((double)2.0, (double)array[1], (double)0.0);
        Assert.assertEquals((double)3.0, (double)array[2], (double)0.0);
        Assert.assertEquals((double)4.0, (double)array[3], (double)0.0);
    }

    @Test
    public void testShiftFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1);
        Assert.assertEquals((float)4.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[3], (float)0.0f);
        ArrayUtils.shift((float[])array, (int)-1);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[3], (float)0.0f);
        ArrayUtils.shift((float[])array, (int)5);
        Assert.assertEquals((float)4.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[3], (float)0.0f);
        ArrayUtils.shift((float[])array, (int)-3);
        Assert.assertEquals((float)3.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[3], (float)0.0f);
    }

    @Test
    public void testShiftRangeFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[3], (float)0.0f);
        Assert.assertEquals((float)5.0f, (float)array[4], (float)0.0f);
        ArrayUtils.shift((float[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[3], (float)0.0f);
        Assert.assertEquals((float)5.0f, (float)array[4], (float)0.0f);
    }

    @Test
    public void testShiftRangeNoElemFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[3], (float)0.0f);
    }

    @Test
    public void testShiftRangeNullFloat() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftNullFloat() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)4);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[3], (float)0.0f);
        ArrayUtils.shift((float[])array, (int)-4);
        Assert.assertEquals((float)1.0f, (float)array[0], (float)0.0f);
        Assert.assertEquals((float)2.0f, (float)array[1], (float)0.0f);
        Assert.assertEquals((float)3.0f, (float)array[2], (float)0.0f);
        Assert.assertEquals((float)4.0f, (float)array[3], (float)0.0f);
    }

    @Test
    public void testShiftShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((short[])array, (int)-1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((short[])array, (int)5);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((short[])array, (int)-3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)2);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)5L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
        Assert.assertEquals((long)3L, (long)array[4]);
    }

    @Test
    public void testShiftNullShort() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftRangeShort() {
        short[] array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)3L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((short[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)4L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNullShort() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((short[])array, (int)-4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((byte[])array, (int)-1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((byte[])array, (int)5);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((byte[])array, (int)-3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    public void testShiftRangeByte() {
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((byte[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)3L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((byte[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)4L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNullByte() {
        byte[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((byte[])array, (int)-4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((char[])array, (int)-1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((char[])array, (int)5);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((char[])array, (int)-3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    public void testShiftRangeChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005'};
        ArrayUtils.shift((char[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)3L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((char[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)4L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNullChar() {
        char[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((char[])array, (int)-4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)5);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    public void testShiftRangeLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        ArrayUtils.shift((long[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)3L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((long[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)4L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNullLong() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftNullLong() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((int[])array, (int)-1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((int[])array, (int)5);
        Assert.assertEquals((long)4L, (long)array[0]);
        Assert.assertEquals((long)1L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((int[])array, (int)-3);
        Assert.assertEquals((long)3L, (long)array[0]);
        Assert.assertEquals((long)4L, (long)array[1]);
        Assert.assertEquals((long)1L, (long)array[2]);
        Assert.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    public void testShiftNullInt() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftRangeInt() {
        int[] array = new int[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((int[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)3L, (long)array[1]);
        Assert.assertEquals((long)2L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((int[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)4L, (long)array[2]);
        Assert.assertEquals((long)3L, (long)array[3]);
        Assert.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNullInt() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((int[])array, (int)-4);
        Assert.assertEquals((long)1L, (long)array[0]);
        Assert.assertEquals((long)2L, (long)array[1]);
        Assert.assertEquals((long)3L, (long)array[2]);
        Assert.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1);
        Assert.assertEquals((Object)"4", (Object)array[0]);
        Assert.assertEquals((Object)"1", (Object)array[1]);
        Assert.assertEquals((Object)"2", (Object)array[2]);
        Assert.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-1);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"3", (Object)array[2]);
        Assert.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)5);
        Assert.assertEquals((Object)"4", (Object)array[0]);
        Assert.assertEquals((Object)"1", (Object)array[1]);
        Assert.assertEquals((Object)"2", (Object)array[2]);
        Assert.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-3);
        Assert.assertEquals((Object)"3", (Object)array[0]);
        Assert.assertEquals((Object)"4", (Object)array[1]);
        Assert.assertEquals((Object)"1", (Object)array[2]);
        Assert.assertEquals((Object)"2", (Object)array[3]);
    }

    @Test
    public void testShiftNullObject() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftRangeObject() {
        Object[] array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.shift((Object[])array, (int)1, (int)3, (int)1);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"3", (Object)array[1]);
        Assert.assertEquals((Object)"2", (Object)array[2]);
        Assert.assertEquals((Object)"4", (Object)array[3]);
        Assert.assertEquals((Object)"5", (Object)array[4]);
        ArrayUtils.shift((Object[])array, (int)1, (int)4, (int)2);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"4", (Object)array[2]);
        Assert.assertEquals((Object)"3", (Object)array[3]);
        Assert.assertEquals((Object)"5", (Object)array[4]);
    }

    @Test
    public void testShiftRangeNoElemObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1, (int)1, (int)1);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"3", (Object)array[2]);
        Assert.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    public void testShiftRangeNullObject() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testShiftAllObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)4);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"3", (Object)array[2]);
        Assert.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-4);
        Assert.assertEquals((Object)"1", (Object)array[0]);
        Assert.assertEquals((Object)"2", (Object)array[1]);
        Assert.assertEquals((Object)"3", (Object)array[2]);
        Assert.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    public void testShiftBoolean() {
        boolean[] array = new boolean[]{true, true, false, false};
        ArrayUtils.shift((boolean[])array, (int)1);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        Assert.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-1);
        Assert.assertTrue((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertFalse((boolean)array[2]);
        Assert.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)5);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertTrue((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        Assert.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-3);
        Assert.assertFalse((boolean)array[0]);
        Assert.assertFalse((boolean)array[1]);
        Assert.assertTrue((boolean)array[2]);
        Assert.assertTrue((boolean)array[3]);
    }

    @Test
    public void testShiftNullBoolean() {
        boolean[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assert.assertNull(array);
    }

    @Test
    public void testIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(null, null));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(null, (Object)"0"));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0"));
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((Object[])array, (Object)"0"));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((Object[])array, (Object)"1"));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((Object[])array, (Object)"2"));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((Object[])array, (Object)"3"));
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((Object[])array, null));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(null, null, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0", (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(null, (Object)"0", (int)2));
        Assert.assertEquals((long)5L, (long)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])array, (Object)"1", (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((Object[])array, (Object)"2", (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((Object[])array, (Object)"3", (int)2));
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((Object[])array, null, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])array, (Object)"notInArray", (int)2));
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((Object[])array, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])array, null, (int)8));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)8));
    }

    @Test
    public void testLastIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(null, null));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(null, (Object)"0"));
        Assert.assertEquals((long)5L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"0"));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"1"));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"2"));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"3"));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((Object[])array, null));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testLastIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(null, null, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(null, (Object)"0", (int)2));
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"1", (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"2", (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)-1));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((Object[])array, null, (int)5));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, null, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray", (int)5));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((Object[])array, null, (int)-1));
        Assert.assertEquals((long)5L, (long)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)88));
    }

    @Test
    public void testContains() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assert.assertFalse((boolean)ArrayUtils.contains(null, null));
        Assert.assertFalse((boolean)ArrayUtils.contains(null, (Object)"1"));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"0"));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"1"));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"2"));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"3"));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, null));
        Assert.assertFalse((boolean)ArrayUtils.contains((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testContains_LANG_1261() {
        class LANG1261ChildObject
        extends LANG1261ParentObject {
            LANG1261ChildObject() {
                class LANG1261ParentObject {
                    LANG1261ParentObject() {
                    }

                    public boolean equals(Object o) {
                        return true;
                    }
                }
            }
        }
        Object[] array = new LANG1261ChildObject[]{new LANG1261ChildObject()};
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)new LANG1261ParentObject()));
    }

    @Test
    public void testIndexOfLong() {
        long[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((long[])array, (long)0L));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((long[])array, (long)1L));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((long[])array, (long)2L));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((long[])array, (long)3L));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((long[])array, (long)99L));
    }

    @Test
    public void testIndexOfLongWithStartIndex() {
        long[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((long[])array, (long)0L, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((long[])array, (long)1L, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((long[])array, (long)2L, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((long[])array, (long)3L, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((long[])array, (long)3L, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((long[])array, (long)99L, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((long[])array, (long)0L, (int)6));
    }

    @Test
    public void testLastIndexOfLong() {
        long[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((long[])array, (long)0L));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)1L));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((long[])array, (long)2L));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((long[])array, (long)3L));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)99L));
    }

    @Test
    public void testLastIndexOfLongWithStartIndex() {
        long[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)1L, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((long[])array, (long)2L, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((long[])array, (long)99L, (int)4));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)88));
    }

    @Test
    public void testContainsLong() {
        long[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (long)1L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assert.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)0L));
        Assert.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)1L));
        Assert.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)2L));
        Assert.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)3L));
        Assert.assertFalse((boolean)ArrayUtils.contains((long[])array, (long)99L));
    }

    @Test
    public void testIndexOfInt() {
        int[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((int[])array, (int)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((int[])array, (int)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((int[])array, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((int[])array, (int)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((int[])array, (int)99));
    }

    @Test
    public void testIndexOfIntWithStartIndex() {
        int[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((int[])array, (int)0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((int[])array, (int)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((int[])array, (int)2, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((int[])array, (int)3, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((int[])array, (int)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((int[])array, (int)99, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((int[])array, (int)0, (int)6));
    }

    @Test
    public void testLastIndexOfInt() {
        int[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((int[])array, (int)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((int[])array, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((int[])array, (int)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)99));
    }

    @Test
    public void testLastIndexOfIntWithStartIndex() {
        int[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((int[])array, (int)2, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((int[])array, (int)99));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)88));
    }

    @Test
    public void testContainsInt() {
        int[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (int)1));
        array = new int[]{0, 1, 2, 3, 0};
        Assert.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)0));
        Assert.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)1));
        Assert.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)2));
        Assert.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)3));
        Assert.assertFalse((boolean)ArrayUtils.contains((int[])array, (int)99));
    }

    @Test
    public void testIndexOfShort() {
        short[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((short[])array, (short)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((short[])array, (short)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((short[])array, (short)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((short[])array, (short)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((short[])array, (short)99));
    }

    @Test
    public void testIndexOfShortWithStartIndex() {
        short[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((short[])array, (short)0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((short[])array, (short)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((short[])array, (short)2, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((short[])array, (short)3, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((short[])array, (short)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((short[])array, (short)99, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((short[])array, (short)0, (int)6));
    }

    @Test
    public void testLastIndexOfShort() {
        short[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((short[])array, (short)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((short[])array, (short)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((short[])array, (short)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)99));
    }

    @Test
    public void testLastIndexOfShortWithStartIndex() {
        short[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((short[])array, (short)2, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((short[])array, (short)99));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)88));
    }

    @Test
    public void testContainsShort() {
        short[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (short)1));
        array = new short[]{0, 1, 2, 3, 0};
        Assert.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)0));
        Assert.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)1));
        Assert.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)2));
        Assert.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)3));
        Assert.assertFalse((boolean)ArrayUtils.contains((short[])array, (short)99));
    }

    @Test
    public void testIndexOfChar() {
        char[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((char[])array, (char)'a'));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((char[])array, (char)'b'));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((char[])array, (char)'c'));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((char[])array, (char)'d'));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((char[])array, (char)'e'));
    }

    @Test
    public void testIndexOfCharWithStartIndex() {
        char[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((char[])array, (char)'a', (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((char[])array, (char)'b', (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((char[])array, (char)'c', (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((char[])array, (char)'d', (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((char[])array, (char)'d', (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((char[])array, (char)'e', (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((char[])array, (char)'a', (int)6));
    }

    @Test
    public void testLastIndexOfChar() {
        char[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'a'));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'b'));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'c'));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'d'));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
    }

    @Test
    public void testLastIndexOfCharWithStartIndex() {
        char[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'b', (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'c', (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)88));
    }

    @Test
    public void testContainsChar() {
        char[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (char)'b'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assert.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'a'));
        Assert.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'b'));
        Assert.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'c'));
        Assert.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'d'));
        Assert.assertFalse((boolean)ArrayUtils.contains((char[])array, (char)'e'));
    }

    @Test
    public void testIndexOfByte() {
        byte[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((byte[])array, (byte)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((byte[])array, (byte)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((byte[])array, (byte)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((byte[])array, (byte)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((byte[])array, (byte)99));
    }

    @Test
    public void testIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((byte[])array, (byte)0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((byte[])array, (byte)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((byte[])array, (byte)2, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((byte[])array, (byte)3, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((byte[])array, (byte)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((byte[])array, (byte)99, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((byte[])array, (byte)0, (int)6));
    }

    @Test
    public void testLastIndexOfByte() {
        byte[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)1));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)3));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
    }

    @Test
    public void testLastIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)1, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)2, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)88));
    }

    @Test
    public void testContainsByte() {
        byte[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (byte)1));
        array = new byte[]{0, 1, 2, 3, 0};
        Assert.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)0));
        Assert.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)1));
        Assert.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)2));
        Assert.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)3));
        Assert.assertFalse((boolean)ArrayUtils.contains((byte[])array, (byte)99));
    }

    @Test
    public void testIndexOfDouble() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((double[])array, (double)0.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((double[])array, (double)1.0));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((double[])array, (double)2.0));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)3.0));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)3.0, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)99.0));
    }

    @Test
    public void testIndexOfDoubleTolerance() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.3));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((double[])array, (double)2.2, (double)0.35));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)4.15, (double)2.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    public void testIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)1.0, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((double[])array, (double)2.0, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)3.0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)99.0, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)6));
    }

    @Test
    public void testIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)0, (double)0.3));
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((double[])array, (double)2.2, (int)0, (double)0.35));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)4.15, (int)0, (double)2.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((double[])array, (double)4.15, (int)-1, (double)2.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)-300, (double)1.0E-4));
    }

    @Test
    public void testLastIndexOfDouble() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)1.0));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((double[])array, (double)2.0));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((double[])array, (double)3.0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
    }

    @Test
    public void testLastIndexOfDoubleTolerance() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.3));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (double)0.35));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (double)2.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    public void testLastIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((double[])array, (double)2.0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)88));
    }

    @Test
    public void testLastIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{3.0};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (int)3, (double)0.35));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)array.length, (double)2.0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (int)array.length, (double)1.0E-4));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)-200, (double)2.0));
    }

    @Test
    public void testContainsDouble() {
        double[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)0.0));
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)1.0));
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.0));
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)3.0));
        Assert.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)99.0));
    }

    @Test
    public void testContainsDoubleTolerance() {
        double[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assert.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)4.0, (double)0.33));
        Assert.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.49));
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.5));
        Assert.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.51));
    }

    @Test
    public void testIndexOfFloat() {
        float[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (float)0.0f));
        array = new float[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((float[])array, (float)0.0f));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((float[])array, (float)1.0f));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((float[])array, (float)2.0f));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((float[])array, (float)3.0f));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)99.0f));
    }

    @Test
    public void testIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assert.assertEquals((long)4L, (long)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)1.0f, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((float[])array, (float)2.0f, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)2));
        Assert.assertEquals((long)3L, (long)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)99.0f, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)6));
    }

    @Test
    public void testLastIndexOfFloat() {
        float[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (float)0.0f));
        array = new float[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)1.0f));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((float[])array, (float)2.0f));
        Assert.assertEquals((long)3L, (long)ArrayUtils.lastIndexOf((float[])array, (float)3.0f));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
    }

    @Test
    public void testLastIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)1.0f, (int)2));
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((float[])array, (float)2.0f, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)-1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
        Assert.assertEquals((long)4L, (long)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)88));
    }

    @Test
    public void testContainsFloat() {
        float[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (float)1.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assert.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)0.0f));
        Assert.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)1.0f));
        Assert.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)2.0f));
        Assert.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)3.0f));
        Assert.assertFalse((boolean)ArrayUtils.contains((float[])array, (float)99.0f));
    }

    @Test
    public void testIndexOfBoolean() {
        boolean[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (boolean)true));
        array = new boolean[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assert.assertEquals((long)0L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false));
    }

    @Test
    public void testIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assert.assertEquals((long)2L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)1));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)2));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assert.assertEquals((long)1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
        array = new boolean[]{true, true};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
    }

    @Test
    public void testLastIndexOfBoolean() {
        boolean[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (boolean)true));
        array = new boolean[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
    }

    @Test
    public void testLastIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assert.assertEquals((long)2L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        Assert.assertEquals((long)0L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)1));
        Assert.assertEquals((long)1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
        array = new boolean[]{true, true};
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assert.assertEquals((long)-1L, (long)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
    }

    @Test
    public void testContainsBoolean() {
        boolean[] array = null;
        Assert.assertFalse((boolean)ArrayUtils.contains(array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assert.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assert.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assert.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assert.assertFalse((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
    }

    @Test
    public void testToPrimitive_boolean() {
        Boolean[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0]));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE})));
        try {
            ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_boolean_boolean() {
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(null, (boolean)false));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0], (boolean)false));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, true}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (boolean)false)));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false, false}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)false)));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, false}, ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)true)));
    }

    @Test
    public void testToObject_boolean() {
        boolean[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)ArrayUtils.toObject((boolean[])new boolean[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (Object[])ArrayUtils.toObject((boolean[])new boolean[]{true, false, true})));
    }

    @Test
    public void testToPrimitive_char() {
        Character[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0]));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')})));
        try {
            ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_char_char() {
        Character[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b, (char)'\u0000'));
        Assert.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0], (char)'\u0000'));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')}, (char)'\u0000')));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\uffff', '0'}, ArrayUtils.toPrimitive((Character[])new Character[]{new Character('\u0000'), null, new Character('0')}, (char)'\uffff')));
    }

    @Test
    public void testToObject_char() {
        char[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((char[])new char[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Character[]{new Character('\u0000'), new Character('\uffff'), new Character('0')}, (Object[])ArrayUtils.toObject((char[])new char[]{'\u0000', '\uffff', '0'})));
    }

    @Test
    public void testToPrimitive_byte() {
        Byte[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0]));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127})));
        try {
            ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_byte_byte() {
        Byte[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b, (byte)-128));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0], (byte)1));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (byte)-128)));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{-128, 127, 127}, ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null, (byte)127}, (byte)127)));
    }

    @Test
    public void testToObject_byte() {
        byte[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((byte[])new byte[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (Object[])ArrayUtils.toObject((byte[])new byte[]{-128, 127, 127})));
    }

    @Test
    public void testToPrimitive_short() {
        Short[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0]));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009})));
        try {
            ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_short_short() {
        Short[] s = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(s, (short)Short.MIN_VALUE));
        Assert.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0], (short)Short.MIN_VALUE));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (short)Short.MIN_VALUE)));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null, (short)-27009}, (short)Short.MAX_VALUE)));
    }

    @Test
    public void testToObject_short() {
        short[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((short[])new short[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (Object[])ArrayUtils.toObject((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009})));
    }

    @Test
    public void testToPrimitive_int() {
        Integer[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999})));
        try {
            ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_int_int() {
        Long[] l = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (long)Integer.MIN_VALUE));
        Assert.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0], (int)1));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int)1)));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null, 9999999}, (int)Integer.MAX_VALUE)));
    }

    @Test
    public void testToPrimitive_intNull() {
        Integer[] iArray = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(iArray, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testToObject_int() {
        int[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((int[])new int[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (Object[])ArrayUtils.toObject((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999})));
    }

    @Test
    public void testToPrimitive_long() {
        Long[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0]));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L})));
        try {
            ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_long_long() {
        Long[] l = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (long)Long.MIN_VALUE));
        Assert.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0], (long)1L));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long)1L)));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null, 9999999L}, (long)Long.MAX_VALUE)));
    }

    @Test
    public void testToObject_long() {
        long[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)ArrayUtils.toObject((long[])new long[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (Object[])ArrayUtils.toObject((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L})));
    }

    @Test
    public void testToPrimitive_float() {
        Float[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0]));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)})));
        try {
            ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_float_float() {
        Float[] l = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (float)Float.MIN_VALUE));
        Assert.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0], (float)1.0f));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (float)1.0f)));
        Assert.assertTrue((boolean)Arrays.equals(new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null, Float.valueOf(9999999.0f)}, (float)Float.MAX_VALUE)));
    }

    @Test
    public void testToObject_float() {
        float[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((float[])new float[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (Object[])ArrayUtils.toObject((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f})));
    }

    @Test
    public void testToPrimitive_double() {
        Double[] b = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0]));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0})));
        try {
            ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null});
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToPrimitive_double_double() {
        Double[] l = null;
        Assert.assertEquals(null, (Object)ArrayUtils.toPrimitive(l, (double)Double.MIN_VALUE));
        Assert.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0], (double)1.0));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double)1.0)));
        Assert.assertTrue((boolean)Arrays.equals(new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, null, 9999999.0}, (double)Double.MAX_VALUE)));
    }

    @Test
    public void testToObject_double() {
        double[] b = null;
        Assert.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assert.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((double[])new double[0]));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (Object[])ArrayUtils.toObject((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0})));
    }

    @Test
    public void testIsEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((Object[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((Object[])emptyArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((Object[])notEmptyArray));
    }

    @Test
    public void testIsEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((long[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((long[])emptyLongArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((int[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((int[])emptyIntArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((short[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((short[])emptyShortArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((char[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((char[])emptyCharArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((byte[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((byte[])emptyByteArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((double[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((double[])emptyDoubleArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((float[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((float[])emptyFloatArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])null));
        Assert.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])emptyBooleanArray));
        Assert.assertFalse((boolean)ArrayUtils.isEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    public void testIsNotEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])emptyArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((Object[])notEmptyArray));
    }

    @Test
    public void testIsNotEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])emptyLongArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])emptyIntArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])emptyShortArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])emptyCharArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])emptyByteArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])emptyDoubleArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])emptyFloatArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])null));
        Assert.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])emptyBooleanArray));
        Assert.assertTrue((boolean)ArrayUtils.isNotEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    public void testGetLength() {
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Object[] emptyObjectArray = new Object[]{};
        Object[] notEmptyObjectArray = new Object[]{"aValue"};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyObjectArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyObjectArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyIntArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyShortArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyCharArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyByteArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyDoubleArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyFloatArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength(null));
        Assert.assertEquals((long)0L, (long)ArrayUtils.getLength((Object)emptyBooleanArray));
        Assert.assertEquals((long)1L, (long)ArrayUtils.getLength((Object)notEmptyBooleanArray));
        try {
            ArrayUtils.getLength((Object)"notAnArray");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsSorted() {
        Comparable[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new Integer[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 2, 3};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 3, 2};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((Comparable[])array));
    }

    @Test
    public void testIsSortedComparator() {
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        };
        Object[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array, (Comparator)c));
        array = new Integer[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, (Comparator)c));
        array = new Integer[]{3, 2, 1};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, (Comparator)c));
        array = new Integer[]{1, 3, 2};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((Object[])array, (Comparator)c));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSortedNullComparator() throws Exception {
        ArrayUtils.isSorted(null, null);
    }

    @Test
    public void testIsSortedInt() {
        int[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new int[]{1};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 2, 3};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 3, 2};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((int[])array));
    }

    @Test
    public void testIsSortedFloat() {
        float[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new float[]{0.0f};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.0f, 0.1f, 0.2f};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.2f, 0.1f, 0.0f};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((float[])array));
    }

    @Test
    public void testIsSortedLong() {
        long[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new long[]{0L};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 0L, 1L};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 1L, 0L};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((long[])array));
    }

    @Test
    public void testIsSortedDouble() {
        double[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new double[]{0.0};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.0, 0.1, 0.2};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.2, 0.1, 0.0};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((double[])array));
    }

    @Test
    public void testIsSortedChar() {
        char[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new char[]{'a'};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'b', 'c'};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'c', 'b'};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((char[])array));
    }

    @Test
    public void testIsSortedByte() {
        byte[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new byte[]{16};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 32, 48};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 48, 32};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((byte[])array));
    }

    @Test
    public void testIsSortedShort() {
        short[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new short[]{0};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 0, 1};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 1, 0};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((short[])array));
    }

    @Test
    public void testIsSortedBool() {
        boolean[] array = null;
        Assert.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new boolean[]{true};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{false, true};
        Assert.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{true, false};
        Assert.assertFalse((boolean)ArrayUtils.isSorted((boolean[])array));
    }

    @Test
    public void testCreatePrimitiveArray() {
        Assert.assertNull((Object)ArrayUtils.toPrimitive((Object)null));
        Assert.assertArrayEquals((int[])new int[0], (int[])ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assert.assertArrayEquals((short[])new short[]{2}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)2}));
        Assert.assertArrayEquals((long[])new long[]{2L, 3L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{2L, 3L}));
        Assert.assertArrayEquals((float[])new float[]{3.14f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(3.14f)}), (float)0.1f);
        Assert.assertArrayEquals((double[])new double[]{2.718}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{2.718}), (double)0.1);
    }

    @Test
    public void testToStringArray_array() {
        Assert.assertNull((Object)ArrayUtils.toStringArray(null));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0]));
        Object[] array = new Object[]{1, 2, 3, "array", "test"};
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3", "array", "test"}, (Object[])ArrayUtils.toStringArray((Object[])array));
        try {
            ArrayUtils.toStringArray((Object[])new Object[]{null});
            Assert.fail((String)"NullPointerException expected!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testToStringArray_array_string() {
        Assert.assertNull((Object)ArrayUtils.toStringArray(null, (String)""));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0], (String)""));
        Object[] array = new Object[]{1, null, "test"};
        Assert.assertArrayEquals((Object[])new String[]{"1", "valueForNullElements", "test"}, (Object[])ArrayUtils.toStringArray((Object[])array, (String)"valueForNullElements"));
    }

    @Test
    public void testShuffle() {
        Object[] array1 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        Object[] array2 = (String[])ArrayUtils.clone((Object[])array1);
        ArrayUtils.shuffle((Object[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (Object element : array2) {
            Assert.assertTrue((String)("Element " + (String)element + " not found"), (boolean)ArrayUtils.contains((Object[])array1, (Object)element));
        }
    }

    @Test
    public void testShuffleBoolean() {
        boolean[] array1 = new boolean[]{true, false, true, true, false, false, true, false, false, true};
        boolean[] array2 = ArrayUtils.clone((boolean[])array1);
        ArrayUtils.shuffle((boolean[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        Assert.assertEquals((long)5L, (long)ArrayUtils.removeAllOccurences((boolean[])array1, (boolean)true).length);
    }

    @Test
    public void testShuffleByte() {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] array2 = ArrayUtils.clone((byte[])array1);
        ArrayUtils.shuffle((byte[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (byte element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((byte[])array1, (byte)element));
        }
    }

    @Test
    public void testShuffleChar() {
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n'};
        char[] array2 = ArrayUtils.clone((char[])array1);
        ArrayUtils.shuffle((char[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (char element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((char[])array1, (char)element));
        }
    }

    @Test
    public void testShuffleShort() {
        short[] array1 = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        short[] array2 = ArrayUtils.clone((short[])array1);
        ArrayUtils.shuffle((short[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (short element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((short[])array1, (short)element));
        }
    }

    @Test
    public void testShuffleInt() {
        int[] array1 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int[] array2 = ArrayUtils.clone((int[])array1);
        ArrayUtils.shuffle((int[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (int element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((int[])array1, (int)element));
        }
    }

    @Test
    public void testShuffleLong() {
        long[] array1 = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        long[] array2 = ArrayUtils.clone((long[])array1);
        ArrayUtils.shuffle((long[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (long element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((long[])array1, (long)element));
        }
    }

    @Test
    public void testShuffleFloat() {
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
        float[] array2 = ArrayUtils.clone((float[])array1);
        ArrayUtils.shuffle((float[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (float element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((float[])array1, (float)element));
        }
    }

    @Test
    public void testShuffleDouble() {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] array2 = ArrayUtils.clone((double[])array1);
        ArrayUtils.shuffle((double[])array1);
        Assert.assertFalse((boolean)Arrays.equals(array1, array2));
        for (double element : array2) {
            Assert.assertTrue((String)("Element " + element + " not found"), (boolean)ArrayUtils.contains((double[])array1, (double)element));
        }
    }

    private class TestClass {
        private TestClass() {
        }
    }
}

