/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharUtilsTest {
    private static final Character CHARACTER_A = new Character('A');
    private static final Character CHARACTER_B = new Character('B');
    private static final char CHAR_COPY = '\u00a9';

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new CharUtils());
        Constructor<?>[] cons = CharUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    @Test
    public void testToCharacterObject_char() {
        Character ch2;
        Character ch;
        int i;
        Assert.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((char)'a'));
        Assert.assertSame((Object)CharUtils.toCharacterObject((char)'a'), (Object)CharUtils.toCharacterObject((char)'a'));
        for (i = 0; i < 128; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            Assert.assertSame((Object)ch, (Object)ch2);
            Assert.assertEquals((long)i, (long)ch.charValue());
        }
        for (i = 128; i < 196; ++i) {
            ch = CharUtils.toCharacterObject((char)((char)i));
            ch2 = CharUtils.toCharacterObject((char)((char)i));
            Assert.assertEquals((Object)ch, (Object)ch2);
            Assert.assertTrue((ch != ch2 ? 1 : 0) != 0);
            Assert.assertEquals((long)i, (long)ch.charValue());
            Assert.assertEquals((long)i, (long)ch2.charValue());
        }
        Assert.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((char)'a'));
    }

    @Test
    public void testToCharacterObject_String() {
        Assert.assertEquals(null, (Object)CharUtils.toCharacterObject(null));
        Assert.assertEquals(null, (Object)CharUtils.toCharacterObject((String)""));
        Assert.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((String)"a"));
        Assert.assertEquals((Object)new Character('a'), (Object)CharUtils.toCharacterObject((String)"abc"));
        Assert.assertSame((Object)CharUtils.toCharacterObject((String)"a"), (Object)CharUtils.toCharacterObject((String)"a"));
    }

    @Test
    public void testToChar_Character() {
        Assert.assertEquals((long)65L, (long)CharUtils.toChar((Character)CHARACTER_A));
        Assert.assertEquals((long)66L, (long)CharUtils.toChar((Character)CHARACTER_B));
        try {
            CharUtils.toChar((Character)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToChar_Character_char() {
        Assert.assertEquals((long)65L, (long)CharUtils.toChar((Character)CHARACTER_A, (char)'X'));
        Assert.assertEquals((long)66L, (long)CharUtils.toChar((Character)CHARACTER_B, (char)'X'));
        Assert.assertEquals((long)88L, (long)CharUtils.toChar((Character)null, (char)'X'));
    }

    @Test
    public void testToChar_String() {
        Assert.assertEquals((long)65L, (long)CharUtils.toChar((String)"A"));
        Assert.assertEquals((long)66L, (long)CharUtils.toChar((String)"BA"));
        try {
            CharUtils.toChar((String)null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CharUtils.toChar((String)"");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToChar_String_char() {
        Assert.assertEquals((long)65L, (long)CharUtils.toChar((String)"A", (char)'X'));
        Assert.assertEquals((long)66L, (long)CharUtils.toChar((String)"BA", (char)'X'));
        Assert.assertEquals((long)88L, (long)CharUtils.toChar((String)"", (char)'X'));
        Assert.assertEquals((long)88L, (long)CharUtils.toChar((String)null, (char)'X'));
    }

    @Test
    public void testToIntValue_char() {
        Assert.assertEquals((long)0L, (long)CharUtils.toIntValue((char)'0'));
        Assert.assertEquals((long)1L, (long)CharUtils.toIntValue((char)'1'));
        Assert.assertEquals((long)2L, (long)CharUtils.toIntValue((char)'2'));
        Assert.assertEquals((long)3L, (long)CharUtils.toIntValue((char)'3'));
        Assert.assertEquals((long)4L, (long)CharUtils.toIntValue((char)'4'));
        Assert.assertEquals((long)5L, (long)CharUtils.toIntValue((char)'5'));
        Assert.assertEquals((long)6L, (long)CharUtils.toIntValue((char)'6'));
        Assert.assertEquals((long)7L, (long)CharUtils.toIntValue((char)'7'));
        Assert.assertEquals((long)8L, (long)CharUtils.toIntValue((char)'8'));
        Assert.assertEquals((long)9L, (long)CharUtils.toIntValue((char)'9'));
        try {
            CharUtils.toIntValue((char)'a');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToIntValue_char_int() {
        Assert.assertEquals((long)0L, (long)CharUtils.toIntValue((char)'0', (int)-1));
        Assert.assertEquals((long)3L, (long)CharUtils.toIntValue((char)'3', (int)-1));
        Assert.assertEquals((long)-1L, (long)CharUtils.toIntValue((char)'a', (int)-1));
    }

    @Test
    public void testToIntValue_Character() {
        Assert.assertEquals((long)0L, (long)CharUtils.toIntValue((Character)new Character('0')));
        Assert.assertEquals((long)3L, (long)CharUtils.toIntValue((Character)new Character('3')));
        try {
            CharUtils.toIntValue(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CharUtils.toIntValue((Character)CHARACTER_A);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToIntValue_Character_int() {
        Assert.assertEquals((long)0L, (long)CharUtils.toIntValue((Character)new Character('0'), (int)-1));
        Assert.assertEquals((long)3L, (long)CharUtils.toIntValue((Character)new Character('3'), (int)-1));
        Assert.assertEquals((long)-1L, (long)CharUtils.toIntValue((Character)new Character('A'), (int)-1));
        Assert.assertEquals((long)-1L, (long)CharUtils.toIntValue(null, (int)-1));
    }

    @Test
    public void testToString_char() {
        String str2;
        String str;
        int i;
        Assert.assertEquals((Object)"a", (Object)CharUtils.toString((char)'a'));
        Assert.assertSame((Object)CharUtils.toString((char)'a'), (Object)CharUtils.toString((char)'a'));
        for (i = 0; i < 128; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            Assert.assertSame((Object)str, (Object)str2);
            Assert.assertEquals((long)1L, (long)str.length());
            Assert.assertEquals((long)i, (long)str.charAt(0));
        }
        for (i = 128; i < 196; ++i) {
            str = CharUtils.toString((char)((char)i));
            str2 = CharUtils.toString((char)((char)i));
            Assert.assertEquals((Object)str, (Object)str2);
            Assert.assertTrue((str != str2 ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)str.length());
            Assert.assertEquals((long)i, (long)str.charAt(0));
            Assert.assertEquals((long)1L, (long)str2.length());
            Assert.assertEquals((long)i, (long)str2.charAt(0));
        }
    }

    @Test
    public void testToString_Character() {
        Assert.assertEquals(null, (Object)CharUtils.toString(null));
        Assert.assertEquals((Object)"A", (Object)CharUtils.toString((Character)CHARACTER_A));
        Assert.assertSame((Object)CharUtils.toString((Character)CHARACTER_A), (Object)CharUtils.toString((Character)CHARACTER_A));
    }

    @Test
    public void testToUnicodeEscaped_char() {
        Assert.assertEquals((Object)"\\u0041", (Object)CharUtils.unicodeEscaped((char)'A'));
        Assert.assertEquals((Object)"\\u004c", (Object)CharUtils.unicodeEscaped((char)'L'));
        for (int i = 0; i < 196; ++i) {
            String str = CharUtils.unicodeEscaped((char)((char)i));
            Assert.assertEquals((long)6L, (long)str.length());
            int val = Integer.parseInt(str.substring(2), 16);
            Assert.assertEquals((long)i, (long)val);
        }
        Assert.assertEquals((Object)"\\u0999", (Object)CharUtils.unicodeEscaped((char)'\u0999'));
        Assert.assertEquals((Object)"\\u1001", (Object)CharUtils.unicodeEscaped((char)'\u1001'));
    }

    @Test
    public void testToUnicodeEscaped_Character() {
        Assert.assertEquals(null, (Object)CharUtils.unicodeEscaped(null));
        Assert.assertEquals((Object)"\\u0041", (Object)CharUtils.unicodeEscaped((Character)CHARACTER_A));
    }

    @Test
    public void testIsAscii_char() {
        Assert.assertTrue((boolean)CharUtils.isAscii((char)'a'));
        Assert.assertTrue((boolean)CharUtils.isAscii((char)'A'));
        Assert.assertTrue((boolean)CharUtils.isAscii((char)'3'));
        Assert.assertTrue((boolean)CharUtils.isAscii((char)'-'));
        Assert.assertTrue((boolean)CharUtils.isAscii((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAscii((char)'\u00a9'));
        for (int i = 0; i < 128; ++i) {
            if (i < 128) {
                Assert.assertTrue((boolean)CharUtils.isAscii((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAscii((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiPrintable_char() {
        Assert.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'a'));
        Assert.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'A'));
        Assert.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'3'));
        Assert.assertTrue((boolean)CharUtils.isAsciiPrintable((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiPrintable((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiPrintable((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 32 && i <= 126) {
                Assert.assertTrue((boolean)CharUtils.isAsciiPrintable((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiPrintable((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiControl_char() {
        Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)'a'));
        Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)'A'));
        Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)'-'));
        Assert.assertTrue((boolean)CharUtils.isAsciiControl((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i < 32 || i == 127) {
                Assert.assertTrue((boolean)CharUtils.isAsciiControl((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiControl((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlpha_char() {
        Assert.assertTrue((boolean)CharUtils.isAsciiAlpha((char)'a'));
        Assert.assertTrue((boolean)CharUtils.isAsciiAlpha((char)'A'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlpha((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122) {
                Assert.assertTrue((boolean)CharUtils.isAsciiAlpha((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiAlpha((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphaUpper_char() {
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'a'));
        Assert.assertTrue((boolean)CharUtils.isAsciiAlphaUpper((char)'A'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90) {
                Assert.assertTrue((boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiAlphaUpper((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphaLower_char() {
        Assert.assertTrue((boolean)CharUtils.isAsciiAlphaLower((char)'a'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'A'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 97 && i <= 122) {
                Assert.assertTrue((boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiAlphaLower((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiNumeric_char() {
        Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'a'));
        Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'A'));
        Assert.assertTrue((boolean)CharUtils.isAsciiNumeric((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 48 && i <= 57) {
                Assert.assertTrue((boolean)CharUtils.isAsciiNumeric((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiNumeric((char)((char)i)));
        }
    }

    @Test
    public void testIsAsciiAlphanumeric_char() {
        Assert.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'a'));
        Assert.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'A'));
        Assert.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)'3'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'-'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'\n'));
        Assert.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)'\u00a9'));
        for (int i = 0; i < 196; ++i) {
            if (i >= 65 && i <= 90 || i >= 97 && i <= 122 || i >= 48 && i <= 57) {
                Assert.assertTrue((boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
                continue;
            }
            Assert.assertFalse((boolean)CharUtils.isAsciiAlphanumeric((char)((char)i)));
        }
    }

    @Test
    public void testCompare() {
        Assert.assertTrue((CharUtils.compare((char)'a', (char)'b') < 0 ? 1 : 0) != 0);
        Assert.assertTrue((CharUtils.compare((char)'c', (char)'c') == 0 ? 1 : 0) != 0);
        Assert.assertTrue((CharUtils.compare((char)'c', (char)'a') > 0 ? 1 : 0) != 0);
    }
}

