/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class StringUtilsEqualsIndexOfTest {
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();
    private static final String BAR = "bar";
    private static final String CharU20000 = "\ud840\udc00";
    private static final String CharU20001 = "\ud840\udc01";
    private static final String FOO = "foo";
    private static final String FOOBAR = "foobar";
    private static final String[] FOOBAR_SUB_ARRAY = new String[]{"ob", "ba"};

    @Test
    public void testCustomCharSequence() {
        Assert.assertThat((Object)new CustomCharSequence(FOO), (Matcher)IsNot.not((Object)FOO));
        Assert.assertThat((Object)FOO, (Matcher)IsNot.not((Object)new CustomCharSequence(FOO)));
        Assert.assertEquals((Object)new CustomCharSequence(FOO), (Object)new CustomCharSequence(FOO));
    }

    @Test
    public void testEquals() {
        StringBuilder fooCs = new StringBuilder(FOO);
        StringBuilder barCs = new StringBuilder(BAR);
        StringBuilder foobarCs = new StringBuilder(FOOBAR);
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)fooCs));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new StringBuilder(FOO)));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new CustomCharSequence(FOO)));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)new CustomCharSequence(FOO), (CharSequence)fooCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)barCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)fooCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)fooCs, (CharSequence)foobarCs));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)foobarCs, (CharSequence)fooCs));
    }

    @Test
    public void testEqualsOnStrings() {
        Assert.assertTrue((boolean)StringUtils.equals(null, null));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)BAR));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, null));
        Assert.assertFalse((boolean)StringUtils.equals(null, (CharSequence)FOO));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOO, (CharSequence)FOOBAR));
        Assert.assertFalse((boolean)StringUtils.equals((CharSequence)FOOBAR, (CharSequence)FOO));
    }

    @Test
    public void testEqualsIgnoreCase() {
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase(null, null));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'o', 'o'})));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)new String(new char[]{'f', 'O', 'O'})));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, (CharSequence)BAR));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)FOO, null));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase(null, (CharSequence)FOO));
        Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((CharSequence)"abcd", (CharSequence)"abcd "));
    }

    @Test
    public void testEqualsAny() {
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[0]));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new String[0]));
        Assert.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'o', 'o'})}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'O', 'O'})}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null}));
        Assert.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOOBAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertTrue((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{null, null}));
        Assert.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])new CharSequence[]{FOO, BAR, FOOBAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{null, BAR}));
        Assert.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null, "", FOO, BAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase()}));
        Assert.assertFalse((boolean)StringUtils.equalsAny(null, (CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence(FOO)}));
        Assert.assertTrue((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder(FOO)}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence("fOo")}));
        Assert.assertFalse((boolean)StringUtils.equalsAny((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder("fOo")}));
    }

    @Test
    public void testEqualsAnyIgnoreCase() {
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[0]));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new String[0]));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase()}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO, new String(new char[]{'f', 'o', 'o'})}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, new String(new char[]{'f', 'O', 'O'})}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOOBAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{FOO}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{null, null}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])new CharSequence[]{FOO, BAR, FOOBAR}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{null, BAR}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{BAR, null, "", FOO.toUpperCase(), BAR}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{FOO.toUpperCase()}));
        Assert.assertFalse((boolean)StringUtils.equalsAnyIgnoreCase(null, (CharSequence[])null));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{new CustomCharSequence("fOo")}));
        Assert.assertTrue((boolean)StringUtils.equalsAnyIgnoreCase((CharSequence)FOO, (CharSequence[])new CharSequence[]{new StringBuilder("fOo")}));
    }

    @Test
    public void testCompare_StringString() {
        Assert.assertTrue((StringUtils.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare(null, (String)"a") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", null) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"abc") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", (String)"b") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"b", (String)"a") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", (String)"B") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"abd") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"ab", (String)"abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"ab", (String)"ab ") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"ab ") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare_StringStringBoolean() {
        Assert.assertTrue((StringUtils.compare(null, null, (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare(null, (String)"a", (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare(null, (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", null, (boolean)true) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", null, (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"abc", (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"b", (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"a", (String)"B", (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"abd", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"ab", (String)"abc", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"ab", (String)"ab ", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compare((String)"abc", (String)"ab ", (boolean)false) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareIgnoreCase_StringString() {
        Assert.assertTrue((StringUtils.compareIgnoreCase(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", null) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"abc") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABC") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"b") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"b", (String)"a") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"B") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"A", (String)"b") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABD") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"ABC") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"AB ") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"AB ") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareIgnoreCase_StringStringBoolean() {
        Assert.assertTrue((StringUtils.compareIgnoreCase(null, null, (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a", (boolean)true) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase(null, (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", null, (boolean)true) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", null, (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"abc", (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABC", (boolean)false) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"b", (String)"a", (boolean)false) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"a", (String)"B", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"A", (String)"b", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"ABD", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"ABC", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"ab", (String)"AB ", (boolean)false) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringUtils.compareIgnoreCase((String)"abc", (String)"AB ", (boolean)false) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIndexOf_char() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testIndexOf_charInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (int)32, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", (int)32, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)0));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)3));
        int CODE_POINT = 132878;
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)1));
        char[] tmp = new char[]{'\ud841'};
        builder = new StringBuilder();
        builder.append(tmp);
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)builder, (int)132878, (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)builder.toString(), (int)132878, (int)2));
    }

    @Test
    public void testIndexOf_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b"));
    }

    @Test
    public void testIndexOf_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOf((CharSequence)"abc", (CharSequence)"", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)5));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assert.assertEquals((long)7L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testIndexOfAny_StringCharArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"ab", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAny_StringCharArrayWithSupplementaryChars() {
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAny_StringString() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (String)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (String)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"za"));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAny((CharSequence)"zzabyycdxx", (String)"by"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"ab", (String)"z"));
    }

    @Test
    public void testIndexOfAny_StringStringArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testIndexOfAny_StringStringWithSupplementaryChars() {
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20000));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAny((CharSequence)"\ud840\udc00\ud840\udc01", (String)CharU20001));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20000));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAny((CharSequence)CharU20000, (String)CharU20001));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[0]));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'z', 'a'}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (char[])new char[]{'b', 'y'}));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'a', 'b'}));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"aba", (char[])new char[]{'z'}));
    }

    @Test
    public void testIndexOfAnyBut_StringCharArrayWithSupplementaryChars() {
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (char[])CharU20001.toCharArray()));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20000.toCharArray()));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (char[])CharU20001.toCharArray()));
    }

    @Test
    public void testIndexOfAnyBut_StringString() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut(null, (CharSequence)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"", (CharSequence)"ab"));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)""));
        Assert.assertEquals((long)3L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"za"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"zzabyycdxx", (CharSequence)"by"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"ab", (CharSequence)"z"));
    }

    @Test
    public void testIndexOfAnyBut_StringStringWithSupplementaryChars() {
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20000));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)"\ud840\udc00\ud840\udc01", (CharSequence)CharU20001));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20000));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfAnyBut((CharSequence)CharU20000, (CharSequence)CharU20001));
    }

    @Test
    public void testIndexOfIgnoreCase_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"", null));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)2L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assert.assertEquals((long)0L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
    }

    @Test
    public void testIndexOfIgnoreCase_StringInt() {
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)-1));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)1));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)3));
        Assert.assertEquals((long)4L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)4));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)5));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assert.assertEquals((long)1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
        Assert.assertEquals((long)5L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)5));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.indexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
    }

    @Test
    public void testLastIndexOf_char() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98));
    }

    @Test
    public void testLastIndexOf_charInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (int)32, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (int)32, (int)-1));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)98, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (int)97, (int)0));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (int)98, (int)2));
        int CODE_POINT = 132878;
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)2));
        builder.append("aaaaa");
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)4));
        char[] tmp = new char[]{'\ud841'};
        builder = new StringBuilder();
        builder.append(tmp);
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        builder.appendCodePoint(132878);
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.lastIndexOf((CharSequence)builder, (int)132878, (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)builder.toString(), (int)132878, (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.lastIndexOf((CharSequence)builder.toString(), (int)132878, (int)1));
    }

    @Test
    public void testLastIndexOf_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)8L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"ab"));
    }

    @Test
    public void testLastIndexOf_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOf((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)8));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)8));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)7));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"12345678", (CharSequence)"8", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)"aabaabaa", (CharSequence)"ba", (int)3));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOf((CharSequence)new StringBuilder("aabaabaa"), (CharSequence)"b", (int)3));
    }

    @Test
    public void testLastIndexOfAny_StringStringArray() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new CharSequence[0]));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])FOOBAR_SUB_ARRAY));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[0]));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{"llll"}));
        Assert.assertEquals((long)6L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{""}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{"a"}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)"", (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny((CharSequence)FOOBAR, (CharSequence[])new String[]{null}));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfAny(null, (CharSequence[])new String[]{null}));
    }

    @Test
    public void testLastIndexOfIgnoreCase_String() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)""));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"a"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)""));
        Assert.assertEquals((long)8L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)""));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"a"));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"b"));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"ab"));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB"));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"ab", (CharSequence)"AAB"));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AAB"));
    }

    @Test
    public void testLastIndexOfIgnoreCase_StringInt() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase(null, (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)3L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)7L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)8));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)8));
        Assert.assertEquals((long)4L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)8));
        Assert.assertEquals((long)2L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assert.assertEquals((long)5L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assert.assertEquals((long)1L, (long)StringUtils.lastIndexOfIgnoreCase((CharSequence)"aab", (CharSequence)"AB", (int)1));
    }

    @Test
    public void testLastOrdinalIndexOf() {
        Assert.assertEquals((long)-1L, (long)StringUtils.lastOrdinalIndexOf(null, (CharSequence)"*", (int)42));
        Assert.assertEquals((long)-1L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"*", null, (int)42));
        Assert.assertEquals((long)0L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"", (CharSequence)"", (int)42));
        Assert.assertEquals((long)7L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)6L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)5L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assert.assertEquals((long)8L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assert.assertEquals((long)8L, (long)StringUtils.lastOrdinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
    }

    @Test
    public void testOrdinalIndexOf() {
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MIN_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)-1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)2));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)2));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)5L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)2));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf(null, null, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"", null, (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"a", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"b", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"ab", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aabaabaa", (CharSequence)"", (int)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)3));
        Assert.assertEquals((long)3L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)4));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)5));
        Assert.assertEquals((long)5L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)6));
        Assert.assertEquals((long)6L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)7));
        Assert.assertEquals((long)7L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)8));
        Assert.assertEquals((long)8L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)9));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaaaaa", (CharSequence)"a", (int)10));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)1));
        Assert.assertEquals((long)1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)2));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)3));
        Assert.assertEquals((long)3L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)4));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)5));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"aaaaaa", (CharSequence)"aa", (int)6));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)2));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"ababab", (CharSequence)"aba", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)3));
        Assert.assertEquals((long)-1L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)4));
    }

    @Test
    public void testLANG1193() {
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"abc", (CharSequence)"ab", (int)1));
    }

    @Test
    public void testLANG1241_1() {
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)1));
        Assert.assertEquals((long)3L, (long)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)2));
        Assert.assertEquals((long)6L, (long)StringUtils.ordinalIndexOf((CharSequence)"abaabaab", (CharSequence)"ab", (int)3));
    }

    @Test
    public void testLANG1241_2() {
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababa", (CharSequence)"aba", (int)3));
        Assert.assertEquals((long)0L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)1));
        Assert.assertEquals((long)2L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)2));
        Assert.assertEquals((long)4L, (long)StringUtils.ordinalIndexOf((CharSequence)"abababab", (CharSequence)"abab", (int)3));
    }

    private static class CustomCharSequence
    implements CharSequence {
        private final CharSequence seq;

        CustomCharSequence(CharSequence seq) {
            this.seq = seq;
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CustomCharSequence(this.seq.subSequence(start, end));
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CustomCharSequence)) {
                return false;
            }
            CustomCharSequence other = (CustomCharSequence)obj;
            return this.seq.equals(other.seq);
        }

        public int hashCode() {
            return this.seq.hashCode();
        }

        @Override
        public String toString() {
            return this.seq.toString();
        }
    }
}

